
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Email Settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-style'); ?>
    <link rel="stylesheet" href="<?php echo e(static_asset('admin/css/summernote-bs4.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('email_setting_active'); ?>
    active
<?php $__env->stopSection(); ?>
<?php $__env->startSection('setup'); ?>
    active
<?php $__env->stopSection(); ?>
<?php $__env->startSection('email.setting'); ?>
    active
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main-content'); ?>
    <section class="section">
        <div class="section-body">
            <h2 class="section-title"><?php echo e(__('Settings')); ?></h2>
            <div id="output-status"></div>
            <div class="row">
                <?php echo $__env->make('admin.system-setup.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="col-md-9">
                    <div class="card email-card">
                        <div class="card-header">
                            <h4><?php echo e(__('Email Settings')); ?></h4>
                            <form action="">
                                <div class="form-group">
                                    <a href="" class="btn btn-outline-primary cache-btn" data-toggle="modal"
                                       data-target="#exampleModal">
                                        <?php echo e(__('Test Mail')); ?>

                                    </a>
                                </div>
                            </form>
                        </div>
                        <div class="col-md-10 middle card-body card-body-paddding">
                            <form action="<?php echo e(route('admin.email.setting.update')); ?>" method="post"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('put'); ?>
                                <div class="form-group">
                                    <label for="mail_driver" class="form-control-label"><?php echo e(__('Mail Driver')); ?></label>
                                    <div class="custom-file">
                                        <?php
                                            $mail_driver = settingHelper('mail_driver');
                                        ?>
                                        <select class="form-control selectric" name="mail_driver" id="mail_driver">
                                            <option
                                                <?php echo e(old('mail_driver') =='smtp' ? 'selected' : (((old('mail_driver') =='' && $mail_driver =='smtp')  || $mail_driver == '') ? 'selected' : '' )); ?> value="smtp">
                                                SMTP (<?php echo e(__('Recommended')); ?>)
                                            </option>
                                            <option
                                                <?php echo e(old('mail_driver') =='sendgrid' ? 'selected' : ((old('mail_driver') =='' && $mail_driver =='sendgrid') ? 'selected' : '' )); ?> value="sendgrid">
                                                SendGrid
                                            </option>
                                            <option
                                                <?php echo e(old('mail_driver') =='mailgun' ? 'selected' : ((old('mail_driver') =='' && $mail_driver =='mailgun') ? 'selected' : '' )); ?> value="mailgun">
                                                MailGun
                                            </option>
                                            <option
                                                <?php echo e(old('mail_driver') =='sendmail' ? 'selected' : ((old('mail_driver') =='' && $mail_driver =='sendmail') ? 'selected' : '' )); ?> value="sendmail">
                                                Sendmail
                                            </option>
                                            <option
                                                    <?php echo e(old('mail_driver') =='sendinBlue' ? 'selected' : ((old('mail_driver') =='' && $mail_driver =='sendinBlue') ? 'selected' : '' )); ?> value="sendinBlue">
                                                SendinBlue
                                            </option>
                                            <option
                                                    <?php echo e(old('mail_driver') =='zohoSMTP' ? 'selected' : ((old('mail_driver') =='' && $mail_driver =='zohoSMTP') ? 'selected' : '' )); ?> value="zohoSMTP">
                                                ZohoSMTP
                                            </option>
                                            <option
                                                    <?php echo e(old('mail_driver') =='mailjet' ? 'selected' : ((old('mail_driver') =='' && $mail_driver =='mailjet') ? 'selected' : '' )); ?> value="mailjet">
                                                Mailjet
                                            </option>
                                        </select>
                                    </div>
                                    <?php if($errors->has('mail_driver')): ?>
                                        <div class="invalid-feedback">
                                            <p><?php echo e($errors->first('mail_driver')); ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div id="smtpDiv"
                                     class="<?php echo e($mail_driver == 'sendmail' ? 'd-none' : ( old('mail_driver') =='smtp' ? '' : (((old('mail_driver') =='' && $mail_driver =='smtp')  || ($mail_driver == '' && old('mail_driver') =='')) ? '' : 'd-none' )
|| (old('mail_driver') =='mailgun'? '' : (((old('mail_driver') =='' && $mail_driver =='mailgun')  || ($mail_driver == '' && old('mail_driver') =='')) ? '' : 'd-none' ))
|| (old('mail_driver') =='sendgrid'? '' : (((old('mail_driver') =='' && $mail_driver =='sendgrid')  || ($mail_driver == '' && old('mail_driver') =='')) ? '' : 'd-none' ))
|| (old('mail_driver') =='sendinBlue'? '' : (((old('mail_driver') =='' && $mail_driver =='sendinBlue')  || ($mail_driver == '' && old('mail_driver') =='')) ? '' : 'd-none' ))
|| (old('mail_driver') =='zohoSMTP'? '' : (((old('mail_driver') =='' && $mail_driver =='zohoSMTP')  || ($mail_driver == '' && old('mail_driver') =='')) ? '' : 'd-none' ))
|| (old('mail_driver') =='mailjet'? '' : (((old('mail_driver') =='' && $mail_driver =='mailjet')  || ($mail_driver == '' && old('mail_driver') =='')) ? '' : 'd-none' )))); ?>">
                                    <div class="form-group">
                                        <label for="smtp_mail_host"
                                               class="form-control-label"><?php echo e(__('Mail Host')); ?></label>
                                        <input type="text" name="smtp_mail_host"
                                               placeholder="<?php echo e(__('Enter mail host')); ?>"
                                               value="<?php echo e(old('smtp_mail_host') ? old('smtp_mail_host') : env('MAIL_HOST')); ?>"
                                               class="form-control" id="smtp_mail_host">
                                        <?php if($errors->has('smtp_mail_host')): ?>
                                            <div class="invalid-feedback">
                                                <p><?php echo e($errors->first('smtp_mail_host')); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group">
                                        <label for="smtp_mail_port"
                                               class="form-control-label"><?php echo e(__('Mail Port')); ?></label>
                                        <input type="number" name="smtp_mail_port"
                                               placeholder="<?php echo e(__('Enter mail port')); ?>"
                                               value="<?php echo e(old('smtp_mail_port') ? old('smtp_mail_port') : env('MAIL_PORT')); ?>"
                                               class="form-control" id="smtp_mail_port">
                                        <?php if($errors->has('smtp_mail_port')): ?>
                                            <div class="invalid-feedback">
                                                <p><?php echo e($errors->first('smtp_mail_port')); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group">
                                        <label for="smtp_mail_address"
                                               class="form-control-label"><?php echo e(__('mail_from_address')); ?></label>
                                        <input type="email" name="smtp_mail_address"
                                               placeholder="<?php echo e(__('Enter mail address')); ?>"
                                               value="<?php echo e(old('smtp_mail_address') ? old('smtp_mail_address') : (config('app.demo_mode') ? emailAddressMask(settingHelper('smtp_mail_address')) : env('MAIL_FROM_ADDRESS'))); ?>"
                                               class="form-control" id="smtp_mail_address">
                                        <?php if($errors->has('smtp_mail_address')): ?>
                                            <div class="invalid-feedback">
                                                <p><?php echo e($errors->first('smtp_mail_address')); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group">
                                        <label for="smtp_name" class="form-control-label"><?php echo e(__('Name')); ?></label>
                                        <input type="text" name="smtp_name" placeholder="<?php echo e(__('Enter name')); ?>"
                                               value="<?php echo e(old('smtp_name') ? old('smtp_name') : env('MAIL_FROM_NAME')); ?>"
                                               class="form-control" id="smtp_name">
                                        <?php if($errors->has('smtp_name')): ?>
                                            <div class="invalid-feedback">
                                                <p><?php echo e($errors->first('smtp_name')); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group">
                                        <label for="smtp_mail_username"
                                               class="form-control-label"><?php echo e(__('Mail Username')); ?></label>
                                        <input type="text" name="smtp_mail_username"
                                               placeholder="<?php echo e(__('Enter mail username')); ?>"
                                               value="<?php echo e(old('smtp_mail_username') ? old('smtp_mail_username') : (config('app.demo_mode') ? Str::of(settingHelper('smtp_mail_username'))->mask('*', 0, strlen(settingHelper('smtp_mail_username'))-3) : env('MAIL_USERNAME'))); ?>"
                                               class="form-control" id="smtp_mail_username">
                                        <?php if($errors->has('smtp_mail_username')): ?>
                                            <div class="invalid-feedback">
                                                <p><?php echo e($errors->first('smtp_mail_username')); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group">
                                        <label for="smtp_mail_password"
                                               class="form-control-label"><?php echo e(__('Mail Password')); ?></label>
                                        <input type="password" name="smtp_mail_password"
                                               placeholder="<?php echo e(__('Enter mail password')); ?>"
                                               value="<?php echo e(old('smtp_mail_password') ? old('smtp_mail_password') : (config('app.demo_mode') ? "********" : env('MAIL_PASSWORD'))); ?>"
                                               class="form-control" id="smtp_mail_password">
                                        <?php if($errors->has('smtp_mail_password')): ?>
                                            <div class="invalid-feedback">
                                                <p><?php echo e($errors->first('smtp_mail_password')); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group">
                                        <label for="smtp_mail_encryption_type"
                                               class="form-control-label"><?php echo e(__('Mail Encryption Type')); ?></label>
                                        <div class="custom-file">
                                            <select class="form-control selectric" name="smtp_mail_encryption_type"
                                                    id="smtp_mail_encryption_type">
                                                <option value=""><?php echo e(__('Select Encryption Type')); ?></option>
                                                <option <?php echo e(env('MAIL_ENCRYPTION') == 'ssl' ? "selected" : ""); ?> value="ssl">SSL</option>
                                                <option <?php echo e(env('MAIL_ENCRYPTION') == 'tls' ? "selected" : ""); ?> value="tls">TLS</option>
                                            </select>
                                        </div>
                                        <?php if($errors->has('smtp_mail_encryption_type')): ?>
                                            <div class="invalid-feedback">
                                                <p><?php echo e($errors->first('smtp_mail_encryption_type')); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div id="sendMailDiv"
                                     class="<?php echo e(old('mail_driver') =='sendmail' ? '' : (old('mail_driver') =='' && $mail_driver =='sendmail' ? '' : 'd-none' )); ?>">
                                    <div class="form-group">
                                        <label for="sendmail_path" class="form-control-label"><?php echo e(__('Path')); ?></label>
                                        <input type="text" name="sendmail_path"
                                               placeholder="<?php echo e(__('Enter sendmail path')); ?>"
                                               value="<?php echo e(old('sendmail_path') ? old('sendmail_path') : env('SENDMAIL_PATH')); ?>"
                                               class="form-control" id="sendmail_path">
                                        <?php if($errors->has('sendmail_path')): ?>
                                            <div class="invalid-feedback">
                                                <p><?php echo e($errors->first('sendmail_path')); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="mail_signature"
                                           class="form-control-label"><?php echo e(__('Mail Signature')); ?></label>
                                    <div>
                                        <textarea class="summernote" id="mail_signature"
                                                  name="mail_signature"><?php echo e(old('mail_signature') ? old('mail_signature') : settingHelper('mail_signature')); ?></textarea>
                                    </div>
                                    <?php if($errors->has('mail_signature')): ?>
                                        <div class="invalid-feedback">
                                            <p><?php echo e($errors->first('mail_signature')); ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="form-group text-right">
                                    <button type="submit" class="btn btn-outline-primary" tabindex="4"> <?php echo e(__('update')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalTitle"
         aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(__('Send Test Mail')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="bx bx-x"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('send.test.email')); ?>" method="POST">
                    <div class="modal-body">

                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="send_to" class="form-control-label"><?php echo e(__('Send To')); ?></label>
                            <input type="email" name="send_to" class="form-control" id="send_to">
                            <?php if($errors->has('send_to')): ?>
                                <div class="invalid-feedback">
                                    <p><?php echo e($errors->first('send_to')); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-outline-primary"><?php echo e(__('Send')); ?></button>
                    </div>

                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('page-script'); ?>
    <script src="<?php echo e(static_asset('admin/js/summernote-bs4.js')); ?>"></script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/maliklaptops/yoori.maliklaptops.com/resources/views/admin/system-setup/email-settings.blade.php ENDPATH**/ ?>