

<?php $__env->startSection('title', __('Mail Settings')); ?>

<?php $__env->startSection('content'); ?>
<!-- main Section -->
<div class="main-body">
	<div class="container-fluid">
		<?php $vipc = vipc(); ?>
		<?php if($vipc['bkey'] == 0): ?> 
		<?php echo $__env->make('backend.partials.vipc', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<?php else: ?>
		<div class="row mt-25">
			<div class="col-lg-12">
				<div class="card">
					<div class="card-header"><?php echo e(__('Settings')); ?></div>
					<div class="card-body tabs-area p-0">
						<?php echo $__env->make('backend.partials.settings_tabs_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
						<div class="tabs-body">
							<!--Mail Setting-->
							<div id="GoogleRecaptchaSetting">
								<form novalidate="" data-validate="parsley" id="submit_formId">
									<div class="row">
										<div class="col-lg-8">
											<div class="tw_checkbox checkbox_group">
												<input id="ismail" name="ismail" type="checkbox" <?php echo e($datalist['ismail'] == 1 ? 'checked' : ''); ?>>
												<label for="ismail"><?php echo e(__('Enable/Disable')); ?></label>
												<span></span>
											</div>
											<div class="form-group">
												<label for="from_name"><?php echo e(__('From Name')); ?><span class="red">*</span></label>
												<input type="text" name="from_name" id="from_name" class="form-control" value="<?php echo e($datalist['from_name']); ?>">
											</div>
											<div class="form-group">
												<label for="from_mail"><?php echo e(__('From Mail Address')); ?><span class="red">*</span></label>
												<input type="text" name="from_mail" id="from_mail" class="form-control" value="<?php echo e($datalist['from_mail']); ?>">
												<small class="form-text text-muted">The mail address must be a webmail address. e.g. <strong>admin@companyname.com</strong></small>
											</div>
											<div class="form-group">
												<label for="to_name"><?php echo e(__('To Name')); ?><span class="red">*</span></label>
												<input type="text" name="to_name" id="to_name" class="form-control" value="<?php echo e($datalist['to_name']); ?>">
											</div>
											<div class="form-group">
												<label for="to_mail"><?php echo e(__('To Mail Address')); ?><span class="red">*</span></label>
												<input type="text" name="to_mail" id="to_mail" class="form-control" value="<?php echo e($datalist['to_mail']); ?>">
											</div>
											<div class="form-group">
												<label for="mailer"><?php echo e(__('Mailer')); ?><span class="red">*</span></label>
												<select name="mailer" id="mailer" class="chosen-select form-control">
													<option value="mail" <?php echo e($datalist['mailer'] == 'mail' ? 'selected="selected"' : ''); ?>>PHP Mail</option>
													<option value="smtp" <?php echo e($datalist['mailer'] == 'smtp' ? 'selected="selected"' : ''); ?>>SMTP</option>
												</select>
											</div>

											<div id="is_smtp" <?php echo e($datalist['mailer'] == 'smtp' ? '' : 'class=dnone'); ?>>
												<div class="form-group">
													<label for="smtp_host"><?php echo e(__('SMTP Host')); ?><span class="red">*</span></label>
													<input type="text" name="smtp_host" id="smtp_host" class="form-control" value="<?php echo e($datalist['smtp_host']); ?>">
												</div>
												<div class="form-group">
													<label for="smtp_port"><?php echo e(__('SMTP Port')); ?><span class="red">*</span></label>
													<input type="number" name="smtp_port" id="smtp_port" class="form-control" value="<?php echo e($datalist['smtp_port']); ?>" placeholder="587">
												</div>
												
												<div class="form-group">
													<label for="smtp_security"><?php echo e(__('SMTP Security')); ?><span class="red">*</span></label>
													<select name="smtp_security" id="smtp_security" class="chosen-select form-control">
														<option value="tls" <?php echo e($datalist['smtp_security'] == 'tls' ? 'selected="selected"' : ''); ?>>TLS</option>
														<option value="ssl" <?php echo e($datalist['smtp_security'] == 'ssl' ? 'selected="selected"' : ''); ?>>SSL</option>
													</select>
												</div>
												<div class="form-group">
													<label for="smtp_username"><?php echo e(__('SMTP Username')); ?><span class="red">*</span></label>
													<input type="text" name="smtp_username" id="smtp_username" class="form-control" value="<?php echo e($datalist['smtp_username']); ?>">
												</div>
												<div class="form-group">
													<label for="smtp_password"><?php echo e(__('SMTP Password')); ?><span class="red">*</span></label>
													<input type="password" name="smtp_password" id="smtp_password" class="form-control" value="<?php echo e($datalist['smtp_password']); ?>">
												</div>
											</div>
										</div>
										<div class="col-lg-4"></div>
									</div>
									<div class="row tabs-footer mt-15">
										<div class="col-lg-12">
											<a id="submit-form" href="javascript:void(0);" class="btn blue-btn"><?php echo e(__('Save')); ?></a>
										</div>
									</div>
								</form>
							</div>
							<!--/Mail Setting-->
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php endif; ?>
	</div>
</div>
<!-- /main Section -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="<?php echo e(asset('public/backend/pages/mail-setting.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\resources\views/backend/mail-settings.blade.php ENDPATH**/ ?>