

<?php $__env->startSection('title', __('login')); ?>
<?php $gtext = gtext(); ?>

<?php $__env->startSection('meta-content'); ?>
	<meta name="keywords" content="<?php echo e($gtext['og_keywords']); ?>" />
	<meta name="description" content="<?php echo e($gtext['og_description']); ?>" />
	<meta property="og:title" content="<?php echo e($gtext['og_title']); ?>" />
	<meta property="og:site_name" content="<?php echo e($gtext['site_name']); ?>" />
	<meta property="og:description" content="<?php echo e($gtext['og_description']); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(url()->current()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('public/media/'.$gtext['og_image'])); ?>" />
	<meta property="og:image:width" content="600" />
	<meta property="og:image:height" content="315" />
	<?php if($gtext['fb_publish'] == 1): ?>
	<meta name="fb:app_id" property="fb:app_id" content="<?php echo e($gtext['fb_app_id']); ?>" />
	<?php endif; ?>
	<meta name="twitter:card" content="summary_large_image">
	<?php if($gtext['twitter_publish'] == 1): ?>
	<meta name="twitter:site" content="<?php echo e($gtext['twitter_id']); ?>">
	<meta name="twitter:creator" content="<?php echo e($gtext['twitter_id']); ?>">
	<?php endif; ?>
	<meta name="twitter:url" content="<?php echo e(url()->current()); ?>">
	<meta name="twitter:title" content="<?php echo e($gtext['og_title']); ?>">
	<meta name="twitter:description" content="<?php echo e($gtext['og_description']); ?>">
	<meta name="twitter:image" content="<?php echo e(asset('public/media/'.$gtext['og_image'])); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('frontend.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<main class="main">
	<!-- Page Breadcrumb -->
	<div class="breadcrumb-section">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a></li>
							<li class="breadcrumb-item active" aria-current="page"><?php echo e(__('login')); ?></li>
						</ol>
					</nav>
				</div>
				<div class="col-lg-6">
					<div class="page-title">
						<h1><?php echo e(__('login')); ?></h1>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Page Breadcrumb/ -->
	
	<!-- Inner Section -->
	<section class="inner-section inner-section-bg">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
					<div class="register">
						<h4><?php echo e(__('login')); ?></h4>
						<p><?php echo e(__('Please enter your email address and password')); ?></p>

						<?php if(Session::has('fail')): ?>
						<div class="alert alert-danger">
							<?php echo e(Session::get('fail')); ?>

						</div>
						<?php endif; ?>
						<?php if(session('message')): ?>
							<div class="alert alert-danger"><?php echo e(session('message')); ?></div>
						<?php endif; ?>
						<form class="form" method="POST" action="<?php echo e(route('frontend.customer-login')); ?>">
							<?php echo csrf_field(); ?>
							<div class="form-group">
								<input name="email" type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__('Email Address')); ?>" value="<?php echo e(old('email')); ?>" required />
                                <?php if($errors->has('email')): ?>
                                <span class="text-danger"><?php echo e($errors->first('email')); ?></span>
                                <?php endif; ?>
							</div>
							<div class="form-group">
								<input name="password" type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__('Password')); ?>" required />
                                <?php if($errors->has('password')): ?>
                                <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                                <?php endif; ?>
							</div>
							<div class="tw_checkbox checkbox_group">
								<input id="remember" name="remember" type="checkbox" <?php echo e(old('remember') ? 'checked' : ''); ?>>
								<label for="remember"><?php echo e(__('Remember me')); ?></label>
								<span></span>
							</div>
							<input type="submit" class="btn theme-btn full" value="<?php echo e(__('login')); ?>">
						</form>
						<?php if(Route::has('frontend.reset')): ?>
						<h3><a href="<?php echo e(route('frontend.reset')); ?>"><?php echo e(__('Forgot your password?')); ?></a></h3>
						<?php endif; ?>
						<?php if(Route::has('frontend.register')): ?>
						<h3><a href="<?php echo e(route('frontend.register')); ?>"><?php echo e(__('Sign up for an account')); ?></a></h3>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- /Inner Section/ -->
</main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?>	
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitede1/ecom18.elitedesign.com.bd/resources/views/frontend/login.blade.php ENDPATH**/ ?>