

<?php $__env->startSection('title', $metadata['name']); ?>
<?php $gtext = gtext(); ?>

<?php $__env->startSection('meta-content'); ?>
	<meta name="keywords" content="<?php echo e($metadata['og_keywords']); ?>" />
	<meta name="description" content="<?php echo e($metadata['og_description']); ?>" />
	<meta property="og:title" content="<?php echo e($metadata['og_title']); ?>" />
	<meta property="og:site_name" content="<?php echo e($gtext['site_name']); ?>" />
	<meta property="og:description" content="<?php echo e($metadata['og_description']); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(url()->current()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('public/media/'.$metadata['og_image'])); ?>" />
	<meta property="og:image:width" content="600" />
	<meta property="og:image:height" content="315" />
	<?php if($gtext['fb_publish'] == 1): ?>
	<meta name="fb:app_id" property="fb:app_id" content="<?php echo e($gtext['fb_app_id']); ?>" />
	<?php endif; ?>
	<meta name="twitter:card" content="summary_large_image">
	<?php if($gtext['twitter_publish'] == 1): ?>
	<meta name="twitter:site" content="<?php echo e($gtext['twitter_id']); ?>">
	<meta name="twitter:creator" content="<?php echo e($gtext['twitter_id']); ?>">
	<?php endif; ?>
	<meta name="twitter:url" content="<?php echo e(url()->current()); ?>">
	<meta name="twitter:title" content="<?php echo e($metadata['og_title']); ?>">
	<meta name="twitter:description" content="<?php echo e($metadata['og_description']); ?>">
	<meta name="twitter:image" content="<?php echo e(asset('public/media/'.$metadata['og_image'])); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('frontend.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<main class="main">
	<!-- Page Breadcrumb -->
	<div class="breadcrumb-section">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a></li>
							<li class="breadcrumb-item active" aria-current="page"><?php echo e($metadata['name']); ?></li>
						</ol>
					</nav>
				</div>
				<div class="col-lg-6">
					<div class="page-title">
						<h1><?php echo e($metadata['name']); ?></h1>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Page Breadcrumb/ -->
	
	<!-- Inner Section -->
	<section class="inner-section inner-section-bg">
		<div class="container">
			<?php if($category_variation == 'left_sidebar'): ?>
			<div class="row">
				<div class="col-lg-3">
					<?php echo $__env->make('frontend.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				</div>
				<div class="col-lg-9">
			<?php elseif($category_variation == 'right_sidebar'): ?>
			<div class="row">
				<div class="col-lg-9">
			<?php endif; ?>
					<div class="filter-card">
						<div class="row">
							<div class="col-6 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
								<div class="filter_select">
									<select name="num" id="num" class="form-select form-select-sm">
										<option value=""><?php echo e(__('Showing')); ?></option>
										<?php if(($category_variation == 'left_sidebar') || ($category_variation == 'right_sidebar')): ?>
										<option value="9">9</option>
										<option value="15">15</option>
										<option value="24">24</option>
										<?php else: ?>
										<option value="12">12</option>
										<option value="20">20</option>
										<option value="28">28</option>
										<?php endif; ?>
									</select>
								</div>
							</div>
							<div class="col-6 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
								<div class="sort_by_select">
									<select name="sortby" id="sortby" class="form-select form-select-sm">
										<option value="default_sorting" selected=""><?php echo e(__('Default')); ?></option>
										<option value="date_asc">Oldest</option>
										<option value="date_desc">Newest</option>
										<option value="name_asc">Name: A-Z</option>
										<option value="name_desc">Name : Z-A</option>
									</select>
								</div>
							</div>
						</div>
					</div>
					
					<div id="tp_datalist">
						<?php echo $__env->make('frontend.partials.product-category-grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div>
			
			<?php if($category_variation == 'left_sidebar'): ?>
				</div>
			</div>
			<?php elseif($category_variation == 'right_sidebar'): ?>
				</div>
				<div class="col-lg-3">
					<?php echo $__env->make('frontend.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				</div>
			</div>
			<?php endif; ?>
		</div>
	</section>
	<!-- /Inner Section/ -->
	
</main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
var category_id = "<?php echo e(isset($params) ? $params['category_id'] : 0); ?>";
</script>
<script src="<?php echo e(asset('public/frontend/pages/product-category.js')); ?>"></script>
<?php $__env->stopPush(); ?>	
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitede1/ecommerce15.elitedesign.com.bd/resources/views/frontend/product-category.blade.php ENDPATH**/ ?>