<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Admin Login</title>
  	<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.1/css/all.css" integrity="sha384-gfdkjb5BdAXd+lj+gudLWI+BXq4IuLW5IT+brZEZsLFm++aCMlF1V92rMkPaX4PP" crossorigin="anonymous">
	<link rel="stylesheet" type="text/css" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
	<link rel="stylesheet" type="text/css" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js">
	<style type="text/css">
			/* Coded with love by Mutiullah Samim */
		body,
		html {
			margin: 0;
			padding: 0;
			height: 100%;
			background: #fff !important;
		}
		.user_card {
			height: 400px;
			width: 350px;
			margin-top: auto;
			margin-bottom: auto;
			background: #F85606;
			position: relative;
			display: flex;
			justify-content: center;
			flex-direction: column;
			padding: 10px;
			box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
			-webkit-box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
			-moz-box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
			border-radius: 5px;

		}
		.brand_logo_container {
			position: absolute;
			height: 170px;
			width: 170px;
			top: -75px;
			border-radius: 50%;
			background: #fff;
			padding: 10px;
			text-align: center;
		}
		.brand_logo {
			height: 150px;
			width: 150px;
			border-radius: 50%;
			border: 2px solid white;
		}
		.form_container {
			margin-top: 100px;
		}
		.login_btn {
			width: 100%;
			background: #F85606 !important;
			color: white !important;
		}
		.login_btn:focus {
			box-shadow: none !important;
			outline: 0px !important;
		}
		.login_container {
			padding: 0 2rem;
		}
		.input-group-text {
			background: #F85606 !important;
			color: white !important;
			border: 0 !important;
			border-radius: 0.25rem 0 0 0.25rem !important;
		}
		.input_user,
		.input_pass:focus {
			box-shadow: none !important;
			outline: 0px !important;
		}
		.custom-checkbox .custom-control-input:checked~.custom-control-label::before {
			background-color: #c0392b !important;
		}
	</style>
</head>
<body>
  <?php
  	$info = \App\Models\Information::first();
  ?>
	
	<main class="py-4">
		<div class="container">
		  <div class="row justify-content-center">
			<div class="col-md-8">
			  <div class="card">
				<div class="card-header">Login</div>

				<div class="card-body">
				  <form method="post" action="<?php echo e(route('admin.postLogin')); ?>">
					<?php if(session()->has('success')): ?>
					<div class="alert alert-danger">
					   <p><?php echo e(session()->get('success')); ?></p>
					</div>
					<?php endif; ?>
					<?php echo csrf_field(); ?>
					<div class="form-group row">
					  <label for="email" class="col-md-4 col-form-label text-md-right">User Name</label>
					  <div class="col-md-6">
						<input id="username" type="Username" class="form-control <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> " name="username" value="<?php echo e((isset($_COOKIE['user'])) ? $_COOKIE['user'] : old('username')); ?>">
					  </div>
					  <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($message); ?></strong>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
					</div>
					<div class="form-group row">
					  <label for="password" class="col-md-4 col-form-label text-md-right">Password</label>
					  <div class="col-md-6">
						<input id="password" type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" required="" autocomplete="current-password" value="<?php echo e((isset($_COOKIE['pass'])) ? $_COOKIE['pass'] : old('password')); ?>">
					  </div>
					  <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					  <span class="invalid-feedback" role="alert">
						  <strong><?php echo e($message); ?></strong>
					  </span>
				  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
					</div>
					<div class="form-group row">
					  <div class="col-md-6 offset-md-4">
						<div class="form-check">
						  <input class="form-check-input" type="checkbox" name="remember" id="remember">
						  <label class="form-check-label" for="remember"> Remember Me </label>
						  <a href="<?php echo e(route('password.request')); ?>" class="text-info">Forgot Password</a>
						</div>
					  </div>
					</div>
					<div class="form-group row mb-0">
					  <div class="col-md-8 offset-md-4">
						<button type="submit" class="btn btn-primary"> Login </button>
					  </div>

					</div>
				  </form>
				</div>
			  </div>
			</div>
		  </div>
		</div>
	  </main>
</body>
</html>
<?php /**PATH /home/elitede1/ecommerce4.elitedesign.com.bd/resources/views/backend/auth/login.blade.php ENDPATH**/ ?>