<section class="bg-dark py-5 text-light footer-widget">
    <div class="container">
        <div class="row">
            <div class="col-lg-5 col-xl-4 text-center text-md-left">
                <div class="mt-4">
                    <a href="<?php echo e(route('home')); ?>" class="d-block">
                        <?php if(get_setting('footer_logo') != null): ?>
                            <img class="lazyload" src="<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>" data-src="<?php echo e(uploaded_asset(get_setting('footer_logo'))); ?>" alt="<?php echo e(env('APP_NAME')); ?>" height="44">
                        <?php else: ?>
                            <img class="lazyload" src="<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>" data-src="<?php echo e(static_asset('assets/img/logo.png')); ?>" alt="<?php echo e(env('APP_NAME')); ?>" height="44">
                        <?php endif; ?>
                    </a>
                    <div class="my-3">
                        <?php echo get_setting('about_us_description',null,App::getLocale()); ?>

                    </div>
                    <div class="d-inline-block d-md-block mb-4">
                        <form class="form-inline" method="POST" action="<?php echo e(route('subscribers.store')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="form-group mb-0">
                                <input type="email" class="form-control" placeholder="<?php echo e(translate('Your Email Address')); ?>" name="email" required>
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <?php echo e(translate('Subscribe')); ?>

                            </button>
                        </form>
                    </div>
                    <div class="w-300px mw-100 mx-auto mx-md-0">
                        <?php if(get_setting('play_store_link') != null): ?>
                            <a href="<?php echo e(get_setting('play_store_link')); ?>" target="_blank" class="d-inline-block mr-3 ml-0">
                                <img src="<?php echo e(static_asset('assets/img/play.png')); ?>" class="mx-100 h-40px">
                            </a>
                        <?php endif; ?>
                        <?php if(get_setting('app_store_link') != null): ?>
                            <a href="<?php echo e(get_setting('app_store_link')); ?>" target="_blank" class="d-inline-block">
                                <img src="<?php echo e(static_asset('assets/img/app.png')); ?>" class="mx-100 h-40px">
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 ml-xl-auto col-md-4 mr-0">
                <div class="text-center text-md-left mt-4">
                    <h4 class="fs-13 text-uppercase fw-600 border-bottom border-gray-900 pb-2 mb-4">
                        <?php echo e(translate('Contact Info')); ?>

                    </h4>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                           <span class="d-block opacity-30"><?php echo e(translate('Address')); ?>:</span>
                           <span class="d-block opacity-70"><?php echo e(get_setting('contact_address',null,App::getLocale())); ?></span>
                        </li>
                        <li class="mb-2">
                           <span class="d-block opacity-30"><?php echo e(translate('Phone')); ?>:</span>
                           <span class="d-block opacity-70"><?php echo e(get_setting('contact_phone')); ?></span>
                        </li>
                        <li class="mb-2">
                           <span class="d-block opacity-30"><?php echo e(translate('Email')); ?>:</span>
                           <span class="d-block opacity-70">
                               <a href="mailto:<?php echo e(get_setting('contact_email')); ?>" class="text-reset"><?php echo e(get_setting('contact_email')); ?></a>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-2 col-md-4">
                <div class="text-center text-md-left mt-4">
                    <h4 class="fs-13 text-uppercase fw-600 border-bottom border-gray-900 pb-2 mb-4">
                        <?php echo e(get_setting('widget_one',null,App::getLocale())); ?>

                    </h4>
                    <ul class="list-unstyled">
                        <?php if( get_setting('widget_one_labels',null,App::getLocale()) !=  null ): ?>
                            <?php $__currentLoopData = json_decode( get_setting('widget_one_labels',null,App::getLocale()), true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="mb-2">
                                <a href="<?php echo e(json_decode( get_setting('widget_one_links'), true)[$key]); ?>" class="opacity-50 hov-opacity-100 text-reset">
                                    <?php echo e($value); ?>

                                </a>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 col-lg-2">
                <div class="text-center text-md-left mt-4">
                    <h4 class="fs-13 text-uppercase fw-600 border-bottom border-gray-900 pb-2 mb-4">
                        <?php echo e(translate('My Account')); ?>

                    </h4>
                    <ul class="list-unstyled">
                        <?php if(Auth::check()): ?>
                            <li class="mb-2">
                                <a class="opacity-50 hov-opacity-100 text-reset" href="<?php echo e(route('logout')); ?>">
                                    <?php echo e(translate('Logout')); ?>

                                </a>
                            </li>
                        <?php else: ?>
                            <li class="mb-2">
                                <a class="opacity-50 hov-opacity-100 text-reset" href="<?php echo e(route('user.login')); ?>">
                                    <?php echo e(translate('Login')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="mb-2">
                            <a class="opacity-50 hov-opacity-100 text-reset" href="<?php echo e(route('purchase_history.index')); ?>">
                                <?php echo e(translate('Order History')); ?>

                            </a>
                        </li>
                        <li class="mb-2">
                            <a class="opacity-50 hov-opacity-100 text-reset" href="<?php echo e(route('wishlists.index')); ?>">
                                <?php echo e(translate('My Wishlist')); ?>

                            </a>
                        </li>
                        <li class="mb-2">
                            <a class="opacity-50 hov-opacity-100 text-reset" href="<?php echo e(route('orders.track')); ?>">
                                <?php echo e(translate('Track Order')); ?>

                            </a>
                        </li>
                        <?php if(addon_is_activated('affiliate_system')): ?>
                            <li class="mb-2">
                                <a class="opacity-50 hov-opacity-100 text-light" href="<?php echo e(route('affiliate.apply')); ?>"><?php echo e(translate('Be an affiliate partner')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <?php if(get_setting('vendor_system_activation') == 1): ?>
                    <div class="text-center text-md-left mt-4">
                        <h4 class="fs-13 text-uppercase fw-600 border-bottom border-gray-900 pb-2 mb-4">
                            <?php echo e(translate('Be a Seller')); ?>

                        </h4>
                        <a href="<?php echo e(route('shops.create')); ?>" class="btn btn-primary btn-sm shadow-md">
                            <?php echo e(translate('Apply Now')); ?>

                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<!-- FOOTER -->
<footer class="pt-3 pb-7 pb-xl-3 bg-black text-light">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-4">
                <div class="text-center text-md-left" current-verison="<?php echo e(get_setting("current_version")); ?>">
                    <?php echo get_setting('frontend_copyright_text',null,App::getLocale()); ?>

                </div>
            </div>
            <div class="col-lg-4">
                <?php if( get_setting('show_social_links') ): ?>
                <ul class="list-inline my-3 my-md-0 social colored text-center">
                    <?php if( get_setting('facebook_link') !=  null ): ?>
                    <li class="list-inline-item">
                        <a href="<?php echo e(get_setting('facebook_link')); ?>" target="_blank" class="facebook"><i class="lab la-facebook-f"></i></a>
                    </li>
                    <?php endif; ?>
                    <?php if( get_setting('twitter_link') !=  null ): ?>
                    <li class="list-inline-item">
                        <a href="<?php echo e(get_setting('twitter_link')); ?>" target="_blank" class="twitter"><i class="lab la-twitter"></i></a>
                    </li>
                    <?php endif; ?>
                    <?php if( get_setting('instagram_link') !=  null ): ?>
                    <li class="list-inline-item">
                        <a href="<?php echo e(get_setting('instagram_link')); ?>" target="_blank" class="instagram"><i class="lab la-instagram"></i></a>
                    </li>
                    <?php endif; ?>
                    <?php if( get_setting('youtube_link') !=  null ): ?>
                    <li class="list-inline-item">
                        <a href="<?php echo e(get_setting('youtube_link')); ?>" target="_blank" class="youtube"><i class="lab la-youtube"></i></a>
                    </li>
                    <?php endif; ?>
                    <?php if( get_setting('linkedin_link') !=  null ): ?>
                    <li class="list-inline-item">
                        <a href="<?php echo e(get_setting('linkedin_link')); ?>" target="_blank" class="linkedin"><i class="lab la-linkedin-in"></i></a>
                    </li>
                    <?php endif; ?>
                </ul>
                <?php endif; ?>
            </div>
            <div class="col-lg-4">
                <div class="text-center text-md-right">
                    <ul class="list-inline mb-0">
                                <li class="list-inline-item">
<span style="color: white;">&nbsp;Website Designed By: <a href="https://www.elitedesign.com.bd" target="_blank"><span style="color: white;">Elite Design</span></a></span>
                                </li>
            
                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>


<div class="aiz-mobile-bottom-nav d-xl-none fixed-bottom bg-white shadow-lg border-top rounded-top" style="box-shadow: 0px -1px 10px rgb(0 0 0 / 15%)!important; ">
    <div class="row align-items-center gutters-5">
        <div class="col">
            <a href="<?php echo e(route('home')); ?>" class="text-reset d-block text-center pb-2 pt-3">
                <i class="las la-home fs-20 opacity-60 <?php echo e(areActiveRoutes(['home'],'opacity-100 text-primary')); ?>"></i>
                <span class="d-block fs-10 fw-600 opacity-60 <?php echo e(areActiveRoutes(['home'],'opacity-100 fw-600')); ?>"><?php echo e(translate('Home')); ?></span>
            </a>
        </div>
        <div class="col">
            <a href="<?php echo e(route('categories.all')); ?>" class="text-reset d-block text-center pb-2 pt-3">
                <i class="las la-list-ul fs-20 opacity-60 <?php echo e(areActiveRoutes(['categories.all'],'opacity-100 text-primary')); ?>"></i>
                <span class="d-block fs-10 fw-600 opacity-60 <?php echo e(areActiveRoutes(['categories.all'],'opacity-100 fw-600')); ?>"><?php echo e(translate('Categories')); ?></span>
            </a>
        </div>
        <?php
            if(auth()->user() != null) {
                $user_id = Auth::user()->id;
                $cart = \App\Models\Cart::where('user_id', $user_id)->get();
            } else {
                $temp_user_id = Session()->get('temp_user_id');
                if($temp_user_id) {
                    $cart = \App\Models\Cart::where('temp_user_id', $temp_user_id)->get();
                }
            }
        ?>
        <div class="col-auto">
            <a href="<?php echo e(route('cart')); ?>" class="text-reset d-block text-center pb-2 pt-3">
                <span class="align-items-center bg-primary border border-white border-width-4 d-flex justify-content-center position-relative rounded-circle size-50px" style="margin-top: -33px;box-shadow: 0px -5px 10px rgb(0 0 0 / 15%);border-color: #fff !important;">
                    <i class="las la-shopping-bag la-2x text-white"></i>
                </span>
                <span class="d-block mt-1 fs-10 fw-600 opacity-60 <?php echo e(areActiveRoutes(['cart'],'opacity-100 fw-600')); ?>">
                    <?php echo e(translate('Cart')); ?>

                    <?php
                        $count = (isset($cart) && count($cart)) ? count($cart) : 0;
                    ?>
                    (<span class="cart-count"><?php echo e($count); ?></span>)
                </span>
            </a>
        </div>
        <div class="col">
            <a href="<?php echo e(route('all-notifications')); ?>" class="text-reset d-block text-center pb-2 pt-3">
                <span class="d-inline-block position-relative px-2">
                    <i class="las la-bell fs-20 opacity-60 <?php echo e(areActiveRoutes(['all-notifications'],'opacity-100 text-primary')); ?>"></i>
                    <?php if(Auth::check() && count(Auth::user()->unreadNotifications) > 0): ?>
                        <span class="badge badge-sm badge-dot badge-circle badge-primary position-absolute absolute-top-right" style="right: 7px;top: -2px;"></span>
                    <?php endif; ?>
                </span>
                <span class="d-block fs-10 fw-600 opacity-60 <?php echo e(areActiveRoutes(['all-notifications'],'opacity-100 fw-600')); ?>"><?php echo e(translate('Notifications')); ?></span>
            </a>
        </div>
        <div class="col">
        <?php if(Auth::check()): ?>
            <?php if(isAdmin()): ?>
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-reset d-block text-center pb-2 pt-3">
                    <span class="d-block mx-auto">
                        <?php if(Auth::user()->photo != null): ?>
                            <img src="<?php echo e(custom_asset(Auth::user()->avatar_original)); ?>" class="rounded-circle size-20px">
                        <?php else: ?>
                            <img src="<?php echo e(static_asset('assets/img/avatar-place.png')); ?>" class="rounded-circle size-20px">
                        <?php endif; ?>
                    </span>
                    <span class="d-block fs-10 fw-600 opacity-60"><?php echo e(translate('Account')); ?></span>
                </a>
            <?php else: ?>
                <a href="javascript:void(0)" class="text-reset d-block text-center pb-2 pt-3 mobile-side-nav-thumb" data-toggle="class-toggle" data-backdrop="static" data-target=".aiz-mobile-side-nav">
                    <span class="d-block mx-auto">
                        <?php if(Auth::user()->photo != null): ?>
                            <img src="<?php echo e(custom_asset(Auth::user()->avatar_original)); ?>" class="rounded-circle size-20px">
                        <?php else: ?>
                            <img src="<?php echo e(static_asset('assets/img/avatar-place.png')); ?>" class="rounded-circle size-20px">
                        <?php endif; ?>
                    </span>
                    <span class="d-block fs-10 fw-600 opacity-60"><?php echo e(translate('Account')); ?></span>
                </a>
            <?php endif; ?>
        <?php else: ?>
            <a href="<?php echo e(route('user.login')); ?>" class="text-reset d-block text-center pb-2 pt-3">
                <span class="d-block mx-auto">
                    <img src="<?php echo e(static_asset('assets/img/avatar-place.png')); ?>" class="rounded-circle size-20px">
                </span>
                <span class="d-block fs-10 fw-600 opacity-60"><?php echo e(translate('Account')); ?></span>
            </a>
        <?php endif; ?>
        </div>
    </div>
</div>
<?php if(Auth::check() && !isAdmin()): ?>
    <div class="aiz-mobile-side-nav collapse-sidebar-wrap sidebar-xl d-xl-none z-1035">
        <div class="overlay dark c-pointer overlay-fixed" data-toggle="class-toggle" data-backdrop="static" data-target=".aiz-mobile-side-nav" data-same=".mobile-side-nav-thumb"></div>
        <div class="collapse-sidebar bg-white">
            <?php echo $__env->make('frontend.inc.user_side_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
<?php endif; ?>

    <div class="modal fade" id="guest-modal">
        <div class="modal-dialog modal-lg modal-dialog-zoom">
            <div class="modal-content">


                <div class="modal-header">
                    <h6 class="modal-title fw-600">Order confirmation</h6>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true"></span>
                    </button>
                </div>

        <form action="<?php echo e(route('order_store')); ?>" method="post">
            <?php echo csrf_field(); ?>
                <div class="modal-body">

    <div class="mb-4">
        <div class="row gutters-5 d-none d-lg-flex border-bottom mb-3 pb-3">
            <div class="col-md-5 fw-600">Product</div>
            <div class="col fw-600">Price</div>
            <!--<div class="col fw-600">Tax</div>-->
            <div class="col fw-600">Quantity</div>
            <div class="col fw-600">Total</div>
            <div class="col-auto fw-600">Remove</div>
        </div>
        <ul class="list-group list-group-flush" id="itemadd"></ul>
    </div>
    
        <div class="form-group">
            <label><strong>আপনার নাম*</strong></label>
            <input class="form-control" type="text" placeholder="আপনার নাম*" name="name" value="" required>
            
            <input class="form-control" type="hidden" name="email" value="<?php if(Auth()->check()): ?><?php echo e(Auth()->user()->email); ?> <?php else: ?> customer@gmail.com <?php endif; ?>">
        </div>
        
        <div class="form-group">
            <label><strong>আপনার সম্পূর্ণ ঠিকানা*</strong></label>
            <input class="form-control" type="text" placeholder="আপনার সম্পূর্ণ ঠিকানা*" name="address" value="" required>
        </div>
        
        <div class="form-group">
            <label><strong>আপনার মোবাইল নাম্বার * </strong></label>
            <input type="tel" id="phone" name="phone" class="form-control" placeholder="আপনার মোবাইল নাম্বার *" pattern="[0-9]{11}" required title="Example: 01xxxxxxxxxx">
            
        </div>
        
        <div class="form-group">
            <label><strong>এলাকা* </strong></label>
            <select name="city" class="form-control" required>
                <option value="">এলাকা* </option>
                <option value="In Dhaka City">ঢাকার ভিতরে(৬০) টাকা</option>
                <option value="sub city Of Dhaka">ঢাকা উপশহর(১০০) টাকা</option>
                <option value="Out Of Dhaka City">ঢাকা শহরের বাইরে(১২০) টাকা</option>
            </select>
        </div>
        
        </div>
        
        <div class="modal-footer">
            <input type="submit" class="btn btn-danger btn-block btn-sm" value="অর্ডার কনফার্ম করুন">
        </div>
        
    </form>
            </div>
        </div>
    </div>

    
    
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
<script type="text/javascript">

    function guest_cart_update(cardid, qty){

        event.preventDefault();

        if(qty > 0){
            $.ajax({
                url : "<?php echo e(Route('cartupdate.cart_update')); ?>",
                method : "get",
                data : {
                    cardid : cardid,
                    qty : qty
                },
                success : function(data){
                    if (data.status == 1) {
                        $("#guest_qty_"+cardid).val(data.stock);
                    }else{
                        $("#guest_price_"+cardid).text("৳"+data.price);
                        $("#guest_total_"+cardid).text("৳"+data.total);
                    }
                }
            });
        }
    }

    function removeguest(id){
        event.preventDefault();
        $.ajax({
                url : "<?php echo e(Route('cartdelete.cart_delete')); ?>",
                method : "get",
                data : {
                    id : id
                }
        });

        $("#guest_remove_"+id).remove();
        $(".cart-count").text($(".addItem").length);
        if($(".addItem").length == 0){
            window.location = "<?php echo e(url('/')); ?>";
        }
    }

    function guest_card(){
        event.preventDefault();
        $('#guest-modal').modal();

        $.ajax({
                url : "<?php echo e(Route('getguestcard.getguest_card')); ?>",
                method : "get",
                success : function(data){



                if(data.guest_data.length > 0){
                    $("#itemadd").html("");

                    $.each(data.guest_data, function(key, values){

                        $("#itemadd").append('<li class="list-group-item addItem px-0 px-lg-3" id="guest_remove_'+values.cart_id+'"><div class="row gutters-5"><div class="col-lg-5 d-flex"><span class="mr-2 ml-0"><img src="'+values.icon+'" class="img-fit size-60px rounded"></span><span class="fs-14 opacity-60">'+values.title+'</span></div><div class="col-lg col-4 order-1 order-lg-0 my-3 my-lg-0"><span class="fw-600 fs-16" id="guest_price_2">৳'+values.price+'</span></div><div class="col-lg col-6 order-4 order-lg-0"><div class="row no-gutters align-items-center aiz-plus-minus mr-2 ml-0"><input type="number" name="quantity['+values.cart_id+']" id="guest_qty_'+values.cart_id+'" class="form-control" placeholder="1" value="'+values.qty+'" min="1" max="50" onchange="guest_cart_update('+values.cart_id+', this.value)"></div></div><div class="col-lg col-4 order-3 order-lg-0 my-3 my-lg-0"><span class="fw-600 fs-16 text-primary" id="guest_total_'+values.cart_id+'">৳'+values.total+'</span></div><div class="col-lg-auto col-6 order-5 order-lg-0 text-right"><a href="" onclick="removeguest('+values.cart_id+')" class="btn btn-icon btn-sm btn-soft-primary btn-circle"><i class="las la-trash"></i></a></div></div></li>');

                        

                    });
                }

                }
        });





    }

</script>
<?php /**PATH /home/elitede1/ecom16.elitedesign.com.bd/resources/views/frontend/inc/footer.blade.php ENDPATH**/ ?>