<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" <?php echo $gtext['is_rtl'] == 1 ? 'dir="rtl"' : ''; ?>>
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php 
	$PageVariation = PageVariation();
	$gtext = gtext(); 
	?>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	
	<title><?php echo $__env->yieldContent('title'); ?></title>
	<?php echo $__env->yieldContent('meta-content'); ?>
	<?php if($gtext['fb_pixel_publish'] == 1): ?>
	<!-- Facebook Pixel Code -->
	<script>
	  !function(f,b,e,v,n,t,s)
	  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
	  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
	  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
	  n.queue=[];t=b.createElement(e);t.async=!0;
	  t.src=v;s=b.getElementsByTagName(e)[0];
	  s.parentNode.insertBefore(t,s)}(window, document,'script',
	  'https://connect.facebook.net/en_US/fbevents.js');
	  fbq('init', '<?php echo e($gtext["fb_pixel_id"]); ?>');
	  fbq('track', 'PageView');
	</script>
	<noscript>
	  <img height="1" width="1" style="display:none" 
		   src="https://www.facebook.com/tr?id=<?php echo e($gtext['fb_pixel_id']); ?>&ev=PageView&noscript=1"/>
	</noscript>
	<!-- End Facebook Pixel Code -->
	<?php endif; ?>
	
	<?php if($gtext['ga_publish'] == 1): ?>
	<!-- Global site tag (gtag.js) - Google Analytics -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($gtext['tracking_id']); ?>"></script>
	<script>
	  window.dataLayer = window.dataLayer || [];
	  function gtag(){dataLayer.push(arguments);}
	  gtag('js', new Date());

	  gtag('config', '<?php echo e($gtext["tracking_id"]); ?>');
	</script>
	<?php endif; ?>

	<?php if($gtext['gtm_publish'] == 1): ?>
	<!-- Google Tag Manager -->
	<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
	new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
	j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
	'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
	})(window,document,'script','dataLayer','<?php echo e($gtext["google_tag_manager_id"]); ?>');</script>
	<!-- End Google Tag Manager -->	
	<?php endif; ?>
	<!--favicon-->
	<link rel="shortcut icon" href="<?php echo e($gtext['favicon'] ? asset('public/media/'.$gtext['favicon']) : asset('public/backend/images/favicon.ico')); ?>" type="image/x-icon">
	<link rel="icon" href="<?php echo e($gtext['favicon'] ? asset('public/media/'.$gtext['favicon']) : asset('public/backend/images/favicon.ico')); ?>" type="image/x-icon">
	<!-- css -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700;900&family=Spartan:wght@400;500;700;800;900&display=swap" rel="stylesheet">

	<?php if($gtext['is_rtl'] == 1): ?>
	<link href="https://fonts.googleapis.com/css2?family=Noto+Kufi+Arabic:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<link href="<?php echo e(asset('public/frontend/css/bootstrap.rtl.min.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('public/frontend/css/rtl.css')); ?>" rel="stylesheet">
	<?php else: ?>
	<link href="<?php echo e(asset('public/frontend/css/bootstrap.min.css')); ?>" rel="stylesheet">
	<?php endif; ?>
	<link href="<?php echo e(asset('public/frontend/css/bootstrap-icons.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('public/frontend/css/owl.carousel.min.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('public/frontend/css/magnific-popup.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('public/frontend/css/jquery-ui.min.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('public/frontend/css/slick.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('public/frontend/css/jquery.gritter.min.css')); ?>" rel="stylesheet">

	<style type="text/css">
	:root {
	  --theme-color: <?php echo e($gtext['theme_color']); ?>;
	  --color-green: <?php echo e($gtext['green_color']); ?>;
	  --color-light-green: <?php echo e($gtext['light_green_color']); ?>;
	  --color-lightness-green: <?php echo e($gtext['lightness_green_color']); ?>;
	  --color-gray: <?php echo e($gtext['gray_color']); ?>;
	  --color-gray-dark: <?php echo e($gtext['dark_gray_color']); ?>;
	  --color-gray-400: <?php echo e($gtext['light_gray_color']); ?>;
	  --color-black: <?php echo e($gtext['black_color']); ?>;
	  --color-white: <?php echo e($gtext['white_color']); ?>;
	  
	  --primary-font-family: 'Roboto', sans-serif;
	  --secondary-font-family: 'Spartan', sans-serif;
	  --arabic-font-family: 'Noto Kufi Arabic', sans-serif;
	  --font-size-100: 14px;
	  --font-size-200: 16px;
	  --font-size-300: 18px;
	  --font-size-400: 20px;
	  --font-size-500: 25px;
	  --font-size-600: 30px;
	  --font-size-700: 35px;
	  --font-size-800: 40px;
	  --font-size-900: 65px;
	  --heading-1: 40px;
	  --heading-2: 35px;
	  --heading-3: 28px;
	  --heading-4: 22px;
	  --heading-5: 18px;
	  --heading-6: 16px;
	  --line-height-100: 1;
	  --line-height-200: 1.5;
	}
	</style>
	<link href="<?php echo e(asset('public/frontend/css/style.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('public/frontend/css/responsive.css')); ?>" rel="stylesheet">
	<?php echo $__env->yieldPushContent('style'); ?>
	<?php if($gtext['custom_css'] != ''): ?>
	<style type="text/css">
	<?php echo $gtext['custom_css']; ?>
	</style>
	<?php endif; ?>
</head>
<body <?php echo $gtext['is_rtl'] == 1 ? 'class="rtl"' : ''; ?>>
	<?php if($gtext['gtm_publish'] == 1): ?>
	<!-- Google Tag Manager (noscript) -->
	<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=<?php echo e($gtext['google_tag_manager_id']); ?>"
	height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
	<!-- End Google Tag Manager (noscript) -->
	<?php endif; ?>
	<!--loader-->
	<div class="tw-loader">
		<div class="tw-ellipsis">
			<div></div><div></div><div></div><div></div>
		</div>						
	</div>
	<!--/loader/--> 
	<!-- scrollToTop -->	
	<a href="#top" class="scroll-to-top">
		<i class="bi bi-arrow-up"></i>
	</a>
	<!-- /scrollToTop -->
	
	<?php if($PageVariation['home_variation'] == 'home_3'): ?>
	<div class="container <?php echo e($PageVariation['home_variation']); ?>">
	<?php echo $__env->yieldContent('header'); ?>
	<?php echo $__env->yieldContent('content'); ?>
	<?php echo $__env->make('frontend.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	</div>
	<?php else: ?>
	<?php echo $__env->yieldContent('header'); ?>
	<?php echo $__env->yieldContent('content'); ?>
	<?php echo $__env->make('frontend.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php endif; ?>
	
	<?php if($gtext['is_publish_cookie_consent'] == 1): ?>
	<div class="cookie_consent_card <?php echo e($gtext['cookie_style']); ?> <?php echo e($gtext['cookie_position']); ?>">
		<?php if($gtext['cookie_title'] != ''): ?>
		<h4 class="cookie_consent_head"><?php echo e($gtext['cookie_title']); ?> </h4>
		<?php endif; ?>
		<?php if($gtext['cookie_message'] != ''): ?>
		<div class="cookie_consent_text"><?php echo e($gtext['cookie_message']); ?> 
			<?php if($gtext['learn_more_text'] != ''): ?>
			<a href="<?php echo e($gtext['learn_more_url']); ?>"><?php echo e($gtext['learn_more_text']); ?></a>
			<?php endif; ?>
		</div>
		<?php endif; ?>
		<?php if($gtext['button_text'] != ''): ?>
		<button class="btn accept_btn"><?php echo e($gtext['button_text']); ?></button>
		<?php endif; ?>
	</div>
	<?php endif; ?>
	
	<!-- js -->
	<script src="<?php echo e(asset('public/frontend/js/jquery-3.6.0.min.js')); ?>"></script>
	<script src="<?php echo e(asset('public/frontend/js/popper.min.js')); ?>"></script>
	<script src="<?php echo e(asset('public/frontend/js/bootstrap.min.js')); ?>"></script>
	<script src="<?php echo e(asset('public/frontend/js/owl.carousel.min.js')); ?>"></script>
	<script src="<?php echo e(asset('public/frontend/js/jquery.countdown.min.js')); ?>"></script>
	<script src="<?php echo e(asset('public/frontend/js/scrolltop.js')); ?>"></script>
	<script src="<?php echo e(asset('public/frontend/js/jquery-ui.min.js')); ?>"></script>
	<script src="<?php echo e(asset('public/frontend/js/jquery.magnific-popup.min.js')); ?>"></script>
	<script src="<?php echo e(asset('public/frontend/js/slick.min.js')); ?>"></script>
	<script src="<?php echo e(asset('public/frontend/js/jquery.popupoverlay.min.js')); ?>"></script>
	<script src="<?php echo e(asset('public/frontend/js/jquery.gritter.min.js')); ?>"></script>
	<script>
		var is_rtl = "<?php echo e($gtext['is_rtl']); ?>";
		if(is_rtl == 1){
			var isRTL = true;
		}else{
			var isRTL = false;
		}

		var theme_color = "<?php echo e($gtext['theme_color']); ?>";
		var base_url = "<?php echo e(url('/')); ?>";
		var public_path = "<?php echo e(asset('public')); ?>";
		
		//Cookie Consent
		var is_publish_cookie_consent = "<?php echo e($gtext['is_publish_cookie_consent']); ?>";
		if(is_publish_cookie_consent == 1){
			let cookieModal = document.querySelector(".cookie_consent_card");
			let acceptCookieBtn = document.querySelector(".accept_btn");

			acceptCookieBtn.addEventListener("click", function (){
				cookieModal.classList.remove("active");
				localStorage.setItem("cookie_consent", 1);
			});

			let cookieAccepted = localStorage.getItem("cookie_consent");
			if (cookieAccepted == 1){
				cookieModal.classList.remove("active");
			}else{
				cookieModal.classList.add("active");
			}
		}
	</script>
	<script src="<?php echo e(asset('public/frontend/js/scripts.js')); ?>"></script>
	<script src="<?php echo e(asset('public/frontend/pages/cart.js')); ?>"></script>
	<div class="custom-popup light width-100 dnone" id="lightCustomModal">
		<div class="padding-md">
			<h4 class="m-top-none"></h4>
		</div>
		<div class="text-center">
			<a href="javascript:void(0);" class="btn blue-btn lightCustomModal_close mr-10" onClick="onConfirm()"><?php echo e(__('Confirm')); ?></a>
			<a href="javascript:void(0);" class="btn danger-btn lightCustomModal_close"><?php echo e(__('Cancel')); ?></a>
		</div>
	</div>
	<a href="#lightCustomModal" class="btn btn-warning btn-small lightCustomModal_open dnone"><?php echo e(__('Edit')); ?></a>
	<?php echo $__env->yieldPushContent('scripts'); ?>
	<?php if($gtext['custom_js'] != ''): ?>
	<script>
	<?php echo $gtext['custom_js']; ?>
	</script>
	<?php endif; ?>
</body>
</html>
	<?php /**PATH /home/elitede1/ecom15.elitedesign.com.bd/resources/views/layouts/frontend.blade.php ENDPATH**/ ?>