

<?php $__env->startSection('title', __('Checkout')); ?>
<?php 
$gtext = gtext(); 
$gtax = getTax();
$tax_rate = $gtax['percentage'];
?>

<?php $__env->startSection('meta-content'); ?>
	<meta name="keywords" content="<?php echo e($gtext['og_keywords']); ?>" />
	<meta name="description" content="<?php echo e($gtext['og_description']); ?>" />
	<meta property="og:title" content="<?php echo e($gtext['og_title']); ?>" />
	<meta property="og:site_name" content="<?php echo e($gtext['site_name']); ?>" />
	<meta property="og:description" content="<?php echo e($gtext['og_description']); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(url()->current()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('public/media/'.$gtext['og_image'])); ?>" />
	<meta property="og:image:width" content="600" />
	<meta property="og:image:height" content="315" />
	<?php if($gtext['fb_publish'] == 1): ?>
	<meta name="fb:app_id" property="fb:app_id" content="<?php echo e($gtext['fb_app_id']); ?>" />
	<?php endif; ?>
	<meta name="twitter:card" content="summary_large_image">
	<?php if($gtext['twitter_publish'] == 1): ?>
	<meta name="twitter:site" content="<?php echo e($gtext['twitter_id']); ?>">
	<meta name="twitter:creator" content="<?php echo e($gtext['twitter_id']); ?>">
	<?php endif; ?>
	<meta name="twitter:url" content="<?php echo e(url()->current()); ?>">
	<meta name="twitter:title" content="<?php echo e($gtext['og_title']); ?>">
	<meta name="twitter:description" content="<?php echo e($gtext['og_description']); ?>">
	<meta name="twitter:image" content="<?php echo e(asset('public/media/'.$gtext['og_image'])); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('frontend.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<main class="main">
	<!-- Page Breadcrumb -->
	<div class="breadcrumb-section">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a></li>
							<li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Checkout')); ?></li>
						</ol>
					</nav>
				</div>
				<div class="col-lg-6">
					<div class="page-title">
						<h1><?php echo e(__('Checkout')); ?></h1>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Page Breadcrumb/ -->
	
	<!-- Inner Section -->
	<section class="inner-section inner-section-bg my_card">
		<div class="container">
			<form novalidate="" data-validate="parsley" id="checkout_formid">
				<?php echo csrf_field(); ?>
				<div class="row">
					<div class="col-lg-7">
						<h5><?php echo e(__('Shipping Information')); ?></h5>
						<?php if(auth()->guard()->check()): ?>
						<?php else: ?>
						<p><?php echo e(__('Already have an account?')); ?> <strong><a href="<?php echo e(route('frontend.login')); ?>"><?php echo e(__('login')); ?></a></strong></p>
						<?php endif; ?>
						<div class="row">
							<div class="col-md-12">
								<div class="mb-3">
									<input id="name" name="name" type="text" placeholder="<?php echo e(__('Name')); ?>" value="<?php if(isset(Auth::user()->name)): ?> <?php echo e(Auth::user()->name); ?> <?php endif; ?>" class="form-control parsley-validated" data-required="true">
									<span class="text-danger error-text name_error"></span>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-6">
								<div class="mb-3">
									<input id="email" name="email" type="email" placeholder="<?php echo e(__('Email Address')); ?>" value="<?php if(isset(Auth::user()->email)): ?> <?php echo e(Auth::user()->email); ?> <?php endif; ?>" class="form-control parsley-validated" data-required="true">
									<span class="text-danger error-text email_error"></span>
								</div>
							</div>
							<div class="col-md-6">
								<div class="mb-3">
									<input id="phone" name="phone" type="text" placeholder="<?php echo e(__('Phone')); ?>" value="<?php if(isset(Auth::user()->phone)): ?> <?php echo e(Auth::user()->phone); ?> <?php endif; ?>" class="form-control parsley-validated" data-required="true">
									<span class="text-danger error-text phone_error"></span>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-6">
								<div class="mb-3">
									<select id="country" name="country" class="form-control parsley-validated" data-required="true">
									<option value=""><?php echo e(__('Country')); ?></option>
									<?php $__currentLoopData = $country_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($row->country_name); ?>">
										<?php echo e($row->country_name); ?>

									</option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
									<span class="text-danger error-text country_error"></span>
								</div>
							</div>
							<div class="col-md-6">
								<div class="mb-3">
									<input id="state" name="state" type="text" placeholder="<?php echo e(__('State')); ?>" class="form-control parsley-validated" data-required="true">
									<span class="text-danger error-text state_error"></span>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-6">
								<div class="mb-3">
									<input id="zip_code" name="zip_code" type="text" placeholder="<?php echo e(__('Zip Code')); ?>" class="form-control parsley-validated" data-required="true">
									<span class="text-danger error-text zip_code_error"></span>
								</div>
							</div>
							<div class="col-md-6">
								<div class="mb-3">
									<input id="city" name="city" type="text" placeholder="<?php echo e(__('City')); ?>" class="form-control parsley-validated" data-required="true">
									<span class="text-danger error-text city_error"></span>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-12">
								<div class="mb-3">
									<textarea id="address" name="address" placeholder="<?php echo e(__('Address')); ?>" rows="2" class="form-control parsley-validated" data-required="true"><?php if(isset(Auth::user()->address)): ?> <?php echo e(Auth::user()->address); ?> <?php endif; ?></textarea>
									<span class="text-danger error-text address_error"></span>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-12">
								<div class="checkboxlist">
									<label class="checkbox-title">
										<input id="new_account" name="new_account" type="checkbox"><?php echo e(__('Register an account with above information?')); ?> 
									</label>
								</div>
								<?php if($errors->has('password')): ?>
								<span class="text-danger"><?php echo e($errors->first('password')); ?></span>
								<?php endif; ?>
							</div>
						</div>
						
						<div class="row hideclass" id="new_account_pass">
							<div class="col-md-6">
								<div class="mb-3">
									<input type="password" name="password" id="password" class="form-control" placeholder="<?php echo e(__('Password')); ?>">
									<span class="text-danger error-text password_error"></span>
								</div>
							</div>
							<div class="col-md-6">
								<div class="mb-3">
									<input type="password" name="password_confirmation" id="password_confirmation" class="form-control" placeholder="<?php echo e(__('Confirm password')); ?>">
								</div>
							</div>
						</div>
						
						<h5 class="mt10"><?php echo e(__('Payment Method')); ?></h5>
						<div class="row">
							<div class="col-md-12">
								<span class="text-danger error-text payment_method_error"></span>
								<?php if($gtext['stripe_isenable'] == 1): ?>
								<div class="payment_card">
									<div class="checkboxlist">
										<label class="checkbox-title">
											<input id="payment_method_stripe" name="payment_method" type="radio" value="3"><img src="<?php echo e(asset('public/frontend/images/stripe.png')); ?>" alt="Stripe" />
										</label>
									</div>
									<div id="pay_stripe" class="row hideclass">
										<div class="col-md-12">
											<div class="row">
												<div class="col-md-12">
													<div class="mb-3">
														<div class="form-control" id="card-element"></div>
														<span class="card-errors" id="card-errors"></span>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<?php endif; ?>
								
								<?php if($gtext['isenable_paypal'] == 1): ?>
								<div class="payment_card">
									<div class="checkboxlist">
										<label class="checkbox-title">
											<input id="payment_method_paypal" name="payment_method" type="radio" value="4"><img src="<?php echo e(asset('public/frontend/images/paypal.png')); ?>" alt="Paypal" />
										</label>
									</div>
									<p id="pay_paypal" class="hideclass"><?php echo e(__('Pay online via Paypal')); ?></p>
								</div>
								<?php endif; ?>
								
								<?php if($gtext['isenable_razorpay'] == 1): ?>
								<div class="payment_card">
									<div class="checkboxlist">
										<label class="checkbox-title">
											<input id="payment_method_razorpay" name="payment_method" type="radio" value="5"><img src="<?php echo e(asset('public/frontend/images/razorpay.png')); ?>" alt="Razorpay" />
										</label>
									</div>
									<p id="pay_razorpay" class="hideclass"><?php echo e(__('Pay online via Razorpay')); ?></p>
								</div>
								<?php endif; ?>
								
								<?php if($gtext['isenable_mollie'] == 1): ?>
								<div class="payment_card">
									<div class="checkboxlist">
										<label class="checkbox-title">
											<input id="payment_method_mollie" name="payment_method" type="radio" value="6"><img src="<?php echo e(asset('public/frontend/images/mollie.png')); ?>" alt="Mollie" />
										</label>
									</div>
									<p id="pay_mollie" class="hideclass"><?php echo e(__('Pay online via Mollie')); ?></p>
								</div>
								<?php endif; ?>
								
								<?php if($gtext['cod_isenable'] == 1): ?>
								<div class="payment_card">
									<div class="checkboxlist">
										<label class="checkbox-title">
											<input id="payment_method_cod" name="payment_method" type="radio" value="1"><img src="<?php echo e(asset('public/frontend/images/cash_on_delivery.png')); ?>" alt="Cash on Delivery" />
										</label>
									</div>
									<p id="pay_cod" class="hideclass"><?php echo e($gtext['cod_description']); ?></p>
								</div>
								<?php endif; ?>
								
								<?php if($gtext['bank_isenable'] == 1): ?>
								<div class="payment_card">
									<div class="checkboxlist">
										<label class="checkbox-title">
											<input id="payment_method_bank" name="payment_method" type="radio" value="2"><img src="<?php echo e(asset('public/frontend/images/bank_transfer.png')); ?>" alt="Bank Transfer" />
										</label>
									</div>
									<p id="pay_bank" class="hideclass"><?php echo e($gtext['bank_description']); ?></p>
								</div>
								<?php endif; ?>
							</div>
						</div>
						<div class="row">
							<div class="col-md-12">
								<div class="mb-3 mt10">
									<textarea name="comments" class="form-control" placeholder="<?php echo e(__('Write comment')); ?>" rows="2"></textarea>
								</div>
							</div>
						</div>
					</div>
					
					<div class="col-lg-5">
						<div class="carttotals-card">
							<div class="carttotals-head"><?php echo e(__('Order Summary')); ?></div>
							<div class="carttotals-body">
							<?php if(session('shopping_cart')): ?>
								<table class="table">
									<tbody>
										<?php 
										$CartDataArr = array();
										$Total_Price = 0;
										?>
										<?php $__currentLoopData = session('shopping_cart'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php
											
											$Total_Price += $row['price']*$row['qty'];
											
											$data = array(
												'rowId' => $row['id'], 
												'id' => $row['id'], 
												'qty' => $row['qty'], 
												'name' => $row['name'], 
												'price' => $row['price'], 
												'weight' => $row['weight'], 
												'thumbnail' => $row['thumbnail'], 
												'unit' => $row['unit'],
												'seller_id' => $row['seller_id'],
												'seller_name' => $row['seller_name'],
												'store_name' => $row['store_name'],
												'store_logo' => $row['store_logo'],
												'store_url' => $row['store_url'],
												'seller_email' => $row['seller_email'],
												'seller_phone' => $row['seller_phone'],
												'seller_address' => $row['seller_address']
											);
											
											$CartDataArr[$row['seller_id']][] = $data;
											?>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										
										<?php $CartData_Arr = array(); ?>
										<?php $__currentLoopData = $CartDataArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aRows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php $__currentLoopData = $aRows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<?php $CartData_Arr[] = $row; ?>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										
										<?php 
										$tempSellerId = ''; 
										$SellerCount = 0; 
										?>
		
										<?php $__currentLoopData = $CartData_Arr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php
											if($row['unit'] == '0'){
												$unit = '';
											}else{
												$unit = '<strong>'.$row['qty'].' '.$row['unit'].'</strong>';
											}
											?>
											
											<?php if($tempSellerId != $row['seller_id']): ?>
											<tr>
												<td colspan="2" class="tp_group">
													<div class="store_logo">
														<a href="<?php echo e(route('frontend.stores', [$row['seller_id'], str_slug($row['store_name'])])); ?>">
															<img src="<?php echo e(asset('public/media/'.$row['store_logo'])); ?>" alt="<?php echo e($row['store_name']); ?>" />
														</a>
													</div>
													<div class="store_name">
														<p><strong><?php echo e(__('Sold By')); ?></strong></p>
														<p><a href="<?php echo e(route('frontend.stores', [$row['seller_id'], str_slug($row['store_url'])])); ?>"><?php echo e($row['store_name']); ?></a></p>
													</div>
												</td>
											</tr>
											
											<?php 
											$tempSellerId=$row['seller_id']; 
											$SellerCount++;
											?>
											
											<?php endif; ?>
											
											<?php if($gtext['currency_position'] == 'left'): ?>
											<tr>
												<td>
													<p class="title"><a href="<?php echo e(route('frontend.product', [$row['id'], str_slug($row['name'])])); ?>"><?php echo e($row['name']); ?></a></p>
													<p class="sub-title"><?php echo $unit; ?></p>
												</td>
												<td>
													<p class="price"><?php echo e($gtext['currency_icon']); ?><?php echo e(NumberFormat($row['price']*$row['qty'])); ?></p>
													<p class="sub-price"><?php echo e($gtext['currency_icon']); ?><?php echo e($row['price']); ?> x <?php echo e($row['qty']); ?></p>
												</td>
											</tr>
											<?php else: ?>
											<tr>
												<td>
													<p class="title"><?php echo e($row['name']); ?></p>
													<p class="sub-title"><?php echo $unit; ?></p>
												</td>
												<td>
													<p class="price"><?php echo e(NumberFormat($row['price']*$row['qty'])); ?><?php echo e($gtext['currency_icon']); ?></p>
													<p class="sub-price"><?php echo e($row['price']); ?><?php echo e($gtext['currency_icon']); ?> x <?php echo e($row['qty']); ?></p>
												</td>
											</tr>
											<?php endif; ?>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										
										<?php
										
											$TaxCal = ($Total_Price*$tax_rate)/100;
											$TotalPrice = $Total_Price+$TaxCal;
											
											if($gtext['currency_position'] == 'left'){
												$ShippingFee = $gtext['currency_icon'].'<span class="shipping_fee">0</span>'; 
												$tax = $gtext['currency_icon'].NumberFormat($TaxCal);
												$total = $gtext['currency_icon'].'<span class="total_amount">'.NumberFormat($TotalPrice).'</span>';
											}else{
												$ShippingFee = '<span class="shipping_fee">0</span>'.$gtext['currency_icon'];
												$tax = NumberFormat($TaxCal).$gtext['currency_icon'];
												$total = '<span class="total_amount">'.NumberFormat($TotalPrice).'</span>'.$gtext['currency_icon'];
											}
										?>
										
										<tr><td colspan="2"><span class="title"><?php echo e(__('Shipping Fee')); ?> </span><span class="price"><?php echo $ShippingFee; ?></span></td></tr>
										<tr><td colspan="2"><span class="title"><?php echo e(__('Tax')); ?></span><span class="price"><?php echo e($tax); ?></span></td></tr>
										<tr><td colspan="2"><span class="total"><?php echo e(__('Total')); ?></span><span class="total-price"><?php echo $total; ?></span></td></tr>
									</tbody>
								</table>
								
								<?php if(count($shipping_list)>0): ?>
								<h5><?php echo e(__('Shipping Method')); ?></h5>
								<div class="row">
									<div class="col-md-12">
										<span class="text-danger error-text shipping_method_error"></span>
										<?php $__currentLoopData = $shipping_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php
												if($gtext['currency_position'] == 'left'){
													$shipping_fee = $gtext['currency_icon'].$row->shipping_fee;
												}else{
													$shipping_fee = $row->shipping_fee.$gtext['currency_icon'];
												}
											?>
											<div class="checkboxlist">
												<label class="checkbox-title">
													<input data-seller_count="<?php echo e($SellerCount); ?>" data-shippingfee="<?php echo e($row->shipping_fee); ?>" data-total="<?php echo e(NumberFormat($TotalPrice)); ?>" class="shipping_method" name="shipping_method" type="radio" value="<?php echo e($row->id); ?>"><?php echo e($row->title); ?> : <?php echo e($shipping_fee); ?>

												</label>
											</div>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</div>
								</div>
								<?php endif; ?>
								<input name="customer_id" type="hidden" value="<?php if(isset(Auth::user()->id)): ?> <?php echo e(Auth::user()->id); ?> <?php endif; ?>" />
								<input name="razorpay_payment_id" id="razorpay_payment_id" type="hidden" />
								<a id="checkout_submit_form" href="javascript:void(0);" class="btn theme-btn mt10 checkout_btn"><?php echo e(__('Checkout')); ?></a>

								<?php if(Session::has('pt_payment_error')): ?>
								<div class="alert alert-danger">
									<?php echo e(Session::get('pt_payment_error')); ?>

								</div>
								<?php endif; ?>
							<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</form>
		</div>
	</section>
	<!-- /Inner Section/ -->
</main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="<?php echo e(asset('public/frontend/js/parsley.min.js')); ?>"></script>
<script type="text/javascript">
var theme_color = "<?php echo e($gtext['theme_color']); ?>";
var site_name = "<?php echo e($gtext['site_name']); ?>";
var validCardNumer = 0;
var TEXT = [];
	TEXT['Please type valid card number'] = "<?php echo e(__('Please type valid card number')); ?>";
</script>
<?php if($gtext['stripe_isenable'] == 1): ?>
<script src="https://js.stripe.com/v3/"></script>
<script type="text/javascript">
	var isenable_stripe = "<?php echo e($gtext['stripe_isenable']); ?>";
	var stripe_key = "<?php echo e($gtext['stripe_key']); ?>";
</script>
<script src="<?php echo e(asset('public/frontend/pages/payment_method.js')); ?>"></script>
<?php endif; ?>

<?php if($gtext['isenable_razorpay'] == 1): ?>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script type="text/javascript">
	var isenable_razorpay = "<?php echo e($gtext['isenable_razorpay']); ?>";
	var razorpay_key_id = "<?php echo e($gtext['razorpay_key_id']); ?>";
	var razorpay_currency = "<?php echo e($gtext['razorpay_currency']); ?>";
</script>
<?php endif; ?>
<script src="<?php echo e(asset('public/frontend/pages/checkout.js')); ?>"></script>
<?php $__env->stopPush(); ?>	
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\resources\views/frontend/checkout.blade.php ENDPATH**/ ?>