<?php $__env->startSection('content'); ?>
    <div class="section-header">
        <h3><?php echo e(SeoHelper::getTitle()); ?></h3>
    </div>
    <div class="section-content">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th><?php echo e(__('ID number')); ?></th>
                        <th><?php echo e(__('Date')); ?></th>
                        <th><?php echo e(__('Total')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                <?php if(count($orders) > 0): ?>
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th scope="row"><?php echo e(get_order_code($order->id)); ?></th>
                            <td><?php echo e($order->created_at->translatedFormat('M d, Y h:m')); ?></td>
                            <td><?php echo e(format_price($order->amount)); ?></td>
                            <td><?php echo BaseHelper::clean($order->status->toHtml()); ?></td>
                            <td>
                                <a class="btn btn-primary btn-sm" href="<?php echo e(route('customer.orders.view', $order->id)); ?>"><?php echo e(__('View')); ?></a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center"><?php echo e(__('No orders!')); ?></td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="pagination">
            <?php echo $orders->links(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(Theme::getThemeNamespace() . '::views.ecommerce.customers.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitede1/ecommerce13.elitedesign.com.bd/platform/themes/farmart/views/ecommerce/customers/orders/list.blade.php ENDPATH**/ ?>