<?php Theme::layout('full-width'); ?>

<?php echo Theme::partial('page-header', ['size' => 'xl', 'withTitle' => true]); ?>


<div class="container">
    <div class="row forgot-password-page py-5 mt-3 justify-content-center">
        <div class="col-sm-6">
            <div class="forgot-password-form bg-light p-4">
                <p><?php echo e(__('Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.')); ?></p>
                <form class="mt-3"  method="POST" action="<?php echo e(route('customer.password.request')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <input class="form-control <?php if($errors->has('email')): ?> is-invalid <?php endif; ?>" type="text" required="" placeholder="<?php echo e(__('Email address')); ?>"
                            name="email" autocomplete="email" value="<?php echo e(old('email')); ?>">
                        <?php if($errors->has('email')): ?>
                            <span class="invalid-feedback"><?php echo e($errors->first('email')); ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="d-grid">
                        <button class="btn btn-primary" type="submit"><?php echo e(__('Send Password Reset Link')); ?></button>
                    </div>
                </form>

                <?php if(session('status')): ?>
                    <div class="text-success">
                        <?php echo e(session('status')); ?>

                    </div>
                <?php endif; ?>

                <?php if(session('success_msg')): ?>
                    <div class="text-success">
                        <?php echo e(session('success_msg')); ?>

                    </div>
                <?php endif; ?>

                <?php if(session('error_msg')): ?>
                    <div class="text-danger">
                        <?php echo e(session('error_msg')); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/elitedesigncom/ecommerce3.elitedesign.com.bd/platform/themes/farmart/views/ecommerce/customers/passwords/email.blade.php ENDPATH**/ ?>