<?php Theme::layout('full-width'); ?>

<?php echo Theme::partial('page-header', ['withTitle' => false, 'size' => 'xl']); ?>

<div class="container">
    <div class="row customer-auth-page py-5 mt-5 justify-content-center">
        <div class="col-sm-9 col-md-6 col-lg-5 col-xl-4">
            <div class="customer-auth-form bg-light pt-1 py-3 px-4">
                <nav>
                    <div class="nav nav-tabs">
                        <h1 class="nav-link fs-5 fw-bold"><?php echo e(__('Register An Account')); ?></h1>
                    </div>
                </nav>
                <div class="tab-content my-3">
                    <div class="tab-pane fade pt-4 show active" id="nav-register-content" role="tabpanel"
                         aria-labelledby="nav-profile-tab">
                        <form method="POST" action="<?php echo e(route('customer.register.post')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="form-group mb-3">
                                <label class="form-label required" for="name-register"><?php echo e(__('Name')); ?></label>
                                <input class="form-control <?php if($errors->has('name')): ?> is-invalid <?php endif; ?>"
                                       name="name" id="name-register" type="text" value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(__('Your Name')); ?>">
                                <?php if($errors->has('name')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('name')); ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label required" for="email-register"><?php echo e(__('Email Address')); ?></label>
                                <input class="form-control <?php if($errors->has('email')): ?> is-invalid <?php endif; ?>"
                                       type="email" required="required" placeholder="<?php echo e(__('Email Address')); ?>"
                                       name="email" autocomplete="email" id="email-register" value="<?php echo e(old('email')); ?>">
                                <?php if($errors->has('email')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('email')); ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label required" for="password-register"><?php echo e(__('Password')); ?></label>
                                <input class="form-control <?php if($errors->has('password')): ?> is-invalid <?php endif; ?>"
                                       type="password" placeholder="<?php echo e(__('Password')); ?>" aria-label="<?php echo e(__('Password')); ?>"
                                       autocomplete="new-password" id="password-register" name="password">
                                <?php if($errors->has('password')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('password')); ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label required" for="password-confirmation-register"><?php echo e(__('Password confirmation')); ?></label>
                                <input class="form-control <?php if($errors->has('password_confirmation')): ?> is-invalid <?php endif; ?>"
                                       type="password" placeholder="<?php echo e(__('Password confirmation')); ?>" id="password-confirmation-register" aria-label="<?php echo e(__('Password confirmation')); ?>" name="password_confirmation">
                                <?php if($errors->has('password_confirmation')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('password_confirmation')); ?></div>
                                <?php endif; ?>
                            </div>
                            <?php if(is_plugin_active('marketplace')): ?>
                                <div class="show-if-vendor" <?php if(old('is_vendor') != 1): ?> style="display: none" <?php endif; ?>>
                                    <?php echo $__env->make(Theme::getThemeNamespace() . '::views.marketplace.includes.become-vendor-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="vendor-customer-registration">
                                    <div class="form-check my-1">
                                        <input class="form-check-input" name="is_vendor" value="0" id="customer-role-register"
                                               type="radio" <?php if(old('is_vendor') != 1): ?> checked="checked" <?php endif; ?>>
                                        <label class="form-check-label" for="customer-role-register"><?php echo e(__('I am a customer')); ?></label>
                                    </div>
                                    <div class="form-check my-1 mb-3">
                                        <input class="form-check-input" id="vendor-role-register" value="1"
                                               type="radio" name="is_vendor" <?php if(old('is_vendor') == 1): ?> checked="checked" <?php endif; ?>>
                                        <label class="form-check-label" for="vendor-role-register"><?php echo e(__('I am a vendor')); ?></label>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="form-group">
                                <p><?php echo e(__('Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our privacy policy.')); ?></p>
                            </div>

                            <?php if(is_plugin_active('captcha')): ?>
                                <?php if(Captcha::isEnabled() && get_ecommerce_setting('enable_recaptcha_in_register_page', 0)): ?>
                                    <div class="form-group mb-3">
                                        <?php echo Captcha::display(); ?>

                                    </div>
                                <?php endif; ?>

                                <?php if(get_ecommerce_setting('enable_math_captcha_in_register_page', 0)): ?>
                                        <div class="form-group mb-3">
                                            <label class="form-label required" for="math-group"><?php echo e(app('math-captcha')->label()); ?></label>
                                        <?php echo app('math-captcha')->input(['class' => 'form-control', 'id' => 'math-group', 'placeholder' => app('math-captcha')->getMathLabelOnly()]); ?>

                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <div class="form-check mb-3">
                                <input type="hidden" name="agree_terms_and_policy" value="0">
                                <input class="form-check-input" type="checkbox" name="agree_terms_and_policy" id="agree-terms-and-policy" value="1" <?php if(old('agree_terms_and_policy') == 1): ?> checked <?php endif; ?>>
                                <label for="agree-terms-and-policy"><?php echo e(__('I agree to terms & Policy.')); ?></label>
                                <?php if($errors->has('agree_terms_and_policy')): ?>
                                    <div class="mt-1">
                                        <span class="text-danger small"><?php echo e($errors->first('agree_terms_and_policy')); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="d-grid">
                                <button class="btn btn-primary" type="submit"><?php echo e(__('Register')); ?></button>
                            </div>

                            <div class="mt-3">
                                <p class="text-center"><?php echo e(__('Already have an account?')); ?> <a href="<?php echo e(route('customer.login')); ?>" class="d-inline-block text-primary"><?php echo e(__('Log in')); ?></a></p>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="bg-light pt-1 px-4 pb-3">
                <?php echo apply_filters(BASE_FILTER_AFTER_LOGIN_OR_REGISTER_FORM, null, \Botble\Ecommerce\Models\Customer::class); ?>

            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/elitede1/ecommerce13.elitedesign.com.bd/platform/themes/farmart/views/ecommerce/customers/register.blade.php ENDPATH**/ ?>