<?php Theme::set('withTitle', false); ?>

<div class="row mt-5">
    <div class="col-md-9">
        <h1 class="h2"><?php echo BaseHelper::clean($post->name); ?></h1>
        <div class="post-item__inner pb-4 my-3 border-bottom">
            <div class="entry-meta">
                <?php if($post->author): ?>
                    <div class="entry-meta-author">
                        <span><?php echo e(__('By :name', ['name' => $post->author->name])); ?></span>
                    </div>
                <?php endif; ?>
                <?php if($post->categories->count()): ?>
                    <div class="entry-meta-categories">
                        <span><?php echo e(__('in')); ?></span>
                        <?php $__currentLoopData = $post->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e($category->url); ?>"><?php echo BaseHelper::clean($category->name); ?></a> <?php if(!$loop->last): ?> , <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
                <div class="entry-meta-date">
                    <span><?php echo e(__('on')); ?></span>
                    <time><?php echo e($post->created_at->translatedFormat('M d, Y')); ?></time>
                </div>
            </div>
        </div>
        <div class="mt-5 pt-3 post-detail__content">
            <div class="ck-content"><?php echo BaseHelper::clean($post->content); ?></div>

            <?php if($post->tags->count()): ?>
                <div class="entry-meta-tags">
                    <strong><?php echo e(__('Tags')); ?>:</strong>
                    <?php $__currentLoopData = $post->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e($tag->url); ?>" class="text-link"><?php echo e($tag->name); ?></a><?php if(!$loop->last): ?>, <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>

            <?php if(theme_option('facebook_comment_enabled_in_post', 'yes') == 'yes'): ?>
                <br />
                <?php echo apply_filters(BASE_FILTER_PUBLIC_COMMENT_AREA, Theme::partial('comments')); ?>

            <?php endif; ?>
        </div>
        <?php $relatedPosts = get_related_posts($post->id, 4); ?>

        <?php if($relatedPosts->count()): ?>
            <div class="related-posts mt-5 pt-3">
                <div class="heading">
                    <h3><?php echo e(__('Related Posts')); ?></h3>
                </div>
                <div class="list-post--wrapper">
                    <div class="slick-slides-carousel" data-slick="<?php echo e(json_encode([
                        'slidesToShow'   => 3,
                        'slidesToScroll' => 1,
                        'arrows'         => true,
                        'dots'           => true,
                        'infinite'        => false,
                        'responsive'     => [
                            [
                                'breakpoint' => 1200,
                                'settings'   => [
                                    'slidesToShow'   => 2,
                                    'slidesToScroll' => 1
                                ],
                            ],
                            [
                                'breakpoint' => 480,
                                'settings'   => [
                                    'slidesToShow'   => 1,
                                    'slidesToScroll' => 1
                                ],
                            ],
                        ],
                    ])); ?>">
                        <?php $__currentLoopData = $relatedPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo Theme::partial('post-item', ['post' => $item]); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <div class="col-md-3">
        <div class="primary-sidebar">
            <aside class="widget-area" id="primary-sidebar">
                <?php echo dynamic_sidebar('primary_sidebar'); ?>

            </aside>
        </div>
    </div>
</div>
<?php /**PATH /home/elitede1/ecommerce13.elitedesign.com.bd/platform/themes/farmart/views/post.blade.php ENDPATH**/ ?>