<?php $__env->startSection('content'); ?>
    <?php Theme::set('pageName', __('Order information')) ?>
    <div class="card">
        <div class="card-header">
            <h3><?php echo e(__('Order information')); ?></h3>
        </div>
        <div class="card-body">
            <div class="customer-order-detail">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="order-slogan">
                            <?php if($logo = theme_option('logo_in_the_checkout_page') ?: theme_option('logo')): ?>
                                <img width="100" src="<?php echo e(RvMedia::getImageUrl($logo)); ?>" alt="<?php echo e(theme_option('site_title')); ?>">
                                <br/>
                            <?php endif; ?>
                            <?php echo e(setting('contact_address')); ?>

                        </div>
                    </div>
                </div>
                <?php echo $__env->make('plugins/ecommerce::themes.includes.order-tracking-detail', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <br>
                <div>
                    <?php if($order->isInvoiceAvailable()): ?>
                        <a href="<?php echo e(route('customer.print-order', $order->id)); ?>" class="btn btn-small btn-secondary mr-2">
                            <i class="fa fa-download"></i> <?php echo e(__('Download invoice')); ?>

                        </a>
                    <?php endif; ?>

                    <?php if($order->canBeCanceled()): ?>
                        <a href="<?php echo e(route('customer.orders.cancel', $order->id)); ?>" onclick="return confirm('<?php echo e(__('Are you sure?')); ?>')" class="btn btn-lg btn-danger">
                            <?php echo e(__('Cancel order')); ?>

                        </a>
                    <?php endif; ?>

                    <?php if($order->canBeReturned()): ?>
                            <a href="<?php echo e(route('customer.order_returns.request_view', $order->id)); ?>"
                               class="btn btn-lg btn-danger">
                                <?php echo e(__('Return Product(s)')); ?>

                            </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(Theme::getThemeNamespace() . '::views.ecommerce.customers.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/ecommerce3.elitedesign.com.bd/platform/themes/farmart/views/ecommerce/customers/orders/view.blade.php ENDPATH**/ ?>