<div class="row wishlist-page-content py-5 mt-3">
    <div class="col-12">
        <?php if($products->total() && $products->loadMissing(['options', 'options.values'])): ?>
            <table class="table cart-form__contents" cellspacing="0">
                <thead>
                    <tr>
                        <th class="product-thumbnail"></th>
                        <th class="product-name"><?php echo e(__('Product')); ?></th>
                        <th class="product-price product-md d-md-table-cell d-none"><?php echo e(__('Unit Price')); ?></th>
                        <th class="product-quantity product-md d-md-table-cell d-none"><?php echo e(__('Stock status')); ?></th>
                        <?php if(EcommerceHelper::isCartEnabled()): ?>
                            <th class="product-subtotal product-md d-md-table-cell d-none"></th>
                        <?php endif; ?>
                        <th class="product-remove"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="cart-form__cart-item cart_item">
                            <td class="product-thumbnail">
                                <a class="img-fluid-eq" href="<?php echo e($product->original_product->url); ?>">
                                    <div class="img-fluid-eq__dummy"></div>
                                    <div class="img-fluid-eq__wrap">
                                        <img class="lazyload" src="<?php echo e(image_placeholder($product->image, 'thumb')); ?>"
                                            data-src="<?php echo e(RvMedia::getImageUrl($product->image, 'thumb', false, RvMedia::getDefaultImage())); ?>" alt="<?php echo e($product->name); ?>">
                                    </div>
                                </a>
                            </td>
                            <td class="product-name d-md-table-cell d-block" data-title="Product">
                                <a href="<?php echo e($product->original_product->url); ?>"><?php echo BaseHelper::clean($product->name); ?></a>
                                <?php if(is_plugin_active('marketplace') && $product->original_product->store->id): ?>
                                    <div class="variation-group">
                                        <span class="text-secondary"><?php echo e(__('Vendor')); ?>:</span>
                                        <span class="text-primary ms-1">
                                            <a href="<?php echo e($product->original_product->store->url); ?>"><?php echo e($product->original_product->store->name); ?></a>
                                        </span>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td class="product-price product-md d-md-table-cell d-block" data-title="Price">
                                <div class="box-price">
                                    <span class="d-md-none title-price"><?php echo e(__('Price')); ?>: </span>
                                    <?php echo Theme::partial('ecommerce.product-price', compact('product')); ?>

                                </div>
                            </td>
                            <td class="product-quantity product-md d-md-table-cell d-block" data-title="Stock status">
                                <div class="without-bg product-stock <?php if($product->isOutOfStock()): ?> out-of-stock <?php else: ?> in-stock <?php endif; ?>">
                                    <?php if($product->isOutOfStock()): ?> <?php echo e(__('Out Of Stock')); ?> <?php else: ?> <?php echo e(__('In Stock')); ?> <?php endif; ?>
                                </div>
                            </td>
                            <?php if(EcommerceHelper::isCartEnabled()): ?>
                                <td class="product-subtotal product-md d-md-table-cell d-block" data-title="Total">
                                    <?php echo Theme::partial('ecommerce.product-cart-form', compact('product')); ?>

                                </td>
                            <?php endif; ?>
                            <td class="product-remove">
                                <button type="button" class="fs-4 remove btn remove-wishlist-item" href="#"
                                    data-url="<?php echo e(route('public.wishlist.remove', $product->id)); ?>"
                                    aria-label="<?php echo e(__('Remove this item')); ?>">
                                    <span class="svg-icon">
                                        <svg>
                                            <use href="#svg-icon-trash" xlink:href="#svg-icon-trash"></use>
                                        </svg>
                                    </span>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="pagination">
                <?php echo $products->links(); ?>

            </div>
        <?php else: ?>
            <p class="text-center"><?php echo e(__('No products in wishlist!')); ?></p>
        <?php endif; ?>
    </div>

</div>
<?php /**PATH /home/elitedesign/ecommerce13.elitedesign.com.bd/platform/themes/farmart/views/ecommerce/wishlist.blade.php ENDPATH**/ ?>