<?php if(is_plugin_active('blog')): ?>
    <?php
        $categories = app(\Botble\Blog\Repositories\Interfaces\CategoryInterface::class)
            ->advancedGet([
                'condition' => [
                    'status' => \Botble\Base\Enums\BaseStatusEnum::PUBLISHED
                ],
                'take'      => $config['number_display'] ?? 10,
                'with'      => ['slugable'],
            ]);
    ?>
    <?php if($categories->count()): ?>
        <div class="widget-sidebar widget-blog-categories">
            <h2 class="widget-title"><?php echo BaseHelper::clean($config['name'] ?: __('Categories')); ?></h2>
            <div class="widget__inner">
                <ul>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="cat-item">
                            <a href="<?php echo e($category->url); ?>"><?php echo BaseHelper::clean($category->name); ?></a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /home/elitede1/ecommerce13.elitedesign.com.bd/platform/themes/farmart/////widgets/blog-categories/templates/frontend.blade.php ENDPATH**/ ?>