<?php
    $slick = [
        'rtl'            => BaseHelper::siteLanguageDirection() == 'rtl',
        'appendArrows'   => '.arrows-wrapper',
        'arrows'         => true,
        'dots'           => false,
        'autoplay'       => $shortcode->is_autoplay == 'yes',
        'infinite'       => $shortcode->infinite == 'yes' || $shortcode->is_infinite == 'yes',
        'autoplaySpeed'  => in_array($shortcode->autoplay_speed, theme_get_autoplay_speed_options()) ? $shortcode->autoplay_speed : 3000,
        'speed'          => 800,
        'slidesToShow'   => 8,
        'slidesToScroll' => 1,
        'responsive'     => [
            [
                'breakpoint' => 1700,
                'settings'   => [
                    'slidesToShow' => 7,
                ],
            ],
            [
                'breakpoint' => 1500,
                'settings'   => [
                    'slidesToShow' => 6,
                ],
            ],
            [
                'breakpoint' => 1199,
                'settings'   => [
                    'slidesToShow' => 5,
                ],
            ],
            [
                'breakpoint' => 1024,
                'settings'   => [
                    'slidesToShow' => 4,
                ],
            ],
            [
                'breakpoint' => 767,
                'settings'   => [
                    'arrows'         => false,
                    'dots'           => true,
                    'slidesToShow'   => 2,
                    'slidesToScroll' => 2,
                ],
            ],
        ],
    ];

    $categories = get_featured_product_categories();
?>
<?php if($categories->count()): ?>
    <div class="widget-product-categories pt-5 pb-2">
        <div class="container-xxxl">
            <div class="row">
                <div class="col-12">
                    <div class="row align-items-center mb-2 widget-header">
                        <h2 class="col-auto mb-0 py-2"><?php echo BaseHelper::clean($shortcode->title); ?></h2>
                    </div>
                    <div class="product-categories-body pb-4 arrows-top-right">
                        <div data-slick="<?php echo e(json_encode($slick)); ?>" class="product-categories-box slick-slides-carousel">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="product-category-item p-3">
                                    <div class="category-item-body p-3">
                                        <a class="d-block py-3" href="<?php echo e($item->url); ?>">
                                            <div class="category__thumb img-fluid-eq mb-3">
                                                <div class="img-fluid-eq__dummy"></div>
                                                <div class="img-fluid-eq__wrap">
                                                    <img
                                                        class="lazyload mx-auto"
                                                        data-src="<?php echo e(RvMedia::getImageUrl($item->image, 'small', false, RvMedia::getDefaultImage())); ?>"
                                                        alt="<?php echo e($item->name); ?>" />
                                                </div>
                                            </div>
                                            <div class="category__text text-center py-3">
                                                <h6 class="category__name"><?php echo e($item->name); ?></h6>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="arrows-wrapper"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/elitedesignbd/ecom12.elitedesign.com.bd/platform/themes/farmart/partials/shortcodes/ecommerce/featured-product-categories.blade.php ENDPATH**/ ?>