<div class="ms-md-5 ps-md-5">
    <h2><?php echo e(__('Drop Us A Line')); ?></h2>
    <form class="mt-5 contact-form" action="<?php echo e(route('public.send.contact')); ?>" method="POST" role="form">
        <?php echo csrf_field(); ?>

        <?php echo apply_filters('pre_contact_form', null); ?>


        <div class="row">
            <div class="col-md-4">
                <div class="mb-3">
                    <label class="d-none sr-only" for="contact-name"><?php echo e(__('Name')); ?></label>
                    <input class="form-control py-3 px-3" type="text" id="contact-name" name="name" value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(__('Your Name *')); ?>">
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label class="d-none sr-only" for="contact-email"><?php echo e(__('Email')); ?></label>
                    <input class="form-control py-3 px-3" type="email" id="contact-email" name="email"  value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(__('Your Email *')); ?>">
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label class="d-none sr-only" for="contact-phone"><?php echo e(__('Phone')); ?></label>
                    <input class="form-control py-3 px-3" type="text" id="contact-phone" name="phone"  value="<?php echo e(old('phone')); ?>" placeholder="<?php echo e(__('Your Phone')); ?>">
                </div>
            </div>
            <div class="col-12">
                <div class="mb-3">
                    <label class="d-none sr-only" for="contact-subject"><?php echo e(__('Subject')); ?></label>
                    <input class="form-control py-3 px-3" type="text" id="contact-subject" name="subject" value="<?php echo e(old('subject')); ?>" placeholder="<?php echo e(__('Subject (optional)')); ?>">
                </div>
            </div>
            <div class="col-12">
                <div class="mb-3">
                    <label class="d-none sr-only" for="contact-message"><?php echo e(__('Message')); ?></label>
                    <textarea class="form-control py-3 px-3" id="contact-message" name="content" cols="40" rows="10" placeholder="<?php echo e(__('Write your message here')); ?>"><?php echo e(old('content')); ?></textarea>
                </div>
            </div>

            <?php if(is_plugin_active('captcha')): ?>
                <?php if(setting('enable_captcha')): ?>
                    <div class="col-12">
                        <div class="mb-3">
                            <?php echo Captcha::display(); ?>

                        </div>
                    </div>
                <?php endif; ?>

                <?php if(setting('enable_math_captcha_for_contact_form', 0)): ?>
                    <div class="col-12">
                        <div class="mb-3">
                            <label for="math-group"><?php echo e(app('math-captcha')->label()); ?></label>
                            <?php echo app('math-captcha')->input(['class' => 'form-control', 'id' => 'math-group', 'placeholder' => app('math-captcha')->getMathLabelOnly() . ' = ?']); ?>

                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <?php echo apply_filters('after_contact_form', null); ?>


            <div class="col-12">
                <div class="mt-4">
                    <button class="btn btn-primary" type="submit"><?php echo e(__('Send Message')); ?></button>
                </div>
            </div>
            <div class="col-12">
                <div class="contact-form-group mt-4">
                    <div class="contact-message contact-success-message" style="display: none"></div>
                    <div class="contact-message contact-error-message" style="display: none"></div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php /**PATH /home/elitede1/ecommerce13.elitedesign.com.bd/platform/themes/farmart/partials/shortcodes/contact-form.blade.php ENDPATH**/ ?>