<?php Theme::layout('full-width'); ?>

<?php echo Theme::partial('page-header'); ?>


<div class="container-xxxl">
    <div class="row mt-5">
        <div class="col-xl-3 col-lg-4">
            <aside class="catalog-primary-sidebar catalog-sidebar" data-toggle-target="product-categories-primary-sidebar">
                <div class="backdrop"></div>
                <div class="catalog-sidebar--inner side-left">
                    <div class="panel__header d-lg-none mb-4">
                        <span class="panel__header-title"><?php echo e(__('Filter Products')); ?></span>
                        <a class="close-toggle--sidebar" href="#" data-toggle-closest=".catalog-primary-sidebar">
                            <span class="svg-icon">
                                <svg>
                                    <use href="#svg-icon-arrow-right" xlink:href="#svg-icon-arrow-right"></use>
                                </svg>
                            </span>
                        </a>
                    </div>
                    <?php
                        $categories = ProductCategoryHelper::getActiveTreeCategories();
                        $categoriesRequest = (array)request()->input('categories', []);
                        $urlCurrent = URL::current();
                    ?>
                    <div class="catalog-filter-sidebar-content px-3 px-md-0">
                        <form action="<?php echo e(URL::current()); ?>"
                            data-action="<?php echo e($store->url); ?>"
                            method="GET"
                            id="products-filter-form">
                            <input type="hidden" name="sort-by" class="product-filter-item" value="<?php echo e(BaseHelper::stringify(request()->input('sort-by'))); ?>">
                            <input type="hidden" name="layout" class="product-filter-item" value="<?php echo e(BaseHelper::stringify(request()->input('layout'))); ?>">
                            <div class="widget-wrapper widget-product-categories">
                                <h4 class="widget-title"><?php echo e(__('All Categories')); ?></h4>
                                <input type="hidden" name="categories[]" value="<?php echo e(Arr::get($categoriesRequest, 0, '')); ?>" class="product-filter-item">
                                <div class="widget-layered-nav-list">
                                    <?php echo $__env->make(Theme::getThemeNamespace() . '::views.ecommerce.includes.categories', compact('categories', 'categoriesRequest', 'urlCurrent'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </aside>
            <aside class="catalog-primary-sidebar catalog-sidebar" data-toggle-target="contact-store-primary-sidebar">
                <div class="backdrop"></div>
                <div class="catalog-sidebar--inner side-left">
                    <div class="panel__header d-lg-none mb-4">
                        <span class="panel__header-title"><?php echo e(__('Contact Vendor')); ?></span>
                        <a class="close-toggle--sidebar" href="#" data-toggle-closest=".catalog-primary-sidebar">
                            <span class="svg-icon">
                                <svg>
                                    <use href="#svg-icon-arrow-right" xlink:href="#svg-icon-arrow-right"></use>
                                </svg>
                            </span>
                        </a>
                    </div>

                    <div class="catalog-filter-sidebar-content px-3 px-md-0">
                        <div class="widget-wrapper widget-contact-store">
                            <h4 class="widget-title"><?php echo e(__('Contact Vendor')); ?></h4>
                            <form class="form-contact-store" action="<?php echo e(route('public.ajax.contact-seller')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <div class="mb-3">
                                    <input class="form-control" type="text" name="name" <?php if(auth('customer')->check()): ?> value="<?php echo e(auth('customer')->user()->name); ?>" <?php endif; ?>
                                    placeholder="<?php echo e(__('Your Name')); ?>" <?php if(auth('customer')->check()): ?> disabled <?php else: ?> minlength="5" required="required" <?php endif; ?>>
                                </div>
                                <div class="mb-3">
                                    <input class="form-control" type="email" name="email" <?php if(auth('customer')->check()): ?> value="<?php echo e(auth('customer')->user()->email); ?>" <?php endif; ?>
                                    placeholder="you@example.com" <?php if(auth('customer')->check()): ?> disabled <?php else: ?> required="required" <?php endif; ?>>
                                </div>
                                <div class="mb-3">
                                    <textarea class="form-control" name="content" maxlength="5000" cols="25"
                                        rows="6" placeholder="<?php echo e(__('Type your message...')); ?>"
                                        required="required"></textarea>
                                </div>
                                <div class="d-grid">
                                    <button class="btn btn-primary" type="submit"><?php echo e(__('Send Message')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </aside>
        </div>
        <div class="col-xl-9 col-lg-8">
            <?php echo $__env->make(Theme::getThemeNamespace() . '::views.marketplace.includes.info-box', ['showContactVendor' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="row justify-content-center my-5 mb-2">
                <div class="col-12">
                    <div class="form-group">
                        <form action="<?php echo e(URL::current()); ?>" method="GET" class="products-filter-form-vendor">
                            <div class="input-group">
                                <input type="text" class="form-control" name="q" value="<?php echo e(BaseHelper::stringify(request()->query('q'))); ?>" form="products-filter-form" placeholder="<?php echo e(__('Search in this store...')); ?>">
                                <button type="submit" class="btn btn-primary px-3 justify-content-center">
                                    <span class="svg-icon me-2 d-block text-center w-100">
                                        <svg>
                                            <use href="#svg-icon-search" xlink:href="#svg-icon-search"></use>
                                        </svg>
                                    </span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="bg-light p-2 my-3">
                <div class="row catalog-header justify-content-between">
                    <div class="col-auto catalog-header__left d-flex align-items-center">
                        <h2 class="h6 catalog-header__title d-none d-lg-block mb-0 ps-2">
                            <span class="products-found">
                                <span class="text-primary me-1"><?php echo e($products->total()); ?></span><?php echo e(__('Products found')); ?>

                            </span>
                        </h2>
                        <a class="d-lg-none sidebar-filter-mobile" href="#" data-toggle="product-categories-primary-sidebar">
                            <span class="svg-icon me-2">
                                <svg>
                                    <use href="#svg-icon-filter" xlink:href="#svg-icon-filter"></use>
                                </svg>
                            </span>
                            <span><?php echo e(__('Filter')); ?></span>
                        </a>
                    </div>
                    <div class="col-auto catalog-header__right">
                        <div class="catalog-toolbar row align-items-center">
                            <?php echo $__env->make(Theme::getThemeNamespace() . '::views.ecommerce.includes.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="products-listing position-relative">
                <?php echo $__env->make(Theme::getThemeNamespace('views.marketplace.stores.items'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/elitedesignbd/ecommerce12.elitedesign.com.bd/platform/themes/farmart/views/marketplace/store.blade.php ENDPATH**/ ?>