<?php if(is_plugin_active('blog')): ?>
    <?php
        $posts = get_recent_posts($config['number_display']);
    ?>
    <?php if($posts->count()): ?>
        <div class="widget-sidebar widget-blog-latest-post">
            <h2 class="widget-title"><?php echo e($config['name'] ?: __('Recent Post')); ?></h2>
            <div class="widget__inner">
                <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card border-0 post-item-small mb-3">
                        <div class="row g-2">
                            <div class="col-3">
                                <a class="img-fluid-eq" href="<?php echo e($post->url); ?>" title="<?php echo e($post->name); ?>">
                                    <div class="img-fluid-eq__dummy"></div>
                                    <div class="img-fluid-eq__wrap">
                                        <img class="post-item-image lazyload"
                                            data-src="<?php echo e(RvMedia::getImageUrl($post->image, 'thumb', false, RvMedia::getDefaultImage())); ?>" alt="<?php echo e($post->name); ?>">
                                    </div>
                                </a>
                            </div>
                            <div class="col-9">
                                <div class="entry-meta">
                                    <div class="entry-meta-date">
                                        <time class="entry-date" datetime="<?php echo e($post->created_at); ?>"><?php echo e($post->created_at->translatedFormat('M d, Y')); ?></time>
                                        <?php if($post->author): ?>
                                            <span class="d-inline-block"><?php echo e(__('by')); ?></span> <span class="d-inline-block author-name"><?php echo e($post->author->name); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <h6 class="entry-title">
                                    <a href="<?php echo e($post->url); ?>"><?php echo BaseHelper::clean($post->name); ?></a>
                                </h6>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /home/elitedesign/ecommerce13.elitedesign.com.bd/platform/themes/farmart/////widgets/recent-posts/templates/frontend.blade.php ENDPATH**/ ?>