<?php Theme::layout('full-width'); ?>

<?php echo Theme::partial('page-header', ['withTitle' => false, 'size' => 'xl']); ?>

<div class="container">
    <div class="row customer-auth-page py-5 mt-5 justify-content-center">
        <div class="col-sm-9 col-md-6 col-lg-5 col-xl-4">
            <div class="customer-auth-form bg-light pt-1 py-3 px-4">
                <nav>
                    <div class="nav nav-tabs">
                        <h1 class="nav-link fs-5 fw-bold"><?php echo e(__('Log In Your Account')); ?></h1>
                    </div>
                </nav>
                <div class="tab-content my-3">
                    <div class="tab-pane fade pt-4 show active" id="nav-login-content" role="tabpanel"
                        aria-labelledby="nav-home-tab">
                        <?php if(isset($errors) && $errors->has('confirmation')): ?>
                            <div class="alert alert-danger">
                                <span><?php echo BaseHelper::clean($errors->first('confirmation')); ?></span>
                            </div>
                            <br>
                        <?php endif; ?>
                        <form class="mt-3" method="POST" action="<?php echo e(route('customer.login.post')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <input class="form-control <?php if($errors->has('email')): ?> is-invalid <?php endif; ?>" type="text" required=""
                                    placeholder="<?php echo e(__('Your Email')); ?>" name="email"
                                    autocomplete="email" value="<?php echo e(old('email')); ?>">
                                <?php if($errors->has('email')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('email')); ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="input-group mb-3 input-group-with-text">
                                <input class="form-control <?php if($errors->has('password')): ?> is-invalid <?php endif; ?>" type="password" placeholder="<?php echo e(__('Password')); ?>"
                                    aria-label="<?php echo e(__('Password')); ?>" autocomplete="current-password" name="password">
                                <span class="input-group-text">
                                    <a class="lost-password" href="<?php echo e(route('customer.password.reset')); ?>"><?php echo e(__('Forgot?')); ?></a>
                                </span>
                                <?php if($errors->has('password')): ?>
                                    <div class="invalid-feedback"><?php echo e($errors->first('password')); ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="form-check mb-3">
                                <input class="form-check-input" name="remember" id="remember-me"
                                    type="checkbox" value="1" <?php if(old('is_vendor') == 1): ?> checked="checked" <?php endif; ?>>
                                <label class="form-check-label" for="remember-me"><?php echo e(__('Remember me?')); ?></label>
                            </div>
                            <div class="d-grid">
                                <button class="btn btn-primary" type="submit"><?php echo e(__('Log in')); ?></button>
                            </div>
                            <div class="mt-3">
                                <p class="text-center"><?php echo e(__("Don't Have an Account?")); ?> <a href="<?php echo e(route('customer.register')); ?>" class="d-inline-block text-primary"><?php echo e(__('Sign up now')); ?></a></p>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="bg-light pt-1 px-4 pb-3">
                <?php echo apply_filters(BASE_FILTER_AFTER_LOGIN_OR_REGISTER_FORM, null, \Botble\Ecommerce\Models\Customer::class); ?>

            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/elitedesigncom/ecommerce3.elitedesign.com.bd/platform/themes/farmart/views/ecommerce/customers/login.blade.php ENDPATH**/ ?>