
<?php if($category): ?>
    <div class="widget-products-with-category py-5 bg-light">
        <div class="container-xxxl">
            <div class="row">
                <div class="col-12">
                    <div class="row align-items-center mb-2 widget-header">
                        <h2 class="col-auto mb-0 py-2"><?php echo e($shortcode->title ?: $category->name); ?></h2>
                    </div>
                    <product-category-products-component
                        limit="<?php echo e($shortcode->limit); ?>"
                        :category="<?php echo e(json_encode($category)); ?>"
                        :children="<?php echo e(json_encode($category->activeChildren)); ?>"
                        url="<?php echo e(route('public.ajax.product-category-products')); ?>"
                        all="<?php echo e($category->url); ?>"
                        slick_config="<?php echo e(json_encode([
                            'rtl' => BaseHelper::siteLanguageDirection() == 'rtl',
                            'appendArrows' => '.arrows-wrapper',
                            'arrows' => true,
                            'dots' => false,
                            'autoplay' => $shortcode->is_autoplay == 'yes',
                            'infinite' => $shortcode->infinite == 'yes' || $shortcode->is_infinite == 'yes',
                            'autoplaySpeed' => in_array($shortcode->autoplay_speed, theme_get_autoplay_speed_options()) ? $shortcode->autoplay_speed : 3000,
                            'speed' => 800,
                            'slidesToShow' => 6,
                            'slidesToScroll' => 1,
                            'swipeToSlide' => true,
                            'responsive' => [
                                [
                                    'breakpoint' => 1400,
                                    'settings' => [
                                        'slidesToShow' => 5,
                                    ],
                                ],
                                [
                                    'breakpoint' => 1199,
                                    'settings' => [
                                        'slidesToShow' => 4,
                                    ],
                                ],
                                [
                                    'breakpoint' => 1024,
                                    'settings' => [
                                        'slidesToShow' => 3,
                                    ],
                                ],
                                [
                                    'breakpoint' => 767,
                                    'settings' => [
                                        'arrows' => true,
                                        'dots' => false,
                                        'slidesToShow' => 2,
                                        'slidesToScroll' => 2,
                                    ],
                                ],
                            ],
                        ])); ?>"
                    ></product-category-products-component>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/elitede1/ecommerce13.elitedesign.com.bd/platform/themes/farmart/partials/shortcodes/ecommerce/product-category-products.blade.php ENDPATH**/ ?>