<a href="https://www.php.net/"><img src="https://img.shields.io/github/languages/top/khaled-alshamaa/ar-php"/></a> <a href="https://www.php.net/manual/en/migration56.php"><img src="https://img.shields.io/packagist/php-v/khaled.alshamaa/ar-php"/></a> <a href="https://github.com/khaled-alshamaa/ar-php/releases/tag/v6.3.1"><img src="https://img.shields.io/github/v/release/khaled-alshamaa/ar-php"/></a> <a href="https://github.com/khaled-alshamaa/ar-php/tags"><img src="https://img.shields.io/github/release-date/khaled-alshamaa/ar-php"/></a> <a href="https://www.gnu.org/licenses/lgpl-3.0.en.html"><img src="https://img.shields.io/packagist/l/khaled.alshamaa/ar-php"/></a> [![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-2.1-4baaaa.svg)](code_of_conduct.md) <a href="https://packagist.org/packages/khaled.alshamaa/ar-php/stats"><img src="https://img.shields.io/packagist/dt/khaled.alshamaa/ar-php"/></a> <a href="https://github.com/khaled-alshamaa/ar-php/stargazers"><img src="https://img.shields.io/packagist/stars/khaled.alshamaa/ar-php"/></a> <a href="https://hits.seeyoufarm.com"><img src="https://hits.seeyoufarm.com/api/count/incr/badge.svg?url=https%3A%2F%2Fgithub.com%2Fkhaled-alshamaa%2Far-php&count_bg=%2379C83D&title_bg=%23555555&icon=&icon_color=%23E7E7E7&title=hits&edge_flat=false"/></a><a href="https://github.com/khaled-alshamaa/ar-php/issues"><img src="https://img.shields.io/github/issues-raw/khaled-alshamaa/ar-php"/></a> <img src="https://img.shields.io/github/languages/code-size/khaled-alshamaa/ar-php"/> <a href="https://github.com/khaled-alshamaa/ar-php/commits/master"><img src="https://img.shields.io/github/commit-activity/m/khaled-alshamaa/ar-php"/></a> <a href="https://github.com/khaled-alshamaa/ar-php/commits/master"><img src="https://img.shields.io/github/last-commit/khaled-alshamaa/ar-php"/></a> <a href="https://github.com/khaled-alshamaa/ar-php/network/members"><img src="https://img.shields.io/github/forks/khaled-alshamaa/ar-php?style=social"/></a> <a href="https://twitter.com/arphp"><img src="https://img.shields.io/twitter/follow/arphp?style=social"></a>
<!-- https://shields.io/ -->

<img align="right" width="256" height="256" src="https://raw.githubusercontent.com/khaled-alshamaa/ar-php/master/ar-php_256.png">

# Ar-PHP Project ([ar-php.org](http://www.ar-php.org/en_index-php-arabic.html))
#### _PHP Speaks Arabic - Be Ready!_
_Copyright © 2006-2023 Khaled Al-Sham'aa._

[![DOI](https://zenodo.org/badge/231197063.svg)](https://zenodo.org/badge/latestdoi/231197063)

[العربية](https://github.com/khaled-alshamaa/ar-php/blob/master/README_ar.md)

### Mission & Vision
As has happened in the Far East and Latin America, as the Internet goes to the masses, people want it in their native language.

Our mission is to develop open source solutions and provides professional support helps small and medium size companies meet the challenges of developing professional Arabic websites in the PHP/MySQL environment, the library that we develop helps our partners in save time and increase productivity.

This project provides a set of tools that enable Arabic website developers to serve professional search, present and process Arabic content in PHP.

> [Easy Installation](#quick-start)

> [List of Main Functionalities](#main-functionalities) 

> [Change Log](https://github.com/khaled-alshamaa/ar-php/blob/master/CHANGELOG.md)

> [Class Documentation](https://ar-php.org/github/docs/classes/ArPHP-I18N-Arabic.html)

> [Migrating from Version 4.0](https://github.com/khaled-alshamaa/ar-php/blob/master/UPGRADE.md)

> [Contributors Logistics](https://github.com/khaled-alshamaa/ar-php/blob/master/TODO.md)

> [How to Contribute?](#how-to-contribute)

> [Professional Support](#professional-support)

### Citation

If you would cite it in academic work, you can use this citation

```
K. Al-Shamaa, Ar-PHP, PHP library for website developers to process Arabic content, 
https://github.com/khaled-alshamaa/ar-php, 2023
```

or in bibtex format

```latex
@misc{ar-php,
  title={Ar-PHP, PHP library for website developers to process Arabic content},
  author={Al-Shamaa, Khaled},
  url={https://github.com/khaled-alshamaa/ar-php},
  version = {6.3.2},
  year={2023}
}
```

### Where it has been used?

* [Akeneo](https://www.akeneo.com/): The easy and flexible open source SaaS PIM to organize and enrich your product catalog. [check it out [here](https://github.com/akeneo/pim-community-dev/blob/master/src/Akeneo/Pim/Enrichment/Bundle/PdfGeneration/HtmlFormatter/ArabicHtmlFormatter.php)]

* [Bagisto](https://www.bagisto.com/): Laravel package for e-commerce. [check it out [here](https://github.com/bagisto/bagisto/blob/bf1c3f21af912800ffad5dcf68b9a486af0f6c81/packages/Webkul/Admin/src/Http/Controllers/Sales/InvoiceController.php#L159)]

* [LimeSurvey](https://www.limesurvey.org/): Open-source survey software. 
[[version 3.6.0](https://github.com/LimeSurvey/LimeSurvey/tree/master/application/third_party/ar-php), check it out [here](https://github.com/LimeSurvey/LimeSurvey/blob/master/application/helpers/userstatistics_helper.php#L134) and 
[here](https://github.com/LimeSurvey/LimeSurvey/blob/master/application/helpers/admin/statistics_helper.php#L133)]


### Arabic Language
Worldwide Internet use has grown tremendously in recent years, most rapidly in non-English speaking regions especially in Arab world. For example, from 2000 to 2020, the online populations grew by more than 9,300 %. Meanwhile, Arabic Web content was estimated to be doubling every year. Such growth has created demand for better websites developing resources in Arabic language. However, existing websites developing resources may be unable to meet it because they primarily serve English-speaking users.

[[Arabic language](https://en.wikipedia.org/wiki/Arabic), [Internet world stats](https://www.internetworldstats.com/stats7.htm)]

### PHP
PHP is a widely-used general-purpose scripting language that is especially suited for web development and can be embedded into HTML. PHP runs more than 79% of all the top 10 million worldwide web sites a few very good examples are Facebook and Wikipedia.

[[PHP language](https://www.php.net/), [Server-side languages report](https://w3techs.com/technologies/overview/programming_language)]

### LGPL
The main difference between the GPL and the LGPL is that the latter can be linked to (in the case of a library, 'used by') a non-(L)GPLed program, which may be free software or proprietary software. This non-(L)GPLed program can then be distributed under any chosen terms if it is not a derivative work.

[[LGPL](http://www.gnu.org/licenses/lgpl-3.0.html), [GNU FAQ](http://www.gnu.org/licenses/gpl-faq.html)]

### History

<a href="https://darshoaa.com/pHP-and-Arabic-language/" target="_blank"><img align="right" width="171" height="256" src="https://user-images.githubusercontent.com/11270404/129626204-d354e794-bfbf-4f3c-bc22-27e7fc252701.png" border="0"></a>

* PHP 7 at [GitHub.com](https://github.com/khaled-alshamaa/ar-php) starting in 2020.
* PHP 5 at [SourceForge.net](https://sourceforge.net/projects/ar-php/) 2008-2016.
* PHP 4 at [PHPClasses.org](https://www.phpclasses.org/browse/author/189864.html) 2006-2008.

[![محاضرة افتتاحية عن تجربة بناء ادوات لدعم اللغة العربية و المشاريع مفتوحة المصدر - خالد الشمعة](https://img.youtube.com/vi/P4zV1Iu5QcE/0.jpg)](https://www.youtube.com/watch?v=P4zV1Iu5QcE)

[Top](#ar-php-project-ar-phporg)

## _Quick Start_

### Install with Composer

To install with [Composer](https://getcomposer.org/), simply require the latest version of this package.

```bash
composer require khaled.alshamaa/ar-php
```

Make sure that the autoload file from Composer is loaded. *if you are using composer for autoloading like what Laravel framework does, you don't have to do that.*

```php
// somewhere early in your project's loading, require the Composer autoloader
// see: http://getcomposer.org/doc/00-intro.md
require 'vendor/autoload.php';
```

### Download and Install (Manually)

Download the [latest release](https://github.com/khaled-alshamaa/ar-php/releases/latest) of Ar-PHP library and extract it into the directory where it will be used.

```php
require_once 'ar-php/src/Arabic.php';
```

### Main Functionalities
* Arabic Sentiment Analysis ([live demo 1](https://ar-php.org/github/examples/ar_sentiment.php), [live demo 2](https://ar-php.org/github/examples/ar_sentiment.html))
* English-Arabic Transliteration ([live demo 1](https://ar-php.org/github/examples/ar_transliteration.php), [live demo 2](https://ar-php.org/github/examples/en_transliteration.php))
* Spell Numbers in the Arabic Idiom ([live demo](https://ar-php.org/github/examples/numbers.php))
* Arabic Glyphs to Render Arabic Text ([live demo](https://ar-php.org/github/examples/ar_glyphs.php))
* Arabic Keyboard Swapping Language ([live demo](https://ar-php.org/github/examples/keyswap.php))
* Arabic Soundex ([live demo](https://ar-php.org/github/examples/soundex.php))
* Arabic Gender Guesser ([live demo](https://ar-php.org/github/examples/gender.php))
* Arabic SQL Query ([live demo](https://ar-php.org/github/examples/ar_query.php))
* Muslim Prayer Times & Qibla Determination ([live demo](https://ar-php.org/github/examples/salat.php))
* Arabic/Hijri Date ([live demo](https://ar-php.org/github/examples/date.php))
* Arabic/Hijri Maketime ([live demo](https://ar-php.org/github/examples/mktime.php))
* Arabic StrToTime ([live demo](https://ar-php.org/github/examples/strtotime.php))
* Arabic Text Standardize ([live demo](https://ar-php.org/github/examples/standard.php))
* Arabic Auto Summarize ([live demo](https://ar-php.org/github/examples/ar_summarize.php))
* Arabic Segments Identifier ([live demo](https://ar-php.org/github/examples/identifier.php))

[Top](#ar-php-project-ar-phporg)

## _How to Contribute?_
We always welcome new contributors – especially new programmers. But no matter what your skills and interests are, there is a place where you can participate to improve Ar-PHP project:

* __Programming:__ Here are some ideas for contribution: Review the To-Dos, add a feature, contribute to a core module, create an extension, and fix a bug.
* __Quality Assurance:__ Quality Assurance (QA) is one of the most important but understated elements of any software community project. It is also something most people can do. If you want to help fix Ar-PHP bugs, and you are not a programmer, you can still help by joining the QA team.
* __Writing:__ One of the best ways to contribute to Ar-PHP is to write tutorials, guides, HOWTOs and FAQs. Here are some ideas for contribution: User FAQs, HOW-Tos and Tutorials, User Guide, Development Primer, Blog Posts, and Article for a Magazine.
* __Marketing:__ You can always help promote the use of Ar-PHP. Here are two ways you can help: Join the marketing events, distribute Ar-PHP, and Ar-PHP brochure.
* __Graphics and Art:__ Have any art skills? Then you can help us create icons, logos, banners, labels, wallpapers, screen savers, and more! These will be seen every day and used throughout the project and its products.
* __Helping Users:__ There are two ways you can help other users: Users mailing list, and forums.
* __Celebrate with us!__ Your task is to take a picture of yourself supporting PHP and Arabic language project. You can go to a famous landmark, your favorite place nearby, or anywhere you think will make for a great photo. We've created some posters for you to use in your pictures. Print out one of these designs or design your own. We want to see you and your location prominently displayed in the picture, so don't let one of them dominate the photo. And we should clearly see your Ar-PHP poster too. Once you have your photos ready to submit, email them to us. Please send your photos in .jpg or .png formats and at least 1200 x 800 pixels in size.

[Top](#ar-php-project-ar-phporg)

## _Professional Support_
As the developers of Ar-PHP project, we can help your company leverage the maximum power of Ar-PHP to achieve your business goals. We offer professional services that span the full life-cycle of Ar-PHP implementation.

* __Ar-PHP Library Integration:__ Having trouble getting started with Ar-PHP? We can help.
* __Ar-PHP Upgrades:__ For smooth upgrade to a newer version of Ar-PHP, let us assist you.
* __Customization and Configuration:__ If your business requires functionality beyond or different from that of the feature set of Ar-PHP, our team of PHP and Arabic language experts can fully tailor Ar-PHP to meet your specific business needs.
* __Integration Analysis and Implementation:__ Arabic localization may be just a component of your entire online business operation. We have the knowledge and experience to integrate Ar-PHP with all the arms of your operation.
* __Troubleshooting, Optimization and Performance Tuning:__ For increased performance and bottleneck resolution let an Ar-PHP expert look under the hood of your Ar-PHP implementation and server environment.
* __Consulting:__ At any point in the implementation of Ar-PHP you can call upon a Ar-PHP expert to verify that your implementation follows industry best practices.
* __Training:__ Get comprehensive training for Ar-PHP.

[Top](#ar-php-project-ar-phporg)

<!-- If you find this project useful, please consider making a donation. Any funds donated will be used to help further development on this project. -->
