<div class="customer-order-detail">
    <div class="row">
        <div class="col-md-6">
            <h5><?php echo e(__('Order information')); ?></h5>
            <p>
                <span><?php echo e(__('Order number')); ?>: </span>
                <strong><?php echo e($order->code); ?></strong>
            </p>
            <p>
                <span><?php echo e(__('Time')); ?>: </span>
                <strong><?php echo e($order->created_at->format('h:m d/m/Y')); ?></strong>
            </p>
        </div>
        <div class="col-md-6">
            <p>
                <span><?php echo e(__('Completed at')); ?>: </span>
                <strong class="text-info"><?php echo e($order->completed_at->format('h:m d/m/Y')); ?></strong>
            </p>
            <?php if($order->shipment && $order->shipment->id): ?>
                <p>
                    <span><?php echo e(__('Shipment Status')); ?>: </span>
                    <strong class="text-info"><?php echo e($order->shipment->status->label()); ?></strong>
                </p>
            <?php endif; ?>
            <p>
                <span><?php echo e(__('Payment status')); ?>: </span>
                <strong class="text-info"><?php echo e($order->payment->status->label()); ?></strong>
            </p>
        </div>
    </div>
    <br/>
    <?php echo Form::open(['url' => route('customer.order_returns.send_request'), 'method' => 'POST']); ?>

        <?php echo Form::hidden('order_id', $order->id); ?>


        <?php if(! EcommerceHelper::allowPartialReturn()): ?>
            <div class="col-sm-6 col-md-3 form-group">
                <label for="reason" class="col-form-label">
                    <strong><?php echo e(__('Return Reason')); ?>:</strong>
                </label>
                <?php echo Form::select('reason', \Botble\Ecommerce\Enums\OrderReturnReasonEnum::labels(), old('reason'), [
                        'class' => 'form-control form-select',
                        'placeholder' => __('Choose Reason'),
                    ]); ?>

            </div>
            <br/>
        <?php endif; ?>

        <h5><?php echo e(__('Choose products')); ?></h5>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover align-middle">
                        <thead>
                            <tr>
                                <th class="text-center">#</th>
                                <th class="text-center"><?php echo e(__('Image')); ?></th>
                                <th><?php echo e(__('Product')); ?></th>
                                <th><?php echo e(__('Price')); ?></th>
                                <th class="text-center"><?php echo e(__('Quantity')); ?></th>
                                <?php if(EcommerceHelper::allowPartialReturn()): ?>
                                    <th class="text-center">
                                        <label class="required"><?php echo e(__('Reason')); ?></label>
                                    </th>
                                <?php endif; ?>
                                <th><?php echo e(__('Refund amount')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $totalRefundAmount = $order->amount - $order->shipping_amount;
                                $totalPriceProducts = $order->products->sum(function ($item) {
                                    return $item->total_price_with_tax;
                                });
                                $ratio = $totalRefundAmount <= 0 ? 0 : $totalPriceProducts / $totalRefundAmount;
                            ?>

                            <?php $__currentLoopData = $order->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $orderProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center">
                                        <div class="form-check">
                                            <?php echo Form::checkbox('return_items[' . $key . '][is_return]', $orderProduct->id, old('return_items.' . $key . '.is_return', true), [
                                                'class' => 'form-check-input'
                                            ]); ?>

                                        </div>
                                        <input type="hidden" name="return_items[<?php echo e($key); ?>][order_item_id]" value="<?php echo e($orderProduct->id); ?>">
                                    </td>
                                    <td class="text-center">
                                        <img src="<?php echo e(RvMedia::getImageUrl($orderProduct->product_image, 'thumb', false, RvMedia::getDefaultImage())); ?>"
                                            alt="<?php echo e($orderProduct->product_name); ?>" width="50">
                                    </td>
                                    <td>
                                        <span><?php echo e($orderProduct->product_name); ?></span>
                                        <?php if($sku = Arr::get($orderProduct->options, 'sku')): ?>
                                            <span><?php echo e($sku); ?></span>
                                        <?php endif; ?>
                                        <?php if($attributes = Arr::get($orderProduct->options, 'attributes')): ?>
                                            <p>
                                                <small><?php echo e($attributes); ?></small>
                                            </p>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <span><?php echo e(format_price($orderProduct->price_with_tax)); ?></span>
                                    </td>
                                    <?php if(EcommerceHelper::allowPartialReturn()): ?>
                                        <td class="product-quantity product-md d-md-table-cell d-block" data-title="Quantity">
                                            <?php
                                                $qtyChooses = [];
                                                for ($i = 1; $i <= $orderProduct->qty; $i++) { 
                                                    $qtyChooses[$i] = [
                                                        'data-qty' => $i,
                                                        'data-amount' => format_price($ratio == 0 ? 0 : ($orderProduct->price_with_tax * $i / $ratio)),
                                                    ];
                                                }
                                            ?>
                                            <div class="form-group">
                                                <?php echo Form::select('return_items[' . $key . '][qty]', collect($qtyChooses)->pluck('data-qty', 'data-qty'), old('return_items.' . $key . '.qty', $orderProduct->qty), [
                                                    'class' => 'form-select select-return-item-qty'
                                                ], $qtyChooses); ?>

                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <?php echo Form::select('return_items[' . $key . '][reason]', \Botble\Ecommerce\Enums\OrderReturnReasonEnum::labels(), old('return_items.' . $key . '.reason'), [
                                                'class' => 'form-control form-select',
                                                'placeholder' => __('Choose Reason'),
                                            ]); ?>

                                        </td>
                                    <?php else: ?>
                                        <td class="text-center">
                                            x <?php echo e($orderProduct->qty); ?>

                                        </td>
                                    <?php endif; ?>
                                    <td class="text-center">
                                        <span class="return-amount"><?php echo e(format_price($ratio == 0 ? 0 : ($orderProduct->total_price_with_tax / $ratio))); ?></span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <br/>

            <div class="col-md-12 pt-3">
                <?php if($order->canBeReturned()): ?>
                    <?php echo Form::submit(__('Submit Return Request'), ['class' => 'btn btn-lg btn-danger']); ?>

                <?php endif; ?>
            </div>
        </div>
    <?php echo Form::close(); ?>

</div>
<?php /**PATH /home/elitede1/ecommerce12.elitedesign.com.bd/platform/plugins/ecommerce/resources/views/themes/includes/order-return-form.blade.php ENDPATH**/ ?>