<form action="<?php echo e(route('customers.addresses.create.store')); ?>" method="POST">
    <input type="hidden" name="customer_id" value="<?php echo e($data['customer']->id); ?>">
    <div class="row">
        <div class="col-md-6">
            <div class="form-group mb-3 <?php if($errors->has('name')): ?> has-error <?php endif; ?>">
                <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.name')); ?></label>
                <input type="text" name="name" id="address_name" placeholder="<?php echo e(trans('plugins/ecommerce::addresses.name_placeholder')); ?>" class="form-control address-control-item address-control-item-required checkout-input"
                       value="<?php echo e(old('name')); ?>">
                <?php echo Form::error('name', $errors); ?>

            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group mb-3 <?php if($errors->has('phone')): ?> has-error <?php endif; ?>">
                <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.phone')); ?></label>
                <input type="text" name="phone" id="address_phone" placeholder="<?php echo e(trans('plugins/ecommerce::addresses.phone_placeholder')); ?>" class="form-control address-control-item address-control-item-required checkout-input"
                       value="<?php echo e(old('phone')); ?>">
                <?php echo Form::error('phone', $errors); ?>

            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="form-group mb-3 <?php if($errors->has('zip_code')): ?> has-error <?php endif; ?>">
                <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.zip')); ?></label>
                <input type="text" name="zip_code" id="address_zip_code" placeholder="<?php echo e(trans('plugins/ecommerce::addresses.zip_placeholder')); ?>" class="form-control address-control-item address-control-item-required checkout-input"
                       value="<?php echo e(old('zip_code')); ?>">
                <?php echo Form::error('zip_code', $errors); ?>

            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group mb-3 <?php if($errors->has('email')): ?> has-error <?php endif; ?>">
                <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.email')); ?></label>
                <input type="text" name="email" id="address_email" placeholder="<?php echo e(trans('plugins/ecommerce::addresses.email_placeholder')); ?>" class="form-control address-control-item address-control-item-required checkout-input"
                       value="<?php echo e(old('email')); ?>">
                <?php echo Form::error('email', $errors); ?>

            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="form-group mb-3 <?php if($errors->has('address')): ?> has-error <?php endif; ?>">
                <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.address')); ?></label>
                <input type="text" name="address" id="address_address" placeholder="<?php echo e(trans('plugins/ecommerce::addresses.address_placeholder')); ?>" class="form-control address-control-item address-control-item-required checkout-input"
                       value="<?php echo e(old('address')); ?>">
                <?php echo Form::error('address', $errors); ?>

            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <?php if(EcommerceHelper::isUsingInMultipleCountries()): ?>
                <div class="form-group mb-3 <?php if($errors->has('country')): ?> has-error <?php endif; ?>">
                    <label for="country"><?php echo e(trans('plugins/ecommerce::addresses.country')); ?>:</label>
                    <select name="country" class="form-control" id="country" data-type="country">
                        <?php $__currentLoopData = EcommerceHelper::getAvailableCountries(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $countryCode => $countryName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if(old('country') == $countryCode): echo 'selected'; endif; ?> value="<?php echo e($countryCode); ?>" <?php if(old('country') == $countryCode): ?> selected <?php endif; ?>><?php echo e($countryName); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <?php echo Form::error('country', $errors); ?>

            <?php else: ?>
                <input type="hidden" name="country" value="<?php echo e(EcommerceHelper::getFirstCountryId()); ?>">
            <?php endif; ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="form-group mb-3 <?php if($errors->has('state')): ?> has-error <?php endif; ?>">
                <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.state')); ?></label>
                <?php if(EcommerceHelper::loadCountriesStatesCitiesFromPluginLocation()): ?>
                    <select name="state" class="form-control" id="state" data-type="state" data-url="<?php echo e(route('ajax.states-by-country')); ?>">
                        <option value=""><?php echo e(trans('plugins/ecommerce::addresses.select_state')); ?></option>
                        <?php if(old('country') || ! EcommerceHelper::isUsingInMultipleCountries()): ?>
                            <?php $__currentLoopData = EcommerceHelper::getAvailableStatesByCountry(old('country')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stateId => $stateName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($stateId); ?>" <?php if(old('country') == $stateId): echo 'selected'; endif; ?>><?php echo e($stateName); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                <?php else: ?>
                    <input id="state" type="text" class="form-control" name="state" value="<?php echo e(old('state')); ?>">
                <?php endif; ?>
                <?php echo Form::error('state', $errors); ?>

            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group mb-3 <?php if($errors->has('city')): ?> has-error <?php endif; ?>">
                <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.city')); ?></label>
                <?php if(EcommerceHelper::loadCountriesStatesCitiesFromPluginLocation()): ?>
                    <select name="city" class="form-control" id="city" data-type="city" data-url="<?php echo e(route('ajax.cities-by-state')); ?>">
                        <option value=""><?php echo e(trans('plugins/ecommerce::addresses.select_city')); ?></option>
                        <?php if(old('state')): ?>
                            <?php $__currentLoopData = EcommerceHelper::getAvailableCitiesByState(old('state')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cityId => $cityName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cityId); ?>" <?php if(old('city') == $cityId): echo 'selected'; endif; ?>><?php echo e($cityName); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                <?php else: ?>
                    <input id="city" type="text" class="form-control" name="city" value="<?php echo e(old('city')); ?>">
                <?php endif; ?>
                <?php echo Form::error('city', $errors); ?>

            </div>
        </div>
    </div>
</form>
<?php /**PATH /home/elitedes/ecommerce2.elitedesign.com.bd/platform/plugins/ecommerce/resources/views/customers/addresses/form.blade.php ENDPATH**/ ?>