<div class="ps-section__left">
    <div class="row">
        <?php if(!$totalProducts): ?>
            <div class="col-12">
                <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
                    <symbol id="check-circle-fill" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z"/>
                    </symbol>
                </svg>
                <div class="alert alert-success" role="alert">
                    <h4 class="alert-heading">
                        <svg class="bi flex-shrink-0 me-2" width="24" height="24" role="img" aria-label="Info:"><use xlink:href="#check-circle-fill"/></svg>
                        <?php echo e(__('Congratulations on being a vendor at :site_title', ['site_title' => theme_option('site_title')])); ?>

                    </h4>
                    <p><?php echo e(__('Attract your customers with the best products.')); ?></p>
                    <hr>
                    <p class="mb-0"><?php echo __('Create a new product <a href=":url">here</a>', ['url' => route('marketplace.vendor.products.create')]); ?></p>
                </div>
            </div>
        <?php elseif(!$totalOrders): ?>
            <div class="col-12">
                <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
                    <symbol id="info-fill" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16zm.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2z"/>
                      </symbol>
                </svg>
                <div class="alert alert-info" role="alert">
                    <h4 class="alert-heading">
                        <svg class="bi flex-shrink-0 me-2" width="24" height="24" role="img" aria-label="Info:"><use xlink:href="#info-fill"/></svg>
                        <?php echo e(__('You have :total product(s) but no orders yet', ['total' => $totalProducts])); ?>

                    </h4>
                    <hr>
                    <p class="mb-0"><?php echo __('View your store <a href=":url">here</a>', ['url' => $user->store->url]); ?></p>
                </div>
            </div>
        <?php else: ?>
            <div class="col-md-8">
                <div class="ps-card ps-card--sale-report">
                    <div class="ps-card__header">
                        <h4><?php echo e(__('Sales Reports')); ?></h4>
                        <a href="<?php echo e(route('marketplace.vendor.revenues.index')); ?>">
                            <small><?php echo e(__('Revenues in :label', ['label' => $data['predefinedRange']])); ?> <i class="fas fa-angle-double-right"></i></small>
                        </a>
                    </div>
                    <div class="ps-card__content">
                        <sales-reports-chart url="<?php echo e(route('marketplace.vendor.chart.month', [
                            'date_from' => $data['startDate']->translatedFormat('Y-m-d'),
                            'date_to'   => $data['endDate']->translatedFormat('Y-m-d')
                        ])); ?>" ></sales-reports-chart>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="ps-card ps-card--earning">
                    <div class="ps-card__header">
                        <h4><?php echo e(__('Earnings')); ?></h4>
                        <div class="text-primary">
                            <small><?php echo e(__('Earnings in :label', ['label' => $data['predefinedRange']])); ?></small>
                        </div>
                    </div>
                    <div class="ps-card__content">
                        <div class="ps-card__chart">
                            <revenue-chart :data="<?php echo e(json_encode([
                                ['label' => __('Revenue'), 'value' => $data['revenue']['amount'], 'color' => '#80bc00'],
                                ['label' => __('Fees'), 'value' => $data['revenue']['fee'], 'color' => '#fcb800'],
                                ['label' => __('Withdrawals'), 'value' => $data['revenue']['withdrawal'], 'color' => '#fc6b00']])); ?>"></revenue-chart>
                            <div class="ps-card__information">
                                <i class="icon-wallet"></i>
                                <strong><?php echo e(format_price($data['revenue']['sub_amount'])); ?></strong>
                                <small><?php echo e(__('Balance')); ?></small>
                            </div>
                        </div>
                        <div class="ps-card__status">
                            <p class="green">
                                <strong><?php echo e(format_price($data['revenue']['amount'])); ?></strong><span><?php echo e(__('Revenue')); ?></span>
                            </p>
                            <p class="red">
                                <strong><?php echo e(format_price($data['revenue']['withdrawal'])); ?></strong><span data-bs-toggle="tooltip" data-bs-original-title="<?php echo e(__('Includes Completed, Pending, and Processing statuses')); ?>"><?php echo e(__('Withdrawals')); ?></span>
                            </p>
                            <p class="yellow">
                                <strong><?php echo e(format_price($data['revenue']['fee'])); ?></strong><span><?php echo e(__('Fees')); ?></span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <?php if($totalOrders): ?>
        <div class="ps-card">
            <div class="ps-card__header">
                <h4><?php echo e(__('Recent Orders')); ?></h4>
            </div>
            <div class="ps-card__content">
                <div class="table-responsive">
                    <table class="table ps-table">
                        <thead>
                        <tr>
                            <th><?php echo e(__('ID')); ?></th>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('Customer')); ?></th>
                            <th><?php echo e(__('Payment')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Total')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $data['orders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><a href="<?php echo e(route('marketplace.vendor.orders.edit', $order->id)); ?>"><?php echo e(get_order_code($order->id)); ?></a></td>
                                    <td><strong><?php echo e($order->created_at->translatedFormat('M d, Y')); ?></strong></td>
                                    <td><a href="<?php echo e(route('marketplace.vendor.orders.edit', $order->id)); ?>"><strong><?php echo e($order->user->name ?: $order->address->name); ?></strong></a></td>
                                    <td><?php echo BaseHelper::clean($order->payment->status->toHtml()); ?></td>
                                    <td><?php echo BaseHelper::clean($order->status->toHtml()); ?></td>
                                    <td><strong><?php echo e(format_price($order->amount)); ?></strong></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center"><?php echo e(__('No orders!')); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="ps-card__footer"><a class="ps-card__morelink" href="<?php echo e(route('marketplace.vendor.orders.index')); ?>"><?php echo e(__('View Full Orders')); ?><i class="icon icon-chevron-right"></i></a></div>
        </div>
    <?php endif; ?>

    <?php if($totalProducts): ?>
        <hr>
        <div class="ps-card">
            <div class="ps-card__header">
                <h4><?php echo e(__('Top Selling Products')); ?></h4>
            </div>
            <div class="ps-card__content">
                <div class="table-responsive">
                    <table class="table ps-table">
                        <thead>
                        <tr>
                            <th><?php echo e(__('ID')); ?></th>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Amount')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Created at')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $data['products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($product->id); ?></td>
                                    <td><a href="<?php echo e(route('marketplace.vendor.products.edit', $product->id)); ?>"><strong><?php echo BaseHelper::clean($product->name); ?></strong></a></td>
                                    <td><strong><?php echo BaseHelper::clean($product->price_in_table); ?></strong></td>
                                    <td><?php echo BaseHelper::clean($product->status->toHtml()); ?></td>
                                    <td><strong><?php echo e($product->created_at->translatedFormat('M d, Y')); ?></strong></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center"><?php echo e(__('No products!')); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="ps-card__footer">
                <a class="ps-card__morelink" href="<?php echo e(route('marketplace.vendor.products.index')); ?>">
                    <?php echo e(__('View Full Products')); ?><i class="icon icon-chevron-right"></i>
                </a>
            </div>
        </div>
    <?php endif; ?>
</div>
<div class="ps-section__right">
    <section class="ps-card ps-card--statics">
        <div class="ps-card__header d-block">
            <h4><?php echo e(__('Statistics')); ?></h4>
            <div class="text-primary">
                <small><?php echo e(__('Statistics in :label', ['label' => $data['predefinedRange']])); ?></small>
            </div>
        </div>
        <div class="ps-card__content">
            <div class="ps-block--stat yellow">
                <div class="ps-block__left"><span><i class="icon-bag2"></i></span></div>
                <div class="ps-block__content">
                    <p><?php echo e(__('Orders')); ?></p>
                    <h4><?php echo e($data['orders']->count()); ?></h4>
                </div>
            </div>
            <div class="ps-block--stat pink">
                <div class="ps-block__left"><span><i class="icon-bag-dollar"></i></span></div>
                <div class="ps-block__content">
                    <p><?php echo e(__('Revenue')); ?></p>
                    <h4><?php echo e(format_price($data['revenue']['amount'])); ?></h4>
                </div>
            </div>
            <div class="ps-block--stat green">
                <div class="ps-block__left"><span><i class="icon-database"></i></span></div>
                <div class="ps-block__content">
                    <p><?php echo e(__('Products')); ?></p>
                    <h4><?php echo e($data['products']->count()); ?></h4>
                </div>
            </div>
        </div>
    </section>
</div>
<?php /**PATH /home/elitedesign/ecommerce12.elitedesign.com.bd/platform/themes/martfury/views/marketplace/dashboard/partials/dashboard-content.blade.php ENDPATH**/ ?>