<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-3 right-sidebar">
        <div class="widget meta-boxes">
            <div class="widget-title">
                <h4><label for="status" class="control-label" aria-required="true"><?php echo e(trans('plugins/marketplace::store.information')); ?></label></h4>
            </div>
            <div class="widget-body">
                <div class="form-group mb-3">
                    <div class="border-bottom py-2">
                        <div class="text-center">
                            <div class="text-center">
                                <img src="<?php echo e(RvMedia::getImageUrl($vendor->store->logo, 'thumb', false, RvMedia::getDefaultImage())); ?>" width="120" class="mb-2" style="border-radius: 50%" alt="avatar" />
                            </div>
                            <?php if($vendor->store->id): ?>
                                <div class="text-center">
                                    <strong>
                                        <a href="<?php echo e(route('marketplace.store.edit', $vendor->store->id)); ?>" target="_blank"><?php echo e($vendor->store->name); ?> <i class="fas fa-external-link-alt"></i></a>
                                    </strong>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="py-2">
                        <span><?php echo e(trans('plugins/marketplace::store.store_phone')); ?>:</span>
                        <strong><?php echo e($vendor->store->phone ?: 'N/A'); ?></strong>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-9">
        <div class="note note-warning">
            <p><?php echo BaseHelper::clean(trans('plugins/marketplace::unverified-vendor.vendor_approval_notification', [
            'approve_link' => Html::link(route('marketplace.unverified-vendors.approve-vendor', $vendor->id), trans('plugins/marketplace::store.approve_here'), ['class' => 'approve-vendor-for-selling-button']),
        ])); ?></p>
        </div>

        <div class="widget meta-boxes">
            <div class="widget-title">
                <h4><label for="status" class="control-label" aria-required="true"><?php echo e(trans('plugins/marketplace::store.vendor_information')); ?></label></h4>
            </div>
            <div class="widget-body">
                <div class="py-2">
                    <span><?php echo e(trans('plugins/marketplace::store.vendor_name')); ?>:</span>
                    <strong><a href="<?php echo e(route('customers.edit', $vendor->id)); ?>" target="_blank"><?php echo e($vendor->name); ?> <i class="fas fa-external-link-alt"></i></a></strong>
                </div>
                <div class="py-2">
                    <span><?php echo e(trans('plugins/marketplace::unverified-vendor.forms.email')); ?>:</span>
                    <strong><?php echo e($vendor->email); ?></strong>
                </div>
                <div class="py-2">
                    <span><?php echo e(trans('plugins/marketplace::unverified-vendor.forms.vendor_phone')); ?>:</span>
                    <strong><?php echo e($vendor->phone ?: 'N/A'); ?></strong>
                </div>
                <div class="py-2">
                    <span><?php echo e(trans('plugins/marketplace::unverified-vendor.forms.registered_at')); ?>:</span>
                    <strong><?php echo e($vendor->created_at); ?></strong>
                </div>
            </div>
        </div>
    </div>

    <?php echo Form::modalAction('approve-vendor-for-selling-modal', trans('plugins/marketplace::unverified-vendor.approve_vendor_confirmation'), 'warning', trans('plugins/marketplace::unverified-vendor.approve_vendor_confirmation_description', ['vendor' => $vendor->name]), 'confirm-approve-vendor-for-selling-button', trans('plugins/marketplace::unverified-vendor.approve')); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(BaseHelper::getAdminMasterLayoutTemplate(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesign/ecommerce12.elitedesign.com.bd/platform/plugins/marketplace/resources/views/customers/verify-vendor.blade.php ENDPATH**/ ?>