<div class="ps-page--single ps-page--vendor">
    <section class="ps-store-list">
        <div class="container">
            <div class="ps-section__header">
                <h3><?php echo e(__('Our Stores')); ?></h3>
            </div>
            <div class="ps-section__content">
                <div class="ps-section__search row">
                    <div class="col-md-4">
                        <form action="<?php echo e(route('public.stores')); ?>" method="get">
                            <div class="form-group mb-3">
                                <button><i class="icon-magnifier"></i></button>
                                <input class="form-control" name="q" value="<?php echo e(BaseHelper::stringify(request()->query('q'))); ?>" type="text" placeholder="<?php echo e(__('Search vendor...')); ?>">
                            </div>
                        </form>
                    </div>
                </div>
                <div class="row">
                    <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12 ">
                            <article class="ps-block--store-2">
                                <div class="ps-block__content bg--cover" data-background="<?php echo e(asset('vendor/core/plugins/marketplace/img/default-store-banner.png')); ?>">
                                    <figure>
                                        <h4><?php echo e($store->name); ?></h4>
                                        <?php if(EcommerceHelper::isReviewEnabled()): ?>
                                            <div class="rating_wrap">
                                                <div class="rating">
                                                    <div class="product_rate" style="width: <?php echo e($store->reviews->avg('star') * 20); ?>%"></div>
                                                </div>
                                                <span class="rating_num">(<?php echo e($store->reviews->count()); ?>)</span>
                                            </div>
                                        <?php endif; ?>
                                        <p><?php echo e($store->full_address); ?></p>
                                        <?php if(!MarketplaceHelper::hideStorePhoneNumber() && $store->phone): ?>
                                            <p><i class="icon-telephone"></i> <?php echo e($store->phone); ?></p>
                                        <?php endif; ?>
                                        <?php if(!MarketplaceHelper::hideStoreEmail() && $store->email): ?>
                                            <p><i class="icon-envelope"></i> <a href="mailto:<?php echo e($store->email); ?>"><?php echo e($store->email); ?></a></p>
                                        <?php endif; ?>
                                    </figure>
                                </div>
                                <div class="ps-block__author">
                                    <a class="ps-block__user" href="<?php echo e($store->url); ?>">
                                        <img src="<?php echo e(RvMedia::getImageUrl($store->logo, 'small', false, RvMedia::getDefaultImage())); ?>" alt="<?php echo e($store->name); ?>">
                                    </a>
                                    <a class="ps-btn" href="<?php echo e($store->url); ?>"><?php echo e(__('Visit Store')); ?></a>
                                </div>
                            </article>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <div class="ps-pagination">
                        <?php echo $stores->withQueryString()->links(); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php /**PATH /home/elitedesigncom/ecommerce2.elitedesign.com.bd/platform/themes/martfury/views/marketplace/stores.blade.php ENDPATH**/ ?>