<header class="header--mobile">
    <div class="header__left">
        <button class="ps-drawer-toggle"><i class="icon-menu"></i></button>
    </div>
    <div class="header__center">
        <a class="ps-logo" href="<?php echo e(route('marketplace.vendor.dashboard')); ?>">
            <?php $logo = theme_option('logo_vendor_dashboard', theme_option('logo')); ?>
            <?php if($logo): ?>
                <img src="<?php echo e(RvMedia::getImageUrl($logo)); ?>" alt="<?php echo e(theme_option('site_title')); ?>">
            <?php endif; ?>
        </a>
    </div>
    <div class="header__right"><a class="header__site-link" href="<?php echo e(route('customer.logout')); ?>"><i class="icon-exit-right"></i></a></div>
</header>
<aside class="ps-drawer--mobile">
    <div class="ps-drawer__header">
        <h4>Menu</h4>
        <button class="ps-drawer__close"><i class="icon-cross"></i></button>
    </div>
    <div class="ps-drawer__content">
        <?php echo $__env->make(MarketplaceHelper::viewPath('dashboard.layouts.menu'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</aside>
<div class="ps-site-overlay"></div>
<main class="ps-main">
    <div class="ps-main__sidebar">
        <div class="ps-sidebar">
            <div class="ps-sidebar__top">
                <div class="ps-block--user-wellcome">
                    <div class="ps-block__left">
                        <img src="<?php echo e(auth('customer')->user()->store->logo_url); ?>" alt="<?php echo e(auth('customer')->user()->store->name); ?>" width="80" />
                    </div>
                    <div class="ps-block__right">
                        <p><?php echo e(__('Hello')); ?>, <?php echo e(auth('customer')->user()->name); ?></p>
                        <small><?php echo e(__('Joined on :date', ['date' => auth('customer')->user()->created_at->translatedFormat('M d, Y')])); ?></small>
                    </div>
                    <div class="ps-block__action"><a href="<?php echo e(route('customer.logout')); ?>"><i class="icon-exit"></i></a></div>
                </div>
                <div class="ps-block--earning-count"><small><?php echo e(__('Earnings')); ?></small>
                    <h3><?php echo e(format_price(auth('customer')->user()->balance)); ?></h3>
                </div>
            </div>
            <div class="ps-sidebar__content">
                <div class="ps-sidebar__center">
                    <?php echo $__env->make(MarketplaceHelper::viewPath('dashboard.layouts.menu'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="ps-sidebar__footer">
                    <div class="ps-copyright">
                        <?php $logo = theme_option('logo_vendor_dashboard', theme_option('logo')); ?>
                        <?php if($logo): ?>
                            <img src="<?php echo e(RvMedia::getImageUrl($logo)); ?>" alt="<?php echo e(theme_option('site_title')); ?>" height="40">
                        <?php endif; ?>
                        <p><?php echo e(theme_option('copyright')); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="ps-main__wrapper" id="vendor-dashboard">
        <header class="header--dashboard">
            <div class="header__left">
                <h3><?php echo e(page_title()->getTitle(false)); ?></h3>
            </div>
            <?php if(auth('customer')->user()->store && auth('customer')->user()->store->id): ?>
                <div class="header__right">
                    <?php if(is_plugin_active('language')): ?>
                        <div class="me-4">
                            <?php echo $__env->make(MarketplaceHelper::viewPath('dashboard.partials.language-switcher'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    <?php endif; ?>
                    <a class="header__site-link ms-2" href="<?php echo e(auth('customer')->user()->store->url); ?>" target="_blank"><span><?php echo e(__('View your store')); ?></span><i class="icon-exit-right"></i></a>
                </div>
            <?php endif; ?>
        </header>

        <div id="main">
            <div id="app">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
    </div>
</main>
<?php /**PATH /home/elitede1/ecommerce12.elitedesign.com.bd/platform/themes/martfury/views/marketplace/dashboard/layouts/body.blade.php ENDPATH**/ ?>