/* A polyfill for browsers that don't support ligatures. */
/* The script tag referring to this file must be placed before the ending body tag. */

/* To provide support for elements dynamically added, this script adds
   method 'icomoonLiga' to the window object. You can pass element references to this method.
*/
(function () {
	'use strict';
	function supportsProperty(p) {
		var prefixes = ['Webkit', 'Moz', 'O', 'ms'],
			i,
			div = document.createElement('div'),
			ret = p in div.style;
		if (!ret) {
			p = p.charAt(0).toUpperCase() + p.substr(1);
			for (i = 0; i < prefixes.length; i += 1) {
				ret = prefixes[i] + p in div.style;
				if (ret) {
					break;
				}
			}
		}
		return ret;
	}
	var icons;
	if (!supportsProperty('fontFeatureSettings')) {
		icons = {
			'home': '&#xe600;',
			'building': '&#xe600;',
			'home2': '&#xe601;',
			'building2': '&#xe601;',
			'home3': '&#xe602;',
			'building3': '&#xe602;',
			'home4': '&#xe603;',
			'building4': '&#xe603;',
			'home5': '&#xe604;',
			'building5': '&#xe604;',
			'home6': '&#xe605;',
			'building6': '&#xe605;',
			'bathtub': '&#xe606;',
			'shower': '&#xe606;',
			'toothbrush': '&#xe607;',
			'hygiene': '&#xe607;',
			'bed': '&#xe608;',
			'hotel': '&#xe608;',
			'couch': '&#xe609;',
			'furniture': '&#xe609;',
			'chair': '&#xe60a;',
			'furniture2': '&#xe60a;',
			'city': '&#xe60b;',
			'building7': '&#xe60b;',
			'apartment': '&#xe60c;',
			'building8': '&#xe60c;',
			'pencil': '&#xe60d;',
			'write': '&#xe60d;',
			'pencil2': '&#xe60e;',
			'write2': '&#xe60e;',
			'pen': '&#xe60f;',
			'write3': '&#xe60f;',
			'pencil3': '&#xe610;',
			'write4': '&#xe610;',
			'eraser': '&#xe611;',
			'rubber': '&#xe611;',
			'pencil4': '&#xe612;',
			'write5': '&#xe612;',
			'pencil5': '&#xe613;',
			'write6': '&#xe613;',
			'feather': '&#xe614;',
			'write7': '&#xe614;',
			'feather2': '&#xe615;',
			'write8': '&#xe615;',
			'feather3': '&#xe616;',
			'write9': '&#xe616;',
			'pen2': '&#xe617;',
			'write10': '&#xe617;',
			'pen-add': '&#xe618;',
			'pen-remove': '&#xe619;',
			'vector': '&#xe61a;',
			'bezier': '&#xe61a;',
			'pen3': '&#xe61b;',
			'write11': '&#xe61b;',
			'blog': '&#xe61c;',
			'write12': '&#xe61c;',
			'brush': '&#xe61d;',
			'paint': '&#xe61d;',
			'brush2': '&#xe61e;',
			'paint2': '&#xe61e;',
			'spray': '&#xe61f;',
			'paint3': '&#xe61f;',
			'paint-roller': '&#xe620;',
			'paint4': '&#xe620;',
			'stamp': '&#xe621;',
			'rubber-stamp': '&#xe621;',
			'tape': '&#xe622;',
			'adhesive': '&#xe622;',
			'desk-tape': '&#xe623;',
			'adhesive2': '&#xe623;',
			'texture': '&#xe624;',
			'design': '&#xe624;',
			'eye-dropper': '&#xe625;',
			'color-picker': '&#xe625;',
			'palette': '&#xe626;',
			'design2': '&#xe626;',
			'color-sampler': '&#xe627;',
			'design3': '&#xe627;',
			'bucket': '&#xe628;',
			'paint5': '&#xe628;',
			'gradient': '&#xe629;',
			'gradient2': '&#xe62a;',
			'magic-wand': '&#xe62b;',
			'tool': '&#xe62b;',
			'magnet': '&#xe62c;',
			'attract': '&#xe62c;',
			'pencil-ruler': '&#xe62d;',
			'design4': '&#xe62d;',
			'pencil-ruler2': '&#xe62e;',
			'design5': '&#xe62e;',
			'compass': '&#xe62f;',
			'tool2': '&#xe62f;',
			'aim': '&#xe630;',
			'target': '&#xe630;',
			'gun': '&#xe631;',
			'weapon': '&#xe631;',
			'bottle': '&#xe632;',
			'water': '&#xe632;',
			'drop': '&#xe633;',
			'droplet': '&#xe633;',
			'drop-crossed': '&#xe634;',
			'droplet2': '&#xe634;',
			'drop2': '&#xe635;',
			'droplet3': '&#xe635;',
			'snow': '&#xe636;',
			'winter': '&#xe636;',
			'snow2': '&#xe637;',
			'winter2': '&#xe637;',
			'fire': '&#xe638;',
			'flame': '&#xe638;',
			'lighter': '&#xe639;',
			'fire2': '&#xe639;',
			'knife': '&#xe63a;',
			'tool3': '&#xe63a;',
			'dagger': '&#xe63b;',
			'weapon2': '&#xe63b;',
			'tissue': '&#xe63c;',
			'napkin': '&#xe63c;',
			'toilet-paper': '&#xe63d;',
			'toilet': '&#xe63d;',
			'poop': '&#xe63e;',
			'toilet2': '&#xe63e;',
			'umbrella': '&#xe63f;',
			'rain': '&#xe63f;',
			'umbrella2': '&#xe640;',
			'rain2': '&#xe640;',
			'rain3': '&#xe641;',
			'weather': '&#xe641;',
			'tornado': '&#xe642;',
			'weather2': '&#xe642;',
			'wind': '&#xe643;',
			'weather3': '&#xe643;',
			'fan': '&#xe644;',
			'cooling': '&#xe644;',
			'contrast': '&#xe645;',
			'sun-small': '&#xe646;',
			'brightness': '&#xe646;',
			'sun': '&#xe647;',
			'brightness2': '&#xe647;',
			'sun2': '&#xe648;',
			'brightness-auto': '&#xe648;',
			'moon': '&#xe649;',
			'night': '&#xe649;',
			'cloud': '&#xe64a;',
			'weather4': '&#xe64a;',
			'cloud-upload': '&#xe64b;',
			'cloud2': '&#xe64b;',
			'cloud-download': '&#xe64c;',
			'cloud3': '&#xe64c;',
			'cloud-rain': '&#xe64d;',
			'weather5': '&#xe64d;',
			'cloud-hailstones': '&#xe64e;',
			'weather6': '&#xe64e;',
			'cloud-snow': '&#xe64f;',
			'weather7': '&#xe64f;',
			'cloud-windy': '&#xe650;',
			'weather8': '&#xe650;',
			'sun-wind': '&#xe651;',
			'weather9': '&#xe651;',
			'cloud-fog': '&#xe652;',
			'weather10': '&#xe652;',
			'cloud-sun': '&#xe653;',
			'weather11': '&#xe653;',
			'cloud-lightning': '&#xe654;',
			'weather12': '&#xe654;',
			'cloud-sync': '&#xe655;',
			'cloud4': '&#xe655;',
			'cloud-lock': '&#xe656;',
			'cloud5': '&#xe656;',
			'cloud-gear': '&#xe657;',
			'cloud6': '&#xe657;',
			'cloud-alert': '&#xe658;',
			'cloud7': '&#xe658;',
			'cloud-check': '&#xe659;',
			'cloud8': '&#xe659;',
			'cloud-cross': '&#xe65a;',
			'cloud9': '&#xe65a;',
			'cloud-crossed': '&#xe65b;',
			'cloud10': '&#xe65b;',
			'cloud-database': '&#xe65c;',
			'cloud11': '&#xe65c;',
			'database': '&#xe65d;',
			'storage': '&#xe65d;',
			'database-add': '&#xe65e;',
			'database2': '&#xe65e;',
			'database-remove': '&#xe65f;',
			'database3': '&#xe65f;',
			'database-lock': '&#xe660;',
			'database4': '&#xe660;',
			'database-refresh': '&#xe661;',
			'database5': '&#xe661;',
			'database-check': '&#xe662;',
			'database6': '&#xe662;',
			'database-history': '&#xe663;',
			'database7': '&#xe663;',
			'database-upload': '&#xe664;',
			'database8': '&#xe664;',
			'database-download': '&#xe665;',
			'database9': '&#xe665;',
			'server': '&#xe666;',
			'hosting': '&#xe666;',
			'shield': '&#xe667;',
			'security': '&#xe667;',
			'shield-check': '&#xe668;',
			'shield2': '&#xe668;',
			'shield-alert': '&#xe669;',
			'shield3': '&#xe669;',
			'shield-cross': '&#xe66a;',
			'shield4': '&#xe66a;',
			'lock': '&#xe66b;',
			'privacy': '&#xe66b;',
			'rotation-lock': '&#xe66c;',
			'screen-lock': '&#xe66c;',
			'unlock': '&#xe66d;',
			'lock2': '&#xe66d;',
			'key': '&#xe66e;',
			'unlock2': '&#xe66e;',
			'key-hole': '&#xe66f;',
			'lock3': '&#xe66f;',
			'toggle-off': '&#xe670;',
			'toggle': '&#xe670;',
			'toggle-on': '&#xe671;',
			'toggle2': '&#xe671;',
			'cog': '&#xe672;',
			'gear': '&#xe672;',
			'cog2': '&#xe673;',
			'gear2': '&#xe673;',
			'wrench': '&#xe674;',
			'tool4': '&#xe674;',
			'screwdriver': '&#xe675;',
			'tool5': '&#xe675;',
			'hammer-wrench': '&#xe676;',
			'tool6': '&#xe676;',
			'hammer': '&#xe677;',
			'tool7': '&#xe677;',
			'saw': '&#xe678;',
			'tool8': '&#xe678;',
			'axe': '&#xe679;',
			'tool9': '&#xe679;',
			'axe2': '&#xe67a;',
			'tool10': '&#xe67a;',
			'shovel': '&#xe67b;',
			'tool11': '&#xe67b;',
			'pickaxe': '&#xe67c;',
			'tool12': '&#xe67c;',
			'factory': '&#xe67d;',
			'build': '&#xe67d;',
			'factory2': '&#xe67e;',
			'build2': '&#xe67e;',
			'recycle': '&#xe67f;',
			'trash': '&#xe680;',
			'bin': '&#xe680;',
			'trash2': '&#xe681;',
			'bin2': '&#xe681;',
			'trash3': '&#xe682;',
			'bin3': '&#xe682;',
			'broom': '&#xe683;',
			'sweep': '&#xe683;',
			'game': '&#xe684;',
			'retro': '&#xe684;',
			'gamepad': '&#xe685;',
			'game2': '&#xe685;',
			'joystick': '&#xe686;',
			'game3': '&#xe686;',
			'dice': '&#xe687;',
			'game4': '&#xe687;',
			'spades': '&#xe688;',
			'cards': '&#xe688;',
			'diamonds': '&#xe689;',
			'cards2': '&#xe689;',
			'clubs': '&#xe68a;',
			'cards3': '&#xe68a;',
			'hearts': '&#xe68b;',
			'cards4': '&#xe68b;',
			'heart': '&#xe68c;',
			'love': '&#xe68c;',
			'star': '&#xe68d;',
			'rating': '&#xe68d;',
			'star-half': '&#xe68e;',
			'rating2': '&#xe68e;',
			'star-empty': '&#xe68f;',
			'rating3': '&#xe68f;',
			'flag': '&#xe690;',
			'report': '&#xe690;',
			'flag2': '&#xe691;',
			'report2': '&#xe691;',
			'flag3': '&#xe692;',
			'report3': '&#xe692;',
			'mailbox-full': '&#xe693;',
			'mailbox': '&#xe693;',
			'mailbox-empty': '&#xe694;',
			'mailbox2': '&#xe694;',
			'at-sign': '&#xe695;',
			'mail': '&#xe695;',
			'envelope': '&#xe696;',
			'mail2': '&#xe696;',
			'envelope-open': '&#xe697;',
			'mail3': '&#xe697;',
			'paperclip': '&#xe698;',
			'attachment': '&#xe698;',
			'paper-plane': '&#xe699;',
			'mail4': '&#xe699;',
			'reply': '&#xe69a;',
			'left': '&#xe69a;',
			'reply-all': '&#xe69b;',
			'left2': '&#xe69b;',
			'inbox': '&#xe69c;',
			'drawer': '&#xe69c;',
			'inbox2': '&#xe69d;',
			'drawer2': '&#xe69d;',
			'outbox': '&#xe69e;',
			'drawer3': '&#xe69e;',
			'box': '&#xe69f;',
			'storage2': '&#xe69f;',
			'archive': '&#xe6a0;',
			'drawer4': '&#xe6a0;',
			'archive2': '&#xe6a1;',
			'drawer5': '&#xe6a1;',
			'drawers': '&#xe6a2;',
			'drawer6': '&#xe6a2;',
			'drawers2': '&#xe6a3;',
			'drawer7': '&#xe6a3;',
			'drawers3': '&#xe6a4;',
			'drawer8': '&#xe6a4;',
			'eye': '&#xe6a5;',
			'vision': '&#xe6a5;',
			'eye-crossed': '&#xe6a6;',
			'eye2': '&#xe6a6;',
			'eye-plus': '&#xe6a7;',
			'eye3': '&#xe6a7;',
			'eye-minus': '&#xe6a8;',
			'eye4': '&#xe6a8;',
			'binoculars': '&#xe6a9;',
			'lookup': '&#xe6a9;',
			'binoculars2': '&#xe6aa;',
			'lookup2': '&#xe6aa;',
			'hdd': '&#xe6ab;',
			'storage3': '&#xe6ab;',
			'hdd-down': '&#xe6ac;',
			'hdd2': '&#xe6ac;',
			'hdd-up': '&#xe6ad;',
			'hdd3': '&#xe6ad;',
			'floppy-disk': '&#xe6ae;',
			'storage4': '&#xe6ae;',
			'disc': '&#xe6af;',
			'storage5': '&#xe6af;',
			'tape2': '&#xe6b0;',
			'storage6': '&#xe6b0;',
			'printer': '&#xe6b1;',
			'print': '&#xe6b1;',
			'shredder': '&#xe6b2;',
			'remove': '&#xe6b2;',
			'file-empty': '&#xe6b3;',
			'file': '&#xe6b3;',
			'file-add': '&#xe6b4;',
			'file2': '&#xe6b4;',
			'file-check': '&#xe6b5;',
			'file3': '&#xe6b5;',
			'file-lock': '&#xe6b6;',
			'file4': '&#xe6b6;',
			'files': '&#xe6b7;',
			'stack': '&#xe6b7;',
			'copy': '&#xe6b8;',
			'files2': '&#xe6b8;',
			'compare': '&#xe6b9;',
			'diff': '&#xe6b9;',
			'folder': '&#xe6ba;',
			'directory': '&#xe6ba;',
			'folder-search': '&#xe6bb;',
			'folder2': '&#xe6bb;',
			'folder-plus': '&#xe6bc;',
			'folder3': '&#xe6bc;',
			'folder-minus': '&#xe6bd;',
			'folder4': '&#xe6bd;',
			'folder-download': '&#xe6be;',
			'folder5': '&#xe6be;',
			'folder-upload': '&#xe6bf;',
			'folder6': '&#xe6bf;',
			'folder-star': '&#xe6c0;',
			'folder7': '&#xe6c0;',
			'folder-heart': '&#xe6c1;',
			'folder8': '&#xe6c1;',
			'folder-user': '&#xe6c2;',
			'folder9': '&#xe6c2;',
			'folder-shared': '&#xe6c3;',
			'folder10': '&#xe6c3;',
			'folder-music': '&#xe6c4;',
			'folder11': '&#xe6c4;',
			'folder-picture': '&#xe6c5;',
			'folder12': '&#xe6c5;',
			'folder-film': '&#xe6c6;',
			'folder13': '&#xe6c6;',
			'scissors': '&#xe6c7;',
			'tool13': '&#xe6c7;',
			'paste': '&#xe6c8;',
			'clipboard': '&#xe6c8;',
			'clipboard-empty': '&#xe6c9;',
			'clipboard2': '&#xe6c9;',
			'clipboard-pencil': '&#xe6ca;',
			'clipboard3': '&#xe6ca;',
			'clipboard-text': '&#xe6cb;',
			'clipboard4': '&#xe6cb;',
			'clipboard-check': '&#xe6cc;',
			'clipboard5': '&#xe6cc;',
			'clipboard-down': '&#xe6cd;',
			'clipboard6': '&#xe6cd;',
			'clipboard-left': '&#xe6ce;',
			'clipboard7': '&#xe6ce;',
			'clipboard-alert': '&#xe6cf;',
			'clipboard8': '&#xe6cf;',
			'clipboard-user': '&#xe6d0;',
			'clipboard9': '&#xe6d0;',
			'register': '&#xe6d1;',
			'signature': '&#xe6d1;',
			'enter': '&#xe6d2;',
			'door': '&#xe6d2;',
			'exit': '&#xe6d3;',
			'door2': '&#xe6d3;',
			'papers': '&#xe6d4;',
			'stack2': '&#xe6d4;',
			'news': '&#xe6d5;',
			'newspaper': '&#xe6d5;',
			'reading': '&#xe6d6;',
			'library': '&#xe6d6;',
			'typewriter': '&#xe6d7;',
			'typing': '&#xe6d7;',
			'document': '&#xe6d8;',
			'file5': '&#xe6d8;',
			'document2': '&#xe6d9;',
			'file6': '&#xe6d9;',
			'graduation-hat': '&#xe6da;',
			'education': '&#xe6da;',
			'license': '&#xe6db;',
			'certificate': '&#xe6db;',
			'license2': '&#xe6dc;',
			'certificate2': '&#xe6dc;',
			'medal-empty': '&#xe6dd;',
			'medal': '&#xe6dd;',
			'medal-first': '&#xe6de;',
			'medal2': '&#xe6de;',
			'medal-second': '&#xe6df;',
			'medal3': '&#xe6df;',
			'medal-third': '&#xe6e0;',
			'medal4': '&#xe6e0;',
			'podium': '&#xe6e1;',
			'standings': '&#xe6e1;',
			'trophy': '&#xe6e2;',
			'cup': '&#xe6e2;',
			'trophy2': '&#xe6e3;',
			'cup2': '&#xe6e3;',
			'music-note': '&#xe6e4;',
			'music': '&#xe6e4;',
			'music-note2': '&#xe6e5;',
			'music2': '&#xe6e5;',
			'music-note3': '&#xe6e6;',
			'music3': '&#xe6e6;',
			'playlist': '&#xe6e7;',
			'playlist-add': '&#xe6e8;',
			'guitar': '&#xe6e9;',
			'music4': '&#xe6e9;',
			'trumpet': '&#xe6ea;',
			'music5': '&#xe6ea;',
			'album': '&#xe6eb;',
			'music6': '&#xe6eb;',
			'shuffle': '&#xe6ec;',
			'randomize': '&#xe6ec;',
			'repeat-one': '&#xe6ed;',
			'loop': '&#xe6ed;',
			'repeat': '&#xe6ee;',
			'loop2': '&#xe6ee;',
			'headphones': '&#xe6ef;',
			'music7': '&#xe6ef;',
			'headset': '&#xe6f0;',
			'headphones2': '&#xe6f0;',
			'loudspeaker': '&#xe6f1;',
			'music8': '&#xe6f1;',
			'equalizer': '&#xe6f2;',
			'settings': '&#xe6f2;',
			'theater': '&#xe6f3;',
			'drama': '&#xe6f3;',
			'3d-glasses': '&#xe6f4;',
			'glasses': '&#xe6f4;',
			'ticket': '&#xe6f5;',
			'theater2': '&#xe6f5;',
			'presentation': '&#xe6f6;',
			'board': '&#xe6f6;',
			'play': '&#xe6f7;',
			'video': '&#xe6f7;',
			'film-play': '&#xe6f8;',
			'video2': '&#xe6f8;',
			'clapboard-play': '&#xe6f9;',
			'video3': '&#xe6f9;',
			'media': '&#xe6fa;',
			'film-picture-music': '&#xe6fa;',
			'film': '&#xe6fb;',
			'video4': '&#xe6fb;',
			'film2': '&#xe6fc;',
			'photo': '&#xe6fc;',
			'surveillance': '&#xe6fd;',
			'security-camera': '&#xe6fd;',
			'surveillance2': '&#xe6fe;',
			'security-camera2': '&#xe6fe;',
			'camera': '&#xe6ff;',
			'video5': '&#xe6ff;',
			'camera-crossed': '&#xe700;',
			'video6': '&#xe700;',
			'camera-play': '&#xe701;',
			'video7': '&#xe701;',
			'time-lapse': '&#xe702;',
			'video8': '&#xe702;',
			'record': '&#xe703;',
			'video9': '&#xe703;',
			'camera2': '&#xe704;',
			'photo2': '&#xe704;',
			'camera-flip': '&#xe705;',
			'panorama': '&#xe706;',
			'photo3': '&#xe706;',
			'time-lapse2': '&#xe707;',
			'photo4': '&#xe707;',
			'shutter': '&#xe708;',
			'camera3': '&#xe708;',
			'shutter2': '&#xe709;',
			'face-detection': '&#xe70a;',
			'flare': '&#xe70b;',
			'convex': '&#xe70c;',
			'concave': '&#xe70d;',
			'picture': '&#xe70e;',
			'photo5': '&#xe70e;',
			'picture2': '&#xe70f;',
			'photo6': '&#xe70f;',
			'picture3': '&#xe710;',
			'photo7': '&#xe710;',
			'pictures': '&#xe711;',
			'photo8': '&#xe711;',
			'book': '&#xe712;',
			'read': '&#xe712;',
			'audio-book': '&#xe713;',
			'book2': '&#xe713;',
			'book3': '&#xe714;',
			'read2': '&#xe714;',
			'bookmark': '&#xe715;',
			'book4': '&#xe715;',
			'bookmark2': '&#xe716;',
			'ribbon': '&#xe716;',
			'label': '&#xe717;',
			'library2': '&#xe718;',
			'book5': '&#xe718;',
			'library3': '&#xe719;',
			'building9': '&#xe719;',
			'contacts': '&#xe71a;',
			'book6': '&#xe71a;',
			'profile': '&#xe71b;',
			'card': '&#xe71b;',
			'portrait': '&#xe71c;',
			'photo9': '&#xe71c;',
			'portrait2': '&#xe71d;',
			'photo10': '&#xe71d;',
			'user': '&#xe71e;',
			'persona': '&#xe71e;',
			'user-plus': '&#xe71f;',
			'user2': '&#xe71f;',
			'user-minus': '&#xe720;',
			'user3': '&#xe720;',
			'user-lock': '&#xe721;',
			'user4': '&#xe721;',
			'users': '&#xe722;',
			'group': '&#xe722;',
			'users2': '&#xe723;',
			'group2': '&#xe723;',
			'users-plus': '&#xe724;',
			'group3': '&#xe724;',
			'users-minus': '&#xe725;',
			'group4': '&#xe725;',
			'group-work': '&#xe726;',
			'group5': '&#xe726;',
			'woman': '&#xe727;',
			'female': '&#xe727;',
			'man': '&#xe728;',
			'male': '&#xe728;',
			'baby': '&#xe729;',
			'girl': '&#xe729;',
			'baby2': '&#xe72a;',
			'boy': '&#xe72a;',
			'baby3': '&#xe72b;',
			'newborn': '&#xe72b;',
			'baby-bottle': '&#xe72c;',
			'baby4': '&#xe72c;',
			'walk': '&#xe72d;',
			'human': '&#xe72d;',
			'hand-waving': '&#xe72e;',
			'human2': '&#xe72e;',
			'jump': '&#xe72f;',
			'human3': '&#xe72f;',
			'run': '&#xe730;',
			'human4': '&#xe730;',
			'woman2': '&#xe731;',
			'female2': '&#xe731;',
			'man2': '&#xe732;',
			'male2': '&#xe732;',
			'man-woman': '&#xe733;',
			'gender': '&#xe733;',
			'height': '&#xe734;',
			'weight': '&#xe735;',
			'scale': '&#xe735;',
			'scale2': '&#xe736;',
			'button': '&#xe737;',
			'clothing': '&#xe737;',
			'bow-tie': '&#xe738;',
			'clothing2': '&#xe738;',
			'tie': '&#xe739;',
			'clothing3': '&#xe739;',
			'socks': '&#xe73a;',
			'clothing4': '&#xe73a;',
			'shoe': '&#xe73b;',
			'clothing5': '&#xe73b;',
			'shoes': '&#xe73c;',
			'clothing6': '&#xe73c;',
			'hat': '&#xe73d;',
			'clothing7': '&#xe73d;',
			'pants': '&#xe73e;',
			'clothing8': '&#xe73e;',
			'shorts': '&#xe73f;',
			'clothing9': '&#xe73f;',
			'flip-flops': '&#xe740;',
			'clothing10': '&#xe740;',
			'shirt': '&#xe741;',
			'clothing11': '&#xe741;',
			'hanger': '&#xe742;',
			'clothing12': '&#xe742;',
			'laundry': '&#xe743;',
			'washing-machine': '&#xe743;',
			'store': '&#xe744;',
			'shop': '&#xe744;',
			'haircut': '&#xe745;',
			'scissors-comb': '&#xe745;',
			'store-24': '&#xe746;',
			'shop2': '&#xe746;',
			'barcode': '&#xe747;',
			'price': '&#xe747;',
			'barcode2': '&#xe748;',
			'price2': '&#xe748;',
			'barcode3': '&#xe749;',
			'price3': '&#xe749;',
			'cashier': '&#xe74a;',
			'checkout': '&#xe74a;',
			'bag': '&#xe74b;',
			'shop3': '&#xe74b;',
			'bag2': '&#xe74c;',
			'shop4': '&#xe74c;',
			'cart': '&#xe74d;',
			'shop5': '&#xe74d;',
			'cart-empty': '&#xe74e;',
			'shop6': '&#xe74e;',
			'cart-full': '&#xe74f;',
			'shop7': '&#xe74f;',
			'cart-plus': '&#xe750;',
			'shop8': '&#xe750;',
			'cart-plus2': '&#xe751;',
			'shop9': '&#xe751;',
			'cart-add': '&#xe752;',
			'shop10': '&#xe752;',
			'cart-remove': '&#xe753;',
			'shop11': '&#xe753;',
			'cart-exchange': '&#xe754;',
			'shop12': '&#xe754;',
			'tag': '&#xe755;',
			'price4': '&#xe755;',
			'tags': '&#xe756;',
			'price5': '&#xe756;',
			'receipt': '&#xe757;',
			'price6': '&#xe757;',
			'wallet': '&#xe758;',
			'money': '&#xe758;',
			'credit-card': '&#xe759;',
			'money2': '&#xe759;',
			'cash-dollar': '&#xe75a;',
			'money3': '&#xe75a;',
			'cash-euro': '&#xe75b;',
			'money4': '&#xe75b;',
			'cash-pound': '&#xe75c;',
			'money5': '&#xe75c;',
			'cash-yen': '&#xe75d;',
			'money6': '&#xe75d;',
			'bag-dollar': '&#xe75e;',
			'money7': '&#xe75e;',
			'bag-euro': '&#xe75f;',
			'money8': '&#xe75f;',
			'bag-pound': '&#xe760;',
			'money9': '&#xe760;',
			'bag-yen': '&#xe761;',
			'money10': '&#xe761;',
			'coin-dollar': '&#xe762;',
			'money11': '&#xe762;',
			'coin-euro': '&#xe763;',
			'money12': '&#xe763;',
			'coin-pound': '&#xe764;',
			'money13': '&#xe764;',
			'coin-yen': '&#xe765;',
			'money14': '&#xe765;',
			'calculator': '&#xe766;',
			'arithmetic': '&#xe766;',
			'calculator2': '&#xe767;',
			'arithmetic2': '&#xe767;',
			'abacus': '&#xe768;',
			'arithmetic3': '&#xe768;',
			'vault': '&#xe769;',
			'safe': '&#xe769;',
			'telephone': '&#xe76a;',
			'phone': '&#xe76a;',
			'phone-lock': '&#xe76b;',
			'phone2': '&#xe76b;',
			'phone-wave': '&#xe76c;',
			'phone3': '&#xe76c;',
			'phone-pause': '&#xe76d;',
			'phone4': '&#xe76d;',
			'phone-outgoing': '&#xe76e;',
			'phone5': '&#xe76e;',
			'phone-incoming': '&#xe76f;',
			'phone6': '&#xe76f;',
			'phone-in-out': '&#xe770;',
			'phone7': '&#xe770;',
			'phone-error': '&#xe771;',
			'phone8': '&#xe771;',
			'phone-sip': '&#xe772;',
			'phone9': '&#xe772;',
			'phone-plus': '&#xe773;',
			'phone10': '&#xe773;',
			'phone-minus': '&#xe774;',
			'phone11': '&#xe774;',
			'voicemail': '&#xe775;',
			'message': '&#xe775;',
			'dial': '&#xe776;',
			'dial-pad': '&#xe776;',
			'telephone2': '&#xe777;',
			'phone12': '&#xe777;',
			'pushpin': '&#xe778;',
			'pin': '&#xe778;',
			'pushpin2': '&#xe779;',
			'pin2': '&#xe779;',
			'map-marker': '&#xe77a;',
			'pin3': '&#xe77a;',
			'map-marker-user': '&#xe77b;',
			'pin4': '&#xe77b;',
			'map-marker-down': '&#xe77c;',
			'pin5': '&#xe77c;',
			'map-marker-check': '&#xe77d;',
			'pin6': '&#xe77d;',
			'map-marker-crossed': '&#xe77e;',
			'pin7': '&#xe77e;',
			'radar': '&#xe77f;',
			'scanner': '&#xe77f;',
			'compass2': '&#xe780;',
			'guide': '&#xe780;',
			'map': '&#xe781;',
			'guide2': '&#xe781;',
			'map2': '&#xe782;',
			'guide3': '&#xe782;',
			'location': '&#xe783;',
			'compass3': '&#xe783;',
			'road-sign': '&#xe784;',
			'directions': '&#xe784;',
			'calendar-empty': '&#xe785;',
			'calendar': '&#xe785;',
			'calendar-check': '&#xe786;',
			'calendar2': '&#xe786;',
			'calendar-cross': '&#xe787;',
			'calendar3': '&#xe787;',
			'calendar-31': '&#xe788;',
			'calendar4': '&#xe788;',
			'calendar-full': '&#xe789;',
			'calendar5': '&#xe789;',
			'calendar-insert': '&#xe78a;',
			'calendar6': '&#xe78a;',
			'calendar-text': '&#xe78b;',
			'calendar7': '&#xe78b;',
			'calendar-user': '&#xe78c;',
			'calendar8': '&#xe78c;',
			'mouse': '&#xe78d;',
			'click': '&#xe78d;',
			'mouse-left': '&#xe78e;',
			'click2': '&#xe78e;',
			'mouse-right': '&#xe78f;',
			'click3': '&#xe78f;',
			'mouse-both': '&#xe790;',
			'click4': '&#xe790;',
			'keyboard': '&#xe791;',
			'type': '&#xe791;',
			'keyboard-up': '&#xe792;',
			'keyboard2': '&#xe792;',
			'keyboard-down': '&#xe793;',
			'keyboard3': '&#xe793;',
			'delete': '&#xe794;',
			'backspace': '&#xe794;',
			'spell-check': '&#xe795;',
			'spelling': '&#xe795;',
			'escape': '&#xe796;',
			'enter2': '&#xe797;',
			'screen': '&#xe798;',
			'monitor': '&#xe798;',
			'aspect-ratio': '&#xe799;',
			'screen2': '&#xe799;',
			'signal': '&#xe79a;',
			'bars': '&#xe79a;',
			'signal-lock': '&#xe79b;',
			'signal2': '&#xe79b;',
			'signal-80': '&#xe79c;',
			'signal3': '&#xe79c;',
			'signal-60': '&#xe79d;',
			'signal4': '&#xe79d;',
			'signal-40': '&#xe79e;',
			'signal5': '&#xe79e;',
			'signal-20': '&#xe79f;',
			'signal6': '&#xe79f;',
			'signal-0': '&#xe7a0;',
			'signal7': '&#xe7a0;',
			'signal-blocked': '&#xe7a1;',
			'signal8': '&#xe7a1;',
			'sim': '&#xe7a2;',
			'sim-card': '&#xe7a2;',
			'flash-memory': '&#xe7a3;',
			'usb-drive': '&#xe7a4;',
			'flash-memory2': '&#xe7a4;',
			'phone13': '&#xe7a5;',
			'mobile': '&#xe7a5;',
			'smartphone': '&#xe7a6;',
			'mobile2': '&#xe7a6;',
			'smartphone-notification': '&#xe7a7;',
			'mobile3': '&#xe7a7;',
			'smartphone-vibration': '&#xe7a8;',
			'mobile4': '&#xe7a8;',
			'smartphone-embed': '&#xe7a9;',
			'mobile5': '&#xe7a9;',
			'smartphone-waves': '&#xe7aa;',
			'mobile6': '&#xe7aa;',
			'tablet': '&#xe7ab;',
			'mobile7': '&#xe7ab;',
			'tablet2': '&#xe7ac;',
			'mobile8': '&#xe7ac;',
			'laptop': '&#xe7ad;',
			'computer': '&#xe7ad;',
			'laptop-phone': '&#xe7ae;',
			'devices': '&#xe7ae;',
			'desktop': '&#xe7af;',
			'computer2': '&#xe7af;',
			'launch': '&#xe7b0;',
			'share': '&#xe7b0;',
			'new-tab': '&#xe7b1;',
			'window-tab': '&#xe7b1;',
			'window': '&#xe7b2;',
			'program': '&#xe7b2;',
			'cable': '&#xe7b3;',
			'plug': '&#xe7b3;',
			'cable2': '&#xe7b4;',
			'plug2': '&#xe7b4;',
			'tv': '&#xe7b5;',
			'television': '&#xe7b5;',
			'radio': '&#xe7b6;',
			'music9': '&#xe7b6;',
			'remote-control': '&#xe7b7;',
			'power-switch': '&#xe7b8;',
			'toggle3': '&#xe7b8;',
			'power': '&#xe7b9;',
			'lightning': '&#xe7b9;',
			'power-crossed': '&#xe7ba;',
			'lightning2': '&#xe7ba;',
			'flash-auto': '&#xe7bb;',
			'lightning3': '&#xe7bb;',
			'lamp': '&#xe7bc;',
			'light': '&#xe7bc;',
			'flashlight': '&#xe7bd;',
			'light2': '&#xe7bd;',
			'lampshade': '&#xe7be;',
			'light3': '&#xe7be;',
			'cord': '&#xe7bf;',
			'plug3': '&#xe7bf;',
			'outlet': '&#xe7c0;',
			'socket': '&#xe7c0;',
			'battery-power': '&#xe7c1;',
			'battery': '&#xe7c1;',
			'battery-empty': '&#xe7c2;',
			'battery2': '&#xe7c2;',
			'battery-alert': '&#xe7c3;',
			'battery3': '&#xe7c3;',
			'battery-error': '&#xe7c4;',
			'battery4': '&#xe7c4;',
			'battery-low1': '&#xe7c5;',
			'battery5': '&#xe7c5;',
			'battery-low2': '&#xe7c6;',
			'battery6': '&#xe7c6;',
			'battery-low3': '&#xe7c7;',
			'battery7': '&#xe7c7;',
			'battery-mid1': '&#xe7c8;',
			'battery8': '&#xe7c8;',
			'battery-mid2': '&#xe7c9;',
			'battery9': '&#xe7c9;',
			'battery-mid3': '&#xe7ca;',
			'battery10': '&#xe7ca;',
			'battery-full': '&#xe7cb;',
			'battery11': '&#xe7cb;',
			'battery-charging': '&#xe7cc;',
			'battery12': '&#xe7cc;',
			'battery-charging2': '&#xe7cd;',
			'battery13': '&#xe7cd;',
			'battery-charging3': '&#xe7ce;',
			'battery14': '&#xe7ce;',
			'battery-charging4': '&#xe7cf;',
			'battery15': '&#xe7cf;',
			'battery-charging5': '&#xe7d0;',
			'battery16': '&#xe7d0;',
			'battery-charging6': '&#xe7d1;',
			'battery17': '&#xe7d1;',
			'battery-charging7': '&#xe7d2;',
			'battery18': '&#xe7d2;',
			'chip': '&#xe7d3;',
			'cpu': '&#xe7d3;',
			'chip-x64': '&#xe7d4;',
			'cpu2': '&#xe7d4;',
			'chip-x86': '&#xe7d5;',
			'cpu3': '&#xe7d5;',
			'bubble': '&#xe7d6;',
			'chat': '&#xe7d6;',
			'bubbles': '&#xe7d7;',
			'chat2': '&#xe7d7;',
			'bubble-dots': '&#xe7d8;',
			'chat3': '&#xe7d8;',
			'bubble-alert': '&#xe7d9;',
			'chat4': '&#xe7d9;',
			'bubble-question': '&#xe7da;',
			'chat5': '&#xe7da;',
			'bubble-text': '&#xe7db;',
			'chat6': '&#xe7db;',
			'bubble-pencil': '&#xe7dc;',
			'chat7': '&#xe7dc;',
			'bubble-picture': '&#xe7dd;',
			'chat8': '&#xe7dd;',
			'bubble-video': '&#xe7de;',
			'chat9': '&#xe7de;',
			'bubble-user': '&#xe7df;',
			'chat10': '&#xe7df;',
			'bubble-quote': '&#xe7e0;',
			'chat11': '&#xe7e0;',
			'bubble-heart': '&#xe7e1;',
			'chat12': '&#xe7e1;',
			'bubble-emoticon': '&#xe7e2;',
			'chat13': '&#xe7e2;',
			'bubble-attachment': '&#xe7e3;',
			'chat14': '&#xe7e3;',
			'phone-bubble': '&#xe7e4;',
			'phone14': '&#xe7e4;',
			'quote-open': '&#xe7e5;',
			'quote-close': '&#xe7e6;',
			'dna': '&#xe7e7;',
			'gene': '&#xe7e7;',
			'heart-pulse': '&#xe7e8;',
			'health': '&#xe7e8;',
			'pulse': '&#xe7e9;',
			'health2': '&#xe7e9;',
			'syringe': '&#xe7ea;',
			'health3': '&#xe7ea;',
			'pills': '&#xe7eb;',
			'health4': '&#xe7eb;',
			'first-aid': '&#xe7ec;',
			'health5': '&#xe7ec;',
			'lifebuoy': '&#xe7ed;',
			'help': '&#xe7ed;',
			'bandage': '&#xe7ee;',
			'health6': '&#xe7ee;',
			'bandages': '&#xe7ef;',
			'health7': '&#xe7ef;',
			'thermometer': '&#xe7f0;',
			'temperature': '&#xe7f0;',
			'microscope': '&#xe7f1;',
			'lab': '&#xe7f1;',
			'brain': '&#xe7f2;',
			'mind': '&#xe7f2;',
			'beaker': '&#xe7f3;',
			'lab2': '&#xe7f3;',
			'skull': '&#xe7f4;',
			'skeleton': '&#xe7f4;',
			'bone': '&#xe7f5;',
			'dog': '&#xe7f5;',
			'construction': '&#xe7f6;',
			'road-sign2': '&#xe7f6;',
			'construction-cone': '&#xe7f7;',
			'construction2': '&#xe7f7;',
			'pie-chart': '&#xe7f8;',
			'chart': '&#xe7f8;',
			'pie-chart2': '&#xe7f9;',
			'chart2': '&#xe7f9;',
			'graph': '&#xe7fa;',
			'chart3': '&#xe7fa;',
			'chart-growth': '&#xe7fb;',
			'chart4': '&#xe7fb;',
			'chart-bars': '&#xe7fc;',
			'chart5': '&#xe7fc;',
			'chart-settings': '&#xe7fd;',
			'chart6': '&#xe7fd;',
			'cake': '&#xe7fe;',
			'birthday': '&#xe7fe;',
			'gift': '&#xe7ff;',
			'birthday2': '&#xe7ff;',
			'balloon': '&#xe800;',
			'birthday3': '&#xe800;',
			'rank': '&#xe801;',
			'chevron': '&#xe801;',
			'rank2': '&#xe802;',
			'chevron2': '&#xe802;',
			'rank3': '&#xe803;',
			'chevron3': '&#xe803;',
			'crown': '&#xe804;',
			'king': '&#xe804;',
			'lotus': '&#xe805;',
			'flower': '&#xe805;',
			'diamond': '&#xe806;',
			'jewelry': '&#xe806;',
			'diamond2': '&#xe807;',
			'jewelry2': '&#xe807;',
			'diamond3': '&#xe808;',
			'jewelry3': '&#xe808;',
			'diamond4': '&#xe809;',
			'jewelry4': '&#xe809;',
			'linearicons': '&#xe80a;',
			'perxis': '&#xe80a;',
			'Linearicons': '&#xe80a;',
			'teacup': '&#xe80b;',
			'drink': '&#xe80b;',
			'teapot': '&#xe80c;',
			'drink2': '&#xe80c;',
			'glass': '&#xe80d;',
			'drink3': '&#xe80d;',
			'bottle2': '&#xe80e;',
			'drink4': '&#xe80e;',
			'glass-cocktail': '&#xe80f;',
			'drink5': '&#xe80f;',
			'glass2': '&#xe810;',
			'drink6': '&#xe810;',
			'dinner': '&#xe811;',
			'food': '&#xe811;',
			'dinner2': '&#xe812;',
			'food2': '&#xe812;',
			'chef': '&#xe813;',
			'food3': '&#xe813;',
			'scale3': '&#xe814;',
			'weight2': '&#xe814;',
			'egg': '&#xe815;',
			'food4': '&#xe815;',
			'egg2': '&#xe816;',
			'food5': '&#xe816;',
			'eggs': '&#xe817;',
			'food6': '&#xe817;',
			'platter': '&#xe818;',
			'food7': '&#xe818;',
			'steak': '&#xe819;',
			'food8': '&#xe819;',
			'hamburger': '&#xe81a;',
			'food9': '&#xe81a;',
			'hotdog': '&#xe81b;',
			'food10': '&#xe81b;',
			'pizza': '&#xe81c;',
			'food11': '&#xe81c;',
			'sausage': '&#xe81d;',
			'food12': '&#xe81d;',
			'chicken': '&#xe81e;',
			'food13': '&#xe81e;',
			'fish': '&#xe81f;',
			'food14': '&#xe81f;',
			'carrot': '&#xe820;',
			'food15': '&#xe820;',
			'cheese': '&#xe821;',
			'food16': '&#xe821;',
			'bread': '&#xe822;',
			'food17': '&#xe822;',
			'ice-cream': '&#xe823;',
			'dessert': '&#xe823;',
			'ice-cream2': '&#xe824;',
			'dessert2': '&#xe824;',
			'candy': '&#xe825;',
			'dessert3': '&#xe825;',
			'lollipop': '&#xe826;',
			'dessert4': '&#xe826;',
			'coffee-bean': '&#xe827;',
			'coffee': '&#xe827;',
			'coffee-cup': '&#xe828;',
			'drink7': '&#xe828;',
			'cherry': '&#xe829;',
			'fruit': '&#xe829;',
			'grapes': '&#xe82a;',
			'fruit2': '&#xe82a;',
			'citrus': '&#xe82b;',
			'fruit3': '&#xe82b;',
			'apple': '&#xe82c;',
			'fruit4': '&#xe82c;',
			'leaf': '&#xe82d;',
			'nature': '&#xe82d;',
			'landscape': '&#xe82e;',
			'nature2': '&#xe82e;',
			'pine-tree': '&#xe82f;',
			'nature3': '&#xe82f;',
			'tree': '&#xe830;',
			'nature4': '&#xe830;',
			'cactus': '&#xe831;',
			'nature5': '&#xe831;',
			'paw': '&#xe832;',
			'pet': '&#xe832;',
			'footprint': '&#xe833;',
			'steps': '&#xe833;',
			'speed-slow': '&#xe834;',
			'gauge': '&#xe834;',
			'speed-medium': '&#xe835;',
			'gauge2': '&#xe835;',
			'speed-fast': '&#xe836;',
			'gauge3': '&#xe836;',
			'rocket': '&#xe837;',
			'spaceship': '&#xe837;',
			'hammer2': '&#xe838;',
			'justice': '&#xe838;',
			'balance': '&#xe839;',
			'justice2': '&#xe839;',
			'briefcase': '&#xe83a;',
			'suitcase': '&#xe83a;',
			'luggage-weight': '&#xe83b;',
			'scale4': '&#xe83b;',
			'dolly': '&#xe83c;',
			'luggage': '&#xe83c;',
			'plane': '&#xe83d;',
			'flight': '&#xe83d;',
			'plane-crossed': '&#xe83e;',
			'flight2': '&#xe83e;',
			'helicopter': '&#xe83f;',
			'flight3': '&#xe83f;',
			'traffic-lights': '&#xe840;',
			'traffic-signals': '&#xe840;',
			'siren': '&#xe841;',
			'alarm': '&#xe841;',
			'road': '&#xe842;',
			'travel': '&#xe842;',
			'engine': '&#xe843;',
			'motor': '&#xe843;',
			'oil-pressure': '&#xe844;',
			'coolant-temperature': '&#xe845;',
			'thermometer2': '&#xe845;',
			'car-battery': '&#xe846;',
			'battery19': '&#xe846;',
			'gas': '&#xe847;',
			'fuel': '&#xe847;',
			'gallon': '&#xe848;',
			'gas2': '&#xe848;',
			'transmission': '&#xe849;',
			'stick-shift': '&#xe849;',
			'car': '&#xe84a;',
			'travel2': '&#xe84a;',
			'car-wash': '&#xe84b;',
			'car-wash2': '&#xe84c;',
			'bus': '&#xe84d;',
			'travel3': '&#xe84d;',
			'bus2': '&#xe84e;',
			'travel4': '&#xe84e;',
			'car2': '&#xe84f;',
			'travel5': '&#xe84f;',
			'parking': '&#xe850;',
			'car-lock': '&#xe851;',
			'taxi': '&#xe852;',
			'travel6': '&#xe852;',
			'car-siren': '&#xe853;',
			'police': '&#xe853;',
			'car-wash3': '&#xe854;',
			'car-wash4': '&#xe855;',
			'ambulance': '&#xe856;',
			'health8': '&#xe856;',
			'truck': '&#xe857;',
			'delivery': '&#xe857;',
			'trailer': '&#xe858;',
			'delivery2': '&#xe858;',
			'scale-truck': '&#xe859;',
			'weighbridge': '&#xe859;',
			'train': '&#xe85a;',
			'travel7': '&#xe85a;',
			'ship': '&#xe85b;',
			'travel8': '&#xe85b;',
			'ship2': '&#xe85c;',
			'travel9': '&#xe85c;',
			'anchor': '&#xe85d;',
			'sailing': '&#xe85d;',
			'boat': '&#xe85e;',
			'travel10': '&#xe85e;',
			'bicycle': '&#xe85f;',
			'travel11': '&#xe85f;',
			'bicycle2': '&#xe860;',
			'exercise': '&#xe860;',
			'dumbbell': '&#xe861;',
			'exercise2': '&#xe861;',
			'bench-press': '&#xe862;',
			'exercise3': '&#xe862;',
			'swim': '&#xe863;',
			'exercise4': '&#xe863;',
			'football': '&#xe864;',
			'sports': '&#xe864;',
			'baseball-bat': '&#xe865;',
			'sports2': '&#xe865;',
			'baseball': '&#xe866;',
			'sports3': '&#xe866;',
			'tennis': '&#xe867;',
			'sports4': '&#xe867;',
			'tennis2': '&#xe868;',
			'sports5': '&#xe868;',
			'ping-pong': '&#xe869;',
			'sports6': '&#xe869;',
			'hockey': '&#xe86a;',
			'sports7': '&#xe86a;',
			'8ball': '&#xe86b;',
			'sports8': '&#xe86b;',
			'bowling': '&#xe86c;',
			'sports9': '&#xe86c;',
			'bowling-pins': '&#xe86d;',
			'sports10': '&#xe86d;',
			'golf': '&#xe86e;',
			'sports11': '&#xe86e;',
			'golf2': '&#xe86f;',
			'sports12': '&#xe86f;',
			'archery': '&#xe870;',
			'sports13': '&#xe870;',
			'slingshot': '&#xe871;',
			'weapon3': '&#xe871;',
			'soccer': '&#xe872;',
			'sports14': '&#xe872;',
			'basketball': '&#xe873;',
			'sports15': '&#xe873;',
			'cube': '&#xe874;',
			'geometry': '&#xe874;',
			'3d-rotate': '&#xe875;',
			'puzzle': '&#xe876;',
			'piece': '&#xe876;',
			'glasses2': '&#xe877;',
			'vision2': '&#xe877;',
			'glasses3': '&#xe878;',
			'vision3': '&#xe878;',
			'accessibility': '&#xe879;',
			'wheelchair': '&#xe87a;',
			'disabled': '&#xe87a;',
			'wall': '&#xe87b;',
			'bricks': '&#xe87b;',
			'fence': '&#xe87c;',
			'wall2': '&#xe87c;',
			'wall3': '&#xe87d;',
			'bricks2': '&#xe87d;',
			'icons': '&#xe87e;',
			'grid': '&#xe87e;',
			'resize-handle': '&#xe87f;',
			'icons2': '&#xe880;',
			'grid2': '&#xe880;',
			'select': '&#xe881;',
			'cursor': '&#xe881;',
			'select2': '&#xe882;',
			'cursor2': '&#xe882;',
			'site-map': '&#xe883;',
			'tree2': '&#xe883;',
			'earth': '&#xe884;',
			'globe': '&#xe884;',
			'earth-lock': '&#xe885;',
			'internet-lock': '&#xe885;',
			'network': '&#xe886;',
			'globe2': '&#xe886;',
			'network-lock': '&#xe887;',
			'internet-lock2': '&#xe887;',
			'planet': '&#xe888;',
			'globe3': '&#xe888;',
			'happy': '&#xe889;',
			'emoticon': '&#xe889;',
			'smile': '&#xe88a;',
			'emoticon2': '&#xe88a;',
			'grin': '&#xe88b;',
			'emoticon3': '&#xe88b;',
			'tongue': '&#xe88c;',
			'emoticon4': '&#xe88c;',
			'sad': '&#xe88d;',
			'emoticon5': '&#xe88d;',
			'wink': '&#xe88e;',
			'emoticon6': '&#xe88e;',
			'dream': '&#xe88f;',
			'emoticon7': '&#xe88f;',
			'shocked': '&#xe890;',
			'emoticon8': '&#xe890;',
			'shocked2': '&#xe891;',
			'emoticon9': '&#xe891;',
			'tongue2': '&#xe892;',
			'emoticon10': '&#xe892;',
			'neutral': '&#xe893;',
			'emoticon11': '&#xe893;',
			'happy-grin': '&#xe894;',
			'emoticon12': '&#xe894;',
			'cool': '&#xe895;',
			'emoticon13': '&#xe895;',
			'mad': '&#xe896;',
			'emoticon14': '&#xe896;',
			'grin-evil': '&#xe897;',
			'emoticon15': '&#xe897;',
			'evil': '&#xe898;',
			'emoticon16': '&#xe898;',
			'wow': '&#xe899;',
			'emoticon17': '&#xe899;',
			'annoyed': '&#xe89a;',
			'emoticon18': '&#xe89a;',
			'wondering': '&#xe89b;',
			'emoticon19': '&#xe89b;',
			'confused': '&#xe89c;',
			'emoticon20': '&#xe89c;',
			'zipped': '&#xe89d;',
			'emoticon21': '&#xe89d;',
			'grumpy': '&#xe89e;',
			'emoticon22': '&#xe89e;',
			'mustache': '&#xe89f;',
			'emoticon23': '&#xe89f;',
			'tombstone-hipster': '&#xe8a0;',
			'rip': '&#xe8a0;',
			'tombstone': '&#xe8a1;',
			'rip2': '&#xe8a1;',
			'ghost': '&#xe8a2;',
			'spirit': '&#xe8a2;',
			'ghost-hipster': '&#xe8a3;',
			'spirit2': '&#xe8a3;',
			'halloween': '&#xe8a4;',
			'pumpkin': '&#xe8a4;',
			'christmas': '&#xe8a5;',
			'tree3': '&#xe8a5;',
			'easter-egg': '&#xe8a6;',
			'egg3': '&#xe8a6;',
			'mustache2': '&#xe8a7;',
			'hipster': '&#xe8a7;',
			'mustache-glasses': '&#xe8a8;',
			'hipster2': '&#xe8a8;',
			'pipe': '&#xe8a9;',
			'hipster3': '&#xe8a9;',
			'alarm2': '&#xe8aa;',
			'bell': '&#xe8aa;',
			'alarm-add': '&#xe8ab;',
			'bell2': '&#xe8ab;',
			'alarm-snooze': '&#xe8ac;',
			'bell3': '&#xe8ac;',
			'alarm-ringing': '&#xe8ad;',
			'bell4': '&#xe8ad;',
			'bullhorn': '&#xe8ae;',
			'megaphone': '&#xe8ae;',
			'hearing': '&#xe8af;',
			'health9': '&#xe8af;',
			'volume-high': '&#xe8b0;',
			'speaker': '&#xe8b0;',
			'volume-medium': '&#xe8b1;',
			'speaker2': '&#xe8b1;',
			'volume-low': '&#xe8b2;',
			'speaker3': '&#xe8b2;',
			'volume': '&#xe8b3;',
			'speaker4': '&#xe8b3;',
			'mute': '&#xe8b4;',
			'speaker5': '&#xe8b4;',
			'lan': '&#xe8b5;',
			'network2': '&#xe8b5;',
			'lan2': '&#xe8b6;',
			'network3': '&#xe8b6;',
			'wifi': '&#xe8b7;',
			'connection': '&#xe8b7;',
			'wifi-lock': '&#xe8b8;',
			'connection2': '&#xe8b8;',
			'wifi-blocked': '&#xe8b9;',
			'connection3': '&#xe8b9;',
			'wifi-mid': '&#xe8ba;',
			'connection4': '&#xe8ba;',
			'wifi-low': '&#xe8bb;',
			'connection5': '&#xe8bb;',
			'wifi-low2': '&#xe8bc;',
			'connection6': '&#xe8bc;',
			'wifi-alert': '&#xe8bd;',
			'connection7': '&#xe8bd;',
			'wifi-alert-mid': '&#xe8be;',
			'connection8': '&#xe8be;',
			'wifi-alert-low': '&#xe8bf;',
			'connection9': '&#xe8bf;',
			'wifi-alert-low2': '&#xe8c0;',
			'connection10': '&#xe8c0;',
			'stream': '&#xe8c1;',
			'broadcast': '&#xe8c1;',
			'stream-check': '&#xe8c2;',
			'stream2': '&#xe8c2;',
			'stream-error': '&#xe8c3;',
			'stream3': '&#xe8c3;',
			'stream-alert': '&#xe8c4;',
			'stream4': '&#xe8c4;',
			'communication': '&#xe8c5;',
			'waves': '&#xe8c5;',
			'communication-crossed': '&#xe8c6;',
			'waves2': '&#xe8c6;',
			'broadcast2': '&#xe8c7;',
			'waves3': '&#xe8c7;',
			'antenna': '&#xe8c8;',
			'waves4': '&#xe8c8;',
			'satellite': '&#xe8c9;',
			'gps': '&#xe8c9;',
			'satellite2': '&#xe8ca;',
			'antenna2': '&#xe8ca;',
			'mic': '&#xe8cb;',
			'voice': '&#xe8cb;',
			'mic-mute': '&#xe8cc;',
			'voice2': '&#xe8cc;',
			'mic2': '&#xe8cd;',
			'voice3': '&#xe8cd;',
			'spotlights': '&#xe8ce;',
			'featured': '&#xe8ce;',
			'hourglass': '&#xe8cf;',
			'loading': '&#xe8cf;',
			'loading2': '&#xe8d0;',
			'spinner': '&#xe8d0;',
			'loading3': '&#xe8d1;',
			'spinner2': '&#xe8d1;',
			'loading4': '&#xe8d2;',
			'spinner3': '&#xe8d2;',
			'refresh': '&#xe8d3;',
			'spinner4': '&#xe8d3;',
			'refresh2': '&#xe8d4;',
			'spinner5': '&#xe8d4;',
			'undo': '&#xe8d5;',
			'left3': '&#xe8d5;',
			'redo': '&#xe8d6;',
			'right': '&#xe8d6;',
			'jump2': '&#xe8d7;',
			'step-over': '&#xe8d7;',
			'undo2': '&#xe8d8;',
			'ccw': '&#xe8d8;',
			'redo2': '&#xe8d9;',
			'cw': '&#xe8d9;',
			'sync': '&#xe8da;',
			'spinner6': '&#xe8da;',
			'repeat-one2': '&#xe8db;',
			'sync-crossed': '&#xe8dc;',
			'sync2': '&#xe8dd;',
			'spinner7': '&#xe8dd;',
			'repeat-one3': '&#xe8de;',
			'sync-crossed2': '&#xe8df;',
			'return': '&#xe8e0;',
			'backward': '&#xe8e0;',
			'return2': '&#xe8e1;',
			'backward2': '&#xe8e1;',
			'refund': '&#xe8e2;',
			'return3': '&#xe8e2;',
			'history': '&#xe8e3;',
			'archive3': '&#xe8e3;',
			'history2': '&#xe8e4;',
			'archive4': '&#xe8e4;',
			'self-timer': '&#xe8e5;',
			'clock': '&#xe8e6;',
			'time': '&#xe8e6;',
			'clock2': '&#xe8e7;',
			'time2': '&#xe8e7;',
			'clock3': '&#xe8e8;',
			'time3': '&#xe8e8;',
			'watch': '&#xe8e9;',
			'time4': '&#xe8e9;',
			'alarm3': '&#xe8ea;',
			'time5': '&#xe8ea;',
			'alarm-add2': '&#xe8eb;',
			'time6': '&#xe8eb;',
			'alarm-remove': '&#xe8ec;',
			'time7': '&#xe8ec;',
			'alarm-check': '&#xe8ed;',
			'time8': '&#xe8ed;',
			'alarm-error': '&#xe8ee;',
			'time9': '&#xe8ee;',
			'timer': '&#xe8ef;',
			'time10': '&#xe8ef;',
			'timer-crossed': '&#xe8f0;',
			'time11': '&#xe8f0;',
			'timer2': '&#xe8f1;',
			'time12': '&#xe8f1;',
			'timer-crossed2': '&#xe8f2;',
			'time13': '&#xe8f2;',
			'download': '&#xe8f3;',
			'down': '&#xe8f3;',
			'upload': '&#xe8f4;',
			'up': '&#xe8f4;',
			'download2': '&#xe8f5;',
			'down2': '&#xe8f5;',
			'upload2': '&#xe8f6;',
			'up2': '&#xe8f6;',
			'enter-up': '&#xe8f7;',
			'up3': '&#xe8f7;',
			'enter-down': '&#xe8f8;',
			'down3': '&#xe8f8;',
			'enter-left': '&#xe8f9;',
			'left4': '&#xe8f9;',
			'enter-right': '&#xe8fa;',
			'right2': '&#xe8fa;',
			'exit-up': '&#xe8fb;',
			'up4': '&#xe8fb;',
			'exit-down': '&#xe8fc;',
			'down4': '&#xe8fc;',
			'exit-left': '&#xe8fd;',
			'left5': '&#xe8fd;',
			'exit-right': '&#xe8fe;',
			'right3': '&#xe8fe;',
			'enter-up2': '&#xe8ff;',
			'up5': '&#xe8ff;',
			'enter-down2': '&#xe900;',
			'down5': '&#xe900;',
			'enter-vertical': '&#xe901;',
			'enter-left2': '&#xe902;',
			'left6': '&#xe902;',
			'enter-right2': '&#xe903;',
			'right4': '&#xe903;',
			'enter-horizontal': '&#xe904;',
			'arrow': '&#xe904;',
			'exit-up2': '&#xe905;',
			'up6': '&#xe905;',
			'exit-down2': '&#xe906;',
			'down6': '&#xe906;',
			'exit-left2': '&#xe907;',
			'left7': '&#xe907;',
			'exit-right2': '&#xe908;',
			'right5': '&#xe908;',
			'cli': '&#xe909;',
			'console': '&#xe909;',
			'bug': '&#xe90a;',
			'insect': '&#xe90a;',
			'code': '&#xe90b;',
			'embed': '&#xe90b;',
			'file-code': '&#xe90c;',
			'file7': '&#xe90c;',
			'file-image': '&#xe90d;',
			'file8': '&#xe90d;',
			'file-zip': '&#xe90e;',
			'file9': '&#xe90e;',
			'file-audio': '&#xe90f;',
			'file10': '&#xe90f;',
			'file-video': '&#xe910;',
			'file11': '&#xe910;',
			'file-preview': '&#xe911;',
			'file12': '&#xe911;',
			'file-charts': '&#xe912;',
			'file13': '&#xe912;',
			'file-stats': '&#xe913;',
			'file14': '&#xe913;',
			'file-spreadsheet': '&#xe914;',
			'file15': '&#xe914;',
			'link': '&#xe915;',
			'url': '&#xe915;',
			'unlink': '&#xe916;',
			'url2': '&#xe916;',
			'link2': '&#xe917;',
			'url3': '&#xe917;',
			'unlink2': '&#xe918;',
			'url4': '&#xe918;',
			'thumbs-up': '&#xe919;',
			'like': '&#xe919;',
			'thumbs-down': '&#xe91a;',
			'dislike': '&#xe91a;',
			'thumbs-up2': '&#xe91b;',
			'like2': '&#xe91b;',
			'thumbs-down2': '&#xe91c;',
			'dislike2': '&#xe91c;',
			'thumbs-up3': '&#xe91d;',
			'like3': '&#xe91d;',
			'thumbs-down3': '&#xe91e;',
			'dislike3': '&#xe91e;',
			'share2': '&#xe91f;',
			'export': '&#xe91f;',
			'share3': '&#xe920;',
			'social': '&#xe920;',
			'share4': '&#xe921;',
			'social2': '&#xe921;',
			'magnifier': '&#xe922;',
			'search': '&#xe922;',
			'file-search': '&#xe923;',
			'file16': '&#xe923;',
			'find-replace': '&#xe924;',
			'search2': '&#xe924;',
			'zoom-in': '&#xe925;',
			'magnifier2': '&#xe925;',
			'zoom-out': '&#xe926;',
			'magnifier3': '&#xe926;',
			'loupe': '&#xe927;',
			'magnifier4': '&#xe927;',
			'loupe-zoom-in': '&#xe928;',
			'magnifier5': '&#xe928;',
			'loupe-zoom-out': '&#xe929;',
			'magnifier6': '&#xe929;',
			'cross': '&#xe92a;',
			'cancel': '&#xe92a;',
			'menu': '&#xe92b;',
			'options': '&#xe92b;',
			'list': '&#xe92c;',
			'options2': '&#xe92c;',
			'list2': '&#xe92d;',
			'options3': '&#xe92d;',
			'list3': '&#xe92e;',
			'options4': '&#xe92e;',
			'menu2': '&#xe92f;',
			'options5': '&#xe92f;',
			'list4': '&#xe930;',
			'options6': '&#xe930;',
			'menu3': '&#xe931;',
			'dropdown': '&#xe931;',
			'exclamation': '&#xe932;',
			'alert': '&#xe932;',
			'question': '&#xe933;',
			'help2': '&#xe933;',
			'check': '&#xe934;',
			'checkmark': '&#xe934;',
			'cross2': '&#xe935;',
			'cancel2': '&#xe935;',
			'plus': '&#xe936;',
			'add': '&#xe936;',
			'minus': '&#xe937;',
			'subtract': '&#xe937;',
			'percent': '&#xe938;',
			'discount': '&#xe938;',
			'chevron-up': '&#xe939;',
			'up7': '&#xe939;',
			'chevron-down': '&#xe93a;',
			'down7': '&#xe93a;',
			'chevron-left': '&#xe93b;',
			'left8': '&#xe93b;',
			'chevron-right': '&#xe93c;',
			'right6': '&#xe93c;',
			'chevrons-expand-vertical': '&#xe93d;',
			'chevrons': '&#xe93d;',
			'chevrons-expand-horizontal': '&#xe93e;',
			'chevrons2': '&#xe93e;',
			'chevrons-contract-vertical': '&#xe93f;',
			'chevrons3': '&#xe93f;',
			'chevrons-contract-horizontal': '&#xe940;',
			'chevrons4': '&#xe940;',
			'arrow-up': '&#xe941;',
			'up8': '&#xe941;',
			'arrow-down': '&#xe942;',
			'down8': '&#xe942;',
			'arrow-left': '&#xe943;',
			'left9': '&#xe943;',
			'arrow-right': '&#xe944;',
			'right7': '&#xe944;',
			'arrow-up-right': '&#xe945;',
			'up-right': '&#xe945;',
			'arrows-merge': '&#xe946;',
			'up9': '&#xe946;',
			'arrows-split': '&#xe947;',
			'up10': '&#xe947;',
			'arrow-divert': '&#xe948;',
			'reflect': '&#xe948;',
			'arrow-return': '&#xe949;',
			'left10': '&#xe949;',
			'expand': '&#xe94a;',
			'maximize': '&#xe94a;',
			'contract': '&#xe94b;',
			'minimize': '&#xe94b;',
			'expand2': '&#xe94c;',
			'maximize2': '&#xe94c;',
			'contract2': '&#xe94d;',
			'minimize2': '&#xe94d;',
			'move': '&#xe94e;',
			'arrows': '&#xe94e;',
			'tab': '&#xe94f;',
			'switch': '&#xe94f;',
			'arrow-wave': '&#xe950;',
			'expand3': '&#xe951;',
			'maximize3': '&#xe951;',
			'expand4': '&#xe952;',
			'maximize4': '&#xe952;',
			'contract3': '&#xe953;',
			'minimize3': '&#xe953;',
			'notification': '&#xe954;',
			'alert2': '&#xe954;',
			'warning': '&#xe955;',
			'alert3': '&#xe955;',
			'notification-circle': '&#xe956;',
			'alert4': '&#xe956;',
			'question-circle': '&#xe957;',
			'help3': '&#xe957;',
			'menu-circle': '&#xe958;',
			'menu4': '&#xe958;',
			'checkmark-circle': '&#xe959;',
			'checkmark2': '&#xe959;',
			'cross-circle': '&#xe95a;',
			'cross3': '&#xe95a;',
			'plus-circle': '&#xe95b;',
			'plus2': '&#xe95b;',
			'circle-minus': '&#xe95c;',
			'minus2': '&#xe95c;',
			'percent-circle': '&#xe95d;',
			'discount2': '&#xe95d;',
			'arrow-up-circle': '&#xe95e;',
			'up11': '&#xe95e;',
			'arrow-down-circle': '&#xe95f;',
			'down9': '&#xe95f;',
			'arrow-left-circle': '&#xe960;',
			'left11': '&#xe960;',
			'arrow-right-circle': '&#xe961;',
			'right8': '&#xe961;',
			'chevron-up-circle': '&#xe962;',
			'up12': '&#xe962;',
			'chevron-down-circle': '&#xe963;',
			'down10': '&#xe963;',
			'chevron-left-circle': '&#xe964;',
			'left12': '&#xe964;',
			'chevron-right-circle': '&#xe965;',
			'right9': '&#xe965;',
			'backward-circle': '&#xe966;',
			'backward3': '&#xe966;',
			'first-circle': '&#xe967;',
			'first': '&#xe967;',
			'previous-circle': '&#xe968;',
			'previous': '&#xe968;',
			'stop-circle': '&#xe969;',
			'stop': '&#xe969;',
			'play-circle': '&#xe96a;',
			'play2': '&#xe96a;',
			'pause-circle': '&#xe96b;',
			'pause': '&#xe96b;',
			'next-circle': '&#xe96c;',
			'next': '&#xe96c;',
			'last-circle': '&#xe96d;',
			'last': '&#xe96d;',
			'forward-circle': '&#xe96e;',
			'forward': '&#xe96e;',
			'eject-circle': '&#xe96f;',
			'eject': '&#xe96f;',
			'crop': '&#xe970;',
			'cut': '&#xe970;',
			'frame-expand': '&#xe971;',
			'maximize5': '&#xe971;',
			'frame-contract': '&#xe972;',
			'minimize4': '&#xe972;',
			'focus': '&#xe973;',
			'target2': '&#xe973;',
			'transform': '&#xe974;',
			'bounding-box': '&#xe974;',
			'grid3': '&#xe975;',
			'squares': '&#xe975;',
			'grid-crossed': '&#xe976;',
			'squares2': '&#xe976;',
			'layers': '&#xe977;',
			'stack3': '&#xe977;',
			'layers-crossed': '&#xe978;',
			'stack4': '&#xe978;',
			'toggle4': '&#xe979;',
			'fold': '&#xe979;',
			'rulers': '&#xe97a;',
			'tool14': '&#xe97a;',
			'ruler': '&#xe97b;',
			'tool15': '&#xe97b;',
			'funnel': '&#xe97c;',
			'filter': '&#xe97c;',
			'flip-horizontal': '&#xe97d;',
			'mirror': '&#xe97d;',
			'flip-vertical': '&#xe97e;',
			'mirror2': '&#xe97e;',
			'flip-horizontal2': '&#xe97f;',
			'mirror3': '&#xe97f;',
			'flip-vertical2': '&#xe980;',
			'mirror4': '&#xe980;',
			'angle': '&#xe981;',
			'measurement': '&#xe981;',
			'angle2': '&#xe982;',
			'measurement2': '&#xe982;',
			'subtract2': '&#xe983;',
			'boolean-operation': '&#xe983;',
			'combine': '&#xe984;',
			'boolean-operation2': '&#xe984;',
			'intersect': '&#xe985;',
			'boolean-operation3': '&#xe985;',
			'exclude': '&#xe986;',
			'boolean-operation4': '&#xe986;',
			'align-center-vertical': '&#xe987;',
			'align': '&#xe987;',
			'align-right': '&#xe988;',
			'align2': '&#xe988;',
			'align-bottom': '&#xe989;',
			'align3': '&#xe989;',
			'align-left': '&#xe98a;',
			'align4': '&#xe98a;',
			'align-center-horizontal': '&#xe98b;',
			'align5': '&#xe98b;',
			'align-top': '&#xe98c;',
			'align6': '&#xe98c;',
			'square': '&#xe98d;',
			'geometry2': '&#xe98d;',
			'plus-square': '&#xe98e;',
			'add2': '&#xe98e;',
			'minus-square': '&#xe98f;',
			'subtract3': '&#xe98f;',
			'percent-square': '&#xe990;',
			'discount3': '&#xe990;',
			'arrow-up-square': '&#xe991;',
			'up13': '&#xe991;',
			'arrow-down-square': '&#xe992;',
			'down11': '&#xe992;',
			'arrow-left-square': '&#xe993;',
			'left13': '&#xe993;',
			'arrow-right-square': '&#xe994;',
			'right10': '&#xe994;',
			'chevron-up-square': '&#xe995;',
			'up14': '&#xe995;',
			'chevron-down-square': '&#xe996;',
			'down12': '&#xe996;',
			'chevron-left-square': '&#xe997;',
			'left14': '&#xe997;',
			'chevron-right-square': '&#xe998;',
			'right11': '&#xe998;',
			'check-square': '&#xe999;',
			'checkmark3': '&#xe999;',
			'cross-square': '&#xe99a;',
			'cross4': '&#xe99a;',
			'menu-square': '&#xe99b;',
			'menu5': '&#xe99b;',
			'prohibited': '&#xe99c;',
			'forbidden': '&#xe99c;',
			'circle': '&#xe99d;',
			'geometry3': '&#xe99d;',
			'radio-button': '&#xe99e;',
			'ligature': '&#xe99f;',
			'typography': '&#xe99f;',
			'text-format': '&#xe9a0;',
			'typography2': '&#xe9a0;',
			'text-format-remove': '&#xe9a1;',
			'typography3': '&#xe9a1;',
			'text-size': '&#xe9a2;',
			'typography4': '&#xe9a2;',
			'bold': '&#xe9a3;',
			'typography5': '&#xe9a3;',
			'italic': '&#xe9a4;',
			'typography6': '&#xe9a4;',
			'underline': '&#xe9a5;',
			'typography7': '&#xe9a5;',
			'strikethrough': '&#xe9a6;',
			'typography8': '&#xe9a6;',
			'highlight': '&#xe9a7;',
			'magic-marker': '&#xe9a7;',
			'text-align-left': '&#xe9a8;',
			'typography9': '&#xe9a8;',
			'text-align-center': '&#xe9a9;',
			'typography10': '&#xe9a9;',
			'text-align-right': '&#xe9aa;',
			'typography11': '&#xe9aa;',
			'text-align-justify': '&#xe9ab;',
			'typography12': '&#xe9ab;',
			'line-spacing': '&#xe9ac;',
			'typography13': '&#xe9ac;',
			'indent-increase': '&#xe9ad;',
			'typography14': '&#xe9ad;',
			'indent-decrease': '&#xe9ae;',
			'typography15': '&#xe9ae;',
			'text-wrap': '&#xe9af;',
			'typography16': '&#xe9af;',
			'pilcrow': '&#xe9b0;',
			'typography17': '&#xe9b0;',
			'direction-ltr': '&#xe9b1;',
			'typography18': '&#xe9b1;',
			'direction-rtl': '&#xe9b2;',
			'typography19': '&#xe9b2;',
			'page-break': '&#xe9b3;',
			'page-break2': '&#xe9b4;',
			'sort-alpha-asc': '&#xe9b5;',
			'sort': '&#xe9b5;',
			'sort-alpha-desc': '&#xe9b6;',
			'sort2': '&#xe9b6;',
			'sort-numeric-asc': '&#xe9b7;',
			'sort3': '&#xe9b7;',
			'sort-numeric-desc': '&#xe9b8;',
			'sort4': '&#xe9b8;',
			'sort-amount-asc': '&#xe9b9;',
			'sort5': '&#xe9b9;',
			'sort-amount-desc': '&#xe9ba;',
			'sort6': '&#xe9ba;',
			'sort-time-asc': '&#xe9bb;',
			'sort7': '&#xe9bb;',
			'sort-time-desc': '&#xe9bc;',
			'sort8': '&#xe9bc;',
			'sigma': '&#xe9bd;',
			'symbols': '&#xe9bd;',
			'pencil-line': '&#xe9be;',
			'border-color': '&#xe9be;',
			'hand': '&#xe9bf;',
			'drag': '&#xe9bf;',
			'pointer-up': '&#xe9c0;',
			'hand2': '&#xe9c0;',
			'pointer-right': '&#xe9c1;',
			'hand3': '&#xe9c1;',
			'pointer-down': '&#xe9c2;',
			'hand4': '&#xe9c2;',
			'pointer-left': '&#xe9c3;',
			'hand5': '&#xe9c3;',
			'finger-tap': '&#xe9c4;',
			'hand6': '&#xe9c4;',
			'fingers-tap': '&#xe9c5;',
			'hand7': '&#xe9c5;',
			'reminder': '&#xe9c6;',
			'hand8': '&#xe9c6;',
			'fingers-crossed': '&#xe9c7;',
			'hand9': '&#xe9c7;',
			'fingers-victory': '&#xe9c8;',
			'hand10': '&#xe9c8;',
			'gesture-zoom': '&#xe9c9;',
			'hand11': '&#xe9c9;',
			'gesture-pinch': '&#xe9ca;',
			'hand12': '&#xe9ca;',
			'fingers-scroll-horizontal': '&#xe9cb;',
			'hand13': '&#xe9cb;',
			'fingers-scroll-vertical': '&#xe9cc;',
			'hand14': '&#xe9cc;',
			'fingers-scroll-left': '&#xe9cd;',
			'hand15': '&#xe9cd;',
			'fingers-scroll-right': '&#xe9ce;',
			'hand16': '&#xe9ce;',
			'hand17': '&#xe9cf;',
			'drag2': '&#xe9cf;',
			'pointer-up2': '&#xe9d0;',
			'hand18': '&#xe9d0;',
			'pointer-right2': '&#xe9d1;',
			'hand19': '&#xe9d1;',
			'pointer-down2': '&#xe9d2;',
			'hand20': '&#xe9d2;',
			'pointer-left2': '&#xe9d3;',
			'hand21': '&#xe9d3;',
			'finger-tap2': '&#xe9d4;',
			'hand22': '&#xe9d4;',
			'fingers-tap2': '&#xe9d5;',
			'hand23': '&#xe9d5;',
			'reminder2': '&#xe9d6;',
			'hand24': '&#xe9d6;',
			'gesture-zoom2': '&#xe9d7;',
			'hand25': '&#xe9d7;',
			'gesture-pinch2': '&#xe9d8;',
			'hand26': '&#xe9d8;',
			'fingers-scroll-horizontal2': '&#xe9d9;',
			'hand27': '&#xe9d9;',
			'fingers-scroll-vertical2': '&#xe9da;',
			'hand28': '&#xe9da;',
			'fingers-scroll-left2': '&#xe9db;',
			'hand29': '&#xe9db;',
			'fingers-scroll-right2': '&#xe9dc;',
			'hand30': '&#xe9dc;',
			'fingers-scroll-vertical3': '&#xe9dd;',
			'hand31': '&#xe9dd;',
			'border-style': '&#xe9de;',
			'border': '&#xe9de;',
			'border-all': '&#xe9df;',
			'border2': '&#xe9df;',
			'border-outer': '&#xe9e0;',
			'border3': '&#xe9e0;',
			'border-inner': '&#xe9e1;',
			'border4': '&#xe9e1;',
			'border-top': '&#xe9e2;',
			'border5': '&#xe9e2;',
			'border-horizontal': '&#xe9e3;',
			'border6': '&#xe9e3;',
			'border-bottom': '&#xe9e4;',
			'border7': '&#xe9e4;',
			'border-left': '&#xe9e5;',
			'border8': '&#xe9e5;',
			'border-vertical': '&#xe9e6;',
			'border9': '&#xe9e6;',
			'border-right': '&#xe9e7;',
			'border10': '&#xe9e7;',
			'border-none': '&#xe9e8;',
			'border11': '&#xe9e8;',
			'ellipsis': '&#xe9e9;',
			'dots': '&#xe9e9;',
			'0': 0
		};
		delete icons['0'];
		window.icomoonLiga = function (els) {
			var classes,
				el,
				i,
				innerHTML,
				key;
			els = els || document.getElementsByTagName('*');
			if (!els.length) {
				els = [els];
			}
			for (i = 0; ; i += 1) {
				el = els[i];
				if (!el) {
					break;
				}
				classes = el.className;
				if (/icon-/.test(classes)) {
					innerHTML = el.innerHTML;
					if (innerHTML && innerHTML.length > 1) {
						for (key in icons) {
							if (icons.hasOwnProperty(key)) {
								innerHTML = innerHTML.replace(new RegExp(key, 'g'), icons[key]);
							}
						}
						el.innerHTML = innerHTML;
					}
				}
			}
		};
		window.icomoonLiga();
	}
}());