<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo e(translate($role)); ?> | <?php echo e(translate('login')); ?></title>

    <link rel="shortcut icon" href="<?php echo e(dynamicStorage(path: 'storage/app/public/company/'.getWebConfig(name: 'company_fav_icon'))); ?>">

    <link rel="stylesheet" href="<?php echo e(dynamicAsset(path: 'public/assets/back-end/css/google-fonts.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(dynamicAsset(path: 'public/assets/back-end/css/vendor.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(dynamicAsset(path: 'public/assets/back-end/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(dynamicAsset(path: 'public/assets/back-end/vendor/icon-set/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(dynamicAsset(path: 'public/assets/back-end/css/theme.minc619.css?v=1.0')); ?>">
    <link rel="stylesheet" href="<?php echo e(dynamicAsset(path: 'public/assets/back-end/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(dynamicAsset(path: 'public/assets/back-end/css/toastr.css')); ?>">
</head>

<body>
<main id="content" role="main" class="main">
    <div class="position-fixed top-0 right-0 left-0 bg-img-hero __inline-1">
        <figure class="position-absolute right-0 bottom-0 left-0">
            <svg preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 1921 273">
                <polygon fill="#fff" points="0,273 1921,273 1921,0 "/>
            </svg>
        </figure>
    </div>
    <div class="container py-5 py-sm-7">
        <label class="badge badge-soft-success float-right __inline-2"><?php echo e(translate('software_version')); ?>

            : <?php echo e(env('SOFTWARE_VERSION')); ?></label>
        <?php ($e_commerce_logo = getWebConfig(name: 'company_web_logo')); ?>
        <a class="d-flex justify-content-center mb-5" href="<?php echo e(route('home')); ?>">
            <img class="z-index-2 onerror-logo" height="40" src="<?php echo e(getValidImage(path: "storage/app/public/company/".$e_commerce_logo, type:'backend-logo')); ?>" alt="Logo">
        </a>

        <div class="row justify-content-center">
            <div class="col-md-7 col-lg-5">
                <div class="card card-lg mb-5">
                    <div class="card-body">
                        <form id="form-id" action="<?php echo e(route('login')); ?>" method="post" id="admin-login-form">
                            <?php echo csrf_field(); ?>
                            <div class="text-center">
                                <div class="mb-5">
                                    <h1 class="display-4"><?php echo e(translate('sign_in')); ?></h1><br>
                                    <span>( <?php echo e(translate($role)); ?> <?php echo e(translate('Login')); ?>)</span>
                                </div>
                            </div>

                            <input type="hidden" class="form-control mb-3" name="role" id="role" value="<?php echo e($role); ?>">

                            <div class="js-form-message form-group">
                                <label class="input-label" for="signingAdminEmail"><?php echo e(translate('your_email')); ?></label>

                                <input type="email" class="form-control form-control-lg" name="email" id="signingAdminEmail"
                                       tabindex="1" placeholder="email@address.com" aria-label="email@address.com"
                                       required data-msg="Please enter a valid email address.">
                            </div>
                            <div class="js-form-message form-group">
                                <label class="input-label" for="signingAdminPassword" tabindex="0">
                                    <span class="d-flex justify-content-between align-items-center">
                                      <?php echo e(translate('password')); ?>

                                    </span>
                                </label>

                                <div class="input-group input-group-merge">
                                    <input type="password" class="js-toggle-password form-control form-control-lg"
                                           name="password" id="signingAdminPassword"
                                           placeholder="<?php echo e(translate('8+_characters_required')); ?>"
                                           aria-label="8+ characters required" required
                                           data-msg="Your password is invalid. Please try again."
                                           data-hs-toggle-password-options='{
                                                     "target": "#changePassTarget",
                                            "defaultClass": "tio-hidden-outlined",
                                            "showClass": "tio-visible-outlined",
                                            "classChangeTarget": "#changePassIcon"
                                            }'>
                                    <div id="changePassTarget" class="input-group-append">
                                        <a class="input-group-text" href="javascript:">
                                            <i id="changePassIcon" class="tio-visible-outlined"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="termsCheckbox"
                                           name="remember">
                                    <label class="custom-control-label text-muted" for="termsCheckbox">
                                        <?php echo e(translate('remember_me')); ?>

                                    </label>
                                </div>
                            </div>
                            <?php if(isset($recaptcha) && $recaptcha['status'] == 1): ?>
                                <div id="recaptcha_element" class="w-100;" data-type="image"></div>
                                <br/>
                            <?php else: ?>
                                <div class="row p-2">
                                    <div class="col-6 pr-0">
                                        <input type="text" class="form-control form-control-lg border-0"
                                               name="default_captcha_value" value="" required
                                               placeholder="<?php echo e(translate('enter_captcha_value')); ?>" autocomplete="off">
                                    </div>
                                    <div class="col-6 input-icons bg-white rounded">
                                        <a class="get-login-recaptcha-verify" data-link="<?php echo e(URL('login/recaptcha/')); ?>">
                                            <img src="<?php echo e(URL('login/recaptcha/'.rand().'?captcha_session_id=default_recaptcha_id_'.$role.'_login')); ?>"
                                                 class="input-field w-90 h-75" id="default_recaptcha_id" alt="">
                                            <i class="tio-refresh icon"></i>
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <button type="submit" class="btn btn-lg btn-block btn--primary">
                                <?php echo e(translate('sign_in')); ?>

                            </button>
                        </form>
                    </div>
                    <?php if(env('APP_MODE')=='demo'): ?>
                        <div class="card-footer">
                            <div class="row">
                                <div class="col-10">
                                    <span id="admin-email" data-email="<?php echo e(\App\Enums\DemoConstant::ADMIN['email']); ?>"><?php echo e(translate('email')); ?> : <?php echo e(\App\Enums\DemoConstant::ADMIN['email']); ?></span><br>
                                    <span id="admin-password" data-password="<?php echo e(\App\Enums\DemoConstant::ADMIN['password']); ?>"><?php echo e(translate('password')); ?> : <?php echo e(\App\Enums\DemoConstant::ADMIN['password']); ?></span>
                                </div>
                                <div class="col-2">
                                    <button class="btn btn--primary" id="copyLoginInfo"><i class="tio-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</main>

<span id="message-please-check-recaptcha" data-text="<?php echo e(translate('please_check_the_recaptcha')); ?>"></span>
<span id="message-copied_success" data-text="<?php echo e(translate('copied_successfully')); ?>"></span>

<script src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/js/vendor.min.js')); ?>"></script>

<script src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/js/theme.min.js')); ?>"></script>
<script src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/js/toastr.js')); ?>"></script>
<script src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/js/admin/login.js')); ?>"></script>
<?php echo Toastr::message(); ?>


<?php if($errors->any()): ?>
    <script>
        "use strict";
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        toastr.error('<?php echo e($error); ?>', Error, {
            CloseButton: true,
            ProgressBar: true
        });
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </script>
<?php endif; ?>
<?php if(isset($recaptcha) && $recaptcha['status'] == 1): ?>
    <script type="text/javascript">
        "use strict";
        var onloadCallback = function () {
            grecaptcha.render('recaptcha_element', {
                'sitekey': '<?php echo e(getWebConfig(name: 'recaptcha')['site_key']); ?>'
            });
        };
    </script>
    <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit" async defer></script>
<?php endif; ?>

</body>
</html>

<?php /**PATH /home/elitede1/ecommerce11.elitedesign.com.bd/resources/views/admin-views/auth/login.blade.php ENDPATH**/ ?>