<?php
    use function App\Utils\hex_to_rgb;
?>
    <!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(session()->get('direction')); ?>">
<head>
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <meta name="base-url" content="<?php echo e(url('/')); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta name="_token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(dynamicStorage(path: 'storage/app/public/company')); ?>/<?php echo e($web_config['fav_icon']->value); ?>"/>
    <link rel="stylesheet" href="<?php echo e(theme_asset('assets/css/fonts-init.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(theme_asset('assets/css/bootstrap.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(theme_asset('assets/css/bootstrap-icons.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(theme_asset('assets/plugins/magnific-popup-1.1.0/magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(theme_asset('assets/plugins/swiper/swiper-bundle.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(theme_asset('assets/plugins/sweet_alert/sweetalert2.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(theme_asset('assets/css/toastr.css')); ?>"/>

    <link rel="stylesheet" href="<?php echo e(theme_asset('assets/plugins/select2/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(theme_asset('assets/plugins/intl-tel-input/css/intlTelInput.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(theme_asset('assets/css/style.css')); ?>"/>
    <?php echo $__env->yieldPushContent('css_or_js'); ?>
    <link rel="stylesheet" href="<?php echo e(theme_asset('assets/css/custom.css')); ?>"/>
    <style>
        :root {
            --bs-primary: <?php echo e($web_config['primary_color']); ?>;
            --bs-primary-rgb: <?php echo e(hex_to_rgb($web_config['primary_color'])); ?>;
            --primary-dark: <?php echo e($web_config['primary_color']); ?>;
            --primary-light: <?php echo e($web_config['primary_color_light']); ?>;
            --bs-secondary: <?php echo e($web_config['secondary_color']); ?>;
            --bs-secondary-rgb: <?php echo e(hex_to_rgb($web_config['secondary_color'])); ?>;
        }

        .announcement-color {
            background-color: <?php echo e($web_config['announcement']['color']); ?>;
            color: <?php echo e($web_config['announcement']['text_color']); ?>;
        }
        .btn-outline-success {
            --bs-btn-hover-bg: <?php echo e($web_config['primary_color']); ?> !important;
            --bs-btn-active-bg: <?php echo e($web_config['primary_color']); ?> !important;
            --bs-btn-border-color: <?php echo e($web_config['primary_color']); ?> !important;
        }
        .btn-outline-success:active {
            background-color: var(--bg-color) !important;
            color: <?php echo e($web_config['primary_color']); ?> !important;
            --bs-btn-border-color: <?php echo e($web_config['primary_color']); ?> !important;
        }
    </style>
    <?php ($google_tag_manager_id = getWebConfig(name: 'google_tag_manager_id')); ?>
    <?php if($google_tag_manager_id ): ?>
        <script>(function (w, d, s, l, i) {
                w[l] = w[l] || [];
                w[l].push({
                    'gtm.start':
                        new Date().getTime(), event: 'gtm.js'
                });
                let f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s), dl = l !== 'dataLayer' ? '&l=' + l : '';
                j.async = true;
                j.src =
                    'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
                f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', '<?php echo e($google_tag_manager_id); ?>');
        </script>
    <?php endif; ?>
    <?php ($pixel_analytices_user_code =getWebConfig(name: 'pixel_analytics')); ?>
    <?php if($pixel_analytices_user_code): ?>
        <script>
            !function (f, b, e, v, n, t, s) {
                if (f.fbq) return;
                n = f.fbq = function () {
                    n.callMethod ?
                        n.callMethod.apply(n, arguments) : n.queue.push(arguments)
                };
                if (!f._fbq) f._fbq = n;
                n.push = n;
                n.loaded = !0;
                n.version = '2.0';
                n.queue = [];
                t = b.createElement(e);
                t.async = !0;
                t.src = v;
                s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s)
            }(window, document, 'script',
                'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '<?php echo e($pixel_analytices_user_code); ?>');
            fbq('track', 'PageView');
        </script>
        <noscript>
            <img class="d-none" height="1" width="1"
                 src="https://www.facebook.com/tr?id=<?php echo e($pixel_analytices_user_code); ?>&ev=PageView&noscript=1" alt=""/>
        </noscript>
    <?php endif; ?>
</head>
<body class="toolbar-enabled">
<script>
    'use strict';
    function setThemeMode() {
        if (localStorage.getItem('theme') === null) {
            document.body.setAttribute('theme', 'light');
        } else {
            document.body.setAttribute('theme', localStorage.getItem('theme'));
        }
    }
    setThemeMode();
</script>
<?php if($google_tag_manager_id): ?>
    <noscript>
        <iframe class="d-none visibility-hidden" src="https://www.googletagmanager.com/ns.html?id=<?php echo e($google_tag_manager_id); ?>"
                height="0" width="0"></iframe>
    </noscript>
<?php endif; ?>
<div class="preloader d--none" id="loading">
    <img width="200" alt="" src="<?php echo e(getValidImage(path: 'storage/app/public/company/'.getWebConfig(name: 'loader_gif'), type: 'source', source: theme_asset('assets/img/loader.gif'))); ?>">
</div>

<?php echo $__env->make('theme-views.layouts.partials._header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('theme-views.layouts.partials._settings-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldContent('content'); ?>
<?php echo $__env->make('theme-views.layouts.partials._feature', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('theme-views.layouts.partials._footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<a href="#" class="back-to-top">
    <i class="bi bi-arrow-up"></i>
</a>
<div class="app-bar px-sm-2 d-xl-none" id="mobile_app_bar">
    <?php echo $__env->make('theme-views.layouts.partials._app-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<span class="customize-text"
      data-textno="<?php echo e(translate('no')); ?>"
      data-textyes="<?php echo e(translate('yes')); ?>"
      data-textnow="<?php echo e(translate('now')); ?>"
      data-textsuccessfullycopied="<?php echo e(translate('successfully_copied')); ?>"
      data-text-no-discount="<?php echo e(translate('no_discount')); ?>"
      data-stock-available="<?php echo e(translate('stock_available')); ?>"
      data-stock-not-available="<?php echo e(translate('stock_not_available')); ?>"
      data-update-this-address="<?php echo e(translate('update_this_Address')); ?>"
      data-password-characters-limit="<?php echo e(translate('your_password_must_be_at_least_8_characters')); ?>"
      data-password-not-match="<?php echo e(translate('password_does_not_Match')); ?>"
      data-textpleaseselectpaymentmethods="<?php echo e(translate('please_select_a_payment_Methods')); ?>"
      data-reviewmessage="<?php echo e(translate('you_can_review_after_the_product_is_delivered')); ?>"
      data-refundmessage="<?php echo e(translate('you_can_refund_request_after_the_product_is_delivered')); ?>"
      data-textshoptemporaryclose="<?php echo e(translate('This_shop_is_temporary_closed_or_on_vacation').' '.translate('You_cannot_add_product_to_cart_from_this_shop_for_now')); ?>"
></span>
<span class="system-default-country-code" data-value="<?php echo e(getWebConfig(name: 'country_code') ?? 'us'); ?>"></span>
<span class="cannot_use_zero" data-text="<?php echo e(translate('cannot_Use_0_only')); ?>"></span>
<span class="system-default-country-code" data-value="<?php echo e(getWebConfig(name: 'country_code') ?? 'us'); ?>"></span>
<?php ($cookie = $web_config['cookie_setting'] ? json_decode($web_config['cookie_setting']['value'], true):null); ?>
<?php if($cookie && $cookie['status']==1): ?>
    <section id="cookie-section"></section>
<?php endif; ?>

<?php echo $__env->make('theme-views.layouts.partials.modal._register', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('theme-views.layouts.partials.modal._login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('theme-views.layouts.partials.modal._quick-view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('theme-views.layouts.partials.modal._initial', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php ($whatsapp = getWebConfig(name: 'whatsapp')); ?>
<div class="social-chat-icons">
    <?php if(isset($whatsapp['status']) && $whatsapp['status'] == 1 ): ?>
        <div class="">
            <a href="https://wa.me/<?php echo e($whatsapp['phone']); ?>?text=Hello%20there!" target="_blank">
                <img src="<?php echo e(theme_asset('assets/img/whatsapp.svg')); ?>" width="35" class="chat-image-shadow"
                     alt="Chat with us on WhatsApp">
            </a>
        </div>
    <?php endif; ?>
</div>

<?php echo $__env->make('theme-views.layouts.partials._translate-text-for-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('theme-views.layouts.partials._route-for-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('theme-views.layouts.main-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo Toastr::message(); ?>

<?php echo $__env->yieldPushContent('script'); ?>

</body>
</html>
<?php /**PATH /home/youngerlifestyle/public_html/resources/themes/theme_aster/theme-views/layouts/app.blade.php ENDPATH**/ ?>