<?php $__env->startSection('title', translate('track_order').' | '.$web_config['name']->value.' '.translate('ecommerce')); ?>

<?php $__env->startSection('content'); ?>
<section class="breadcrumb-section pt-20px">
    <div class="container">
        <div class="section-title mb-4">
            <div
                class="d-flex flex-wrap justify-content-between row-gap-3 column-gap-2 align-items-center search-page-title">
                <ul class="breadcrumb">
                    <li>
                        <a href="<?php echo e(route('home')); ?>"><?php echo e(translate('home')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('track-order.index')); ?>"><?php echo e(translate('track_order')); ?></a>
                    </li>
                </ul>
                <?php if(auth('customer')->check()): ?>
                    <div class="ms-auto ms-md-0">
                        <a href="<?php echo e(route('account-oder')); ?>" class="text-base text-capitalize"><?php echo e(translate('check_all_order')); ?></a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>


<section class="search-track-section pt-20px">
    <div class="container">
        <h3 class="mb-3 mb-lg-4"><?php echo e(translate('track_order')); ?></h3>
        <?php if(session()->has('Error')): ?>
            <div class="media-body alert">
                <div class="badge font-regular badge-soft-danger tract-page-error-notification"><?php echo e(session()->get('Error')); ?>

                </div>
                <span class="close-btn" data-bs-dismiss="alert">x</span>
            </div>
        <?php endif; ?>
        <form action="<?php echo e(route('track-order.result')); ?>" type="submit" method="post" >
            <?php echo csrf_field(); ?>
            <div class="track-order-wrapper">
                <div class="track-order-input col--5">
                    <input type="text" class="form-control" name="order_id" value="<?php echo e(old('order_id')); ?>" placeholder="<?php echo e(translate('order_ID')); ?>">
                </div>
                <div class="track-order-input col--5">
                    <input type="text" class="form-control" name="phone_number" value="<?php echo e(old('phone_number')); ?>" placeholder="<?php echo e(translate('phone')); ?>">
                </div>
                <div class="track-order-input col--2">
                    <button type="submit" class="form-control btn btn-base"><?php echo e(translate('track_order')); ?></button>
                </div>
            </div>
        </form>
        <div class="text-center">
            <div class="container">
                <div class="search-track-initials text-text-2">
                    <img loading="lazy" src="<?php echo e(theme_asset('assets/img/track/truck.png')); ?>" alt="<?php echo e(translate('order')); ?>">
                    <p><?php echo e(translate('enter_your_order_ID_& _phone_to_get_delivery_updates')); ?></p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme-views.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitede1/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/order/tracking-page.blade.php ENDPATH**/ ?>