<footer class="footer">
    <div class="footer-bg-img" data-bg-img="<?php echo e(theme_asset('assets/img/background/footer-bg.png')); ?>">
    </div>
    <div class="footer-top">
        <div class="container">
            <div class="row gy-3 align-items-center">
                <div class="col-lg-3 col-sm-3 text-center text-lg-start">
                    <img width="180" loading="lazy" alt="<?php echo e(translate('image')); ?>"
                         src="<?php echo e(getValidImage(path: 'storage/app/public/company/'.($web_config['footer_logo']->value), type:'logo')); ?>">
                </div>
                <div
                    class="col-lg-6 col-sm-6 d-flex justify-content-center justify-content-sm-start justify-content-lg-center">
                    <ul class="list-socials list-socials--white gap-4 fs-18">
                        <?php if($web_config['social_media']): ?>
                            <?php $__currentLoopData = $web_config['social_media']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <?php if($item->name == "twitter"): ?>
                                        <a href="<?php echo e($item->link); ?>" target="_blank" class="font-bold">
                                            <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="20"
                                                 height="20" viewBox="0 0 24 24">
                                                <g opacity=".3">
                                                    <polygon fill="#fff" fill-rule="evenodd"
                                                             points="16.002,19 6.208,5 8.255,5 18.035,19"
                                                             clip-rule="evenodd"></polygon>
                                                    <polygon
                                                        points="8.776,4 4.288,4 15.481,20 19.953,20 8.776,4"></polygon>
                                                </g>
                                                <polygon fill-rule="evenodd"
                                                         points="10.13,12.36 11.32,14.04 5.38,21 2.74,21"
                                                         clip-rule="evenodd"></polygon>
                                                <polygon fill-rule="evenodd"
                                                         points="20.74,3 13.78,11.16 12.6,9.47 18.14,3"
                                                         clip-rule="evenodd"></polygon>
                                                <path
                                                    d="M8.255,5l9.779,14h-2.032L6.208,5H8.255 M9.298,3h-6.93l12.593,18h6.91L9.298,3L9.298,3z"
                                                    fill="currentColor"></path>
                                            </svg>
                                        </a>
                                    <?php elseif($item->name == 'google-plus'): ?>
                                        <a href="<?php echo e($item->link); ?>" target="_blank">
                                            <i class="bi bi-google"></i>
                                        </a>
                                    <?php else: ?>
                                        <a href="<?php echo e($item->link); ?>" target="_blank">
                                            <i class="bi bi-<?php echo e($item->name); ?>"></i>
                                        </a>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="col-lg-3 col-sm-3 d-flex justify-content-center justify-content-sm-start">
                    <div class="media gap-3 absolute-white">
                        <i class="bi bi-telephone-forward fs-28"></i>
                        <div class="media-body">
                            <h6 class="absolute-white mb-1"><?php echo e(translate('hotline')); ?></h6>
                            <a dir="ltr" href="tel:<?php echo e($web_config['phone']->value); ?>"
                               class="absolute-white"><?php echo e($web_config['phone']->value); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-main px-2  px-lg-0">
        <div class="container">
            <div class="row gy-5">
                <div class="col-lg-4">
                    <div class="widget widget--about text-center text-lg-start absolute-white">
                        <p><?php echo e(getWebConfig(name: 'shop_address')); ?></p>
                        <a href="mailto:<?php echo e($web_config['email']->value); ?>"><?php echo e($web_config['email']->value); ?></a>

                        <div class="d-flex gap-3 justify-content-center justify-content-lg-start flex-wrap mt-4">
                            <?php if($web_config['android']['status']): ?>
                                <a href="<?php echo e($web_config['android']['link']); ?>">
                                    <img
                                        src="<?php echo e(theme_asset('assets/img/media/google-play.png')); ?>" loading="lazy"
                                        alt="<?php echo e(translate('image')); ?>">
                                </a>
                            <?php endif; ?>
                            <?php if($web_config['ios']['status']): ?>
                                <a href="<?php echo e($web_config['ios']['link']); ?>">
                                    <img
                                        src="<?php echo e(theme_asset('assets/img/media/app-store.png')); ?>" loading="lazy"
                                        alt="<?php echo e(translate('image')); ?>">
                                </a>
                            <?php endif; ?>
                        </div>
                        <div class="mt-4 mb-3">
                            <div class="d-flex gap-2">
                                <h6 class="text-uppercase mb-2 font-weight-bold footer-heder"><?php echo e(translate('newsletter')); ?></h6>
                                <i class="bi bi-send-fill mt-n1"></i>
                            </div>
                            <p><?php echo e(translate('subscribe_our_newsletter_to_get_latest_updates')); ?></p>
                        </div>
                        <form class="newsletter-form" action="<?php echo e(route('subscription')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="position-relative">
                                <label class="position-relative m-0 d-block">
                                    <i class="bi bi-envelope envelop-icon text-muted fs-18"></i>
                                    <input type="text" placeholder="<?php echo e(translate('enter_your_email')); ?>"
                                           class="form-control" name="subscription_email" required>
                                </label>
                                <button type="submit" class="btn btn-primary"><?php echo e(translate('submit')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="row gy-5">
                        <div class="col-sm-4 col-6">
                            <div class="widget widget--nav absolute-white">
                                <h4 class="widget__title"><?php echo e(translate('accounts')); ?></h4>
                                <ul class="d-flex flex-column gap-3">
                                    <?php if($web_config['seller_registration']): ?>
                                        <li>
                                            <a class="text-capitalize"
                                               href="<?php echo e(route('vendor.auth.registration.index')); ?>"><?php echo e(translate('open_your_store')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <li>
                                        <?php if(auth('customer')->check()): ?>
                                            <a href="<?php echo e(route('user-profile')); ?>"><?php echo e(translate('profile')); ?></a>
                                        <?php else: ?>
                                            <button class="bg-transparent border-0 p-0" data-bs-toggle="modal"
                                                    data-bs-target="#loginModal"><?php echo e(translate('profile')); ?></button>
                                        <?php endif; ?>
                                    </li>
                                    <li>
                                        <a class="text-capitalize"
                                           href="<?php echo e(route('track-order.index')); ?>"><?php echo e(translate('track_order')); ?></a>
                                    </li>
                                    <li><a class="text-capitalize"
                                           href="<?php echo e(route('contacts')); ?>"><?php echo e(translate('help_&_support')); ?></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-sm-4 col-6">
                            <div class="widget widget--nav absolute-white">
                                <h4 class="widget__title text-capitalize"><?php echo e(translate('quick_links')); ?></h4>
                                <ul class="d-flex flex-column gap-3">
                                    <?php if($web_config['flash_deals']): ?>
                                        <li>
                                            <a class="text-capitalize"
                                               href="<?php echo e(route('flash-deals',[$web_config['flash_deals']['id']])); ?>"><?php echo e(translate('flash_deals')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <li>
                                        <a class="text-capitalize"
                                           href="<?php echo e(route('products',['data_from'=>'featured','page'=>1])); ?>"><?php echo e(translate('featured_products')); ?></a>
                                    </li>
                                    <li><a class="text-capitalize"
                                           href="<?php echo e(route('vendors')); ?>"><?php echo e(translate('top_stores')); ?></a></li>
                                    <li>
                                        <a class="text-capitalize"
                                           href="<?php echo e(route('products',['data_from'=>'latest'])); ?>"><?php echo e(translate('latest_products')); ?></a>
                                    </li>
                                    <li><a href="<?php echo e(route('helpTopic')); ?>"><?php echo e(translate('FAQ')); ?></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-sm-4 col-6">
                            <div class="widget widget--nav absolute-white">
                                <h4 class="widget__title"><?php echo e(translate('other')); ?></h4>
                                <ul class="d-flex flex-column gap-3">
                                    <li><a class="text-capitalize"
                                           href="<?php echo e(route('about-us')); ?>"><?php echo e(translate('about_company')); ?></a></li>
                                    <li><a class="text-capitalize"
                                           href="<?php echo e(route('privacy-policy')); ?>"><?php echo e(translate('privacy_policy')); ?></a></li>
                                    <li><a class="text-capitalize"
                                           href="<?php echo e(route('terms')); ?>"><?php echo e(translate('terms_&_conditions')); ?></a></li>

                                    <?php if(isset($web_config['refund_policy']['status']) && $web_config['refund_policy']['status'] == 1): ?>
                                        <li>
                                            <a class="text-capitalize"
                                               href="<?php echo e(route('refund-policy')); ?>"><?php echo e(translate('refund_policy')); ?></a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(isset($web_config['return_policy']['status']) && $web_config['return_policy']['status'] == 1): ?>
                                        <li>
                                            <a class="text-capitalize"
                                               href="<?php echo e(route('return-policy')); ?>"><?php echo e(translate('return_policy')); ?></a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(isset($web_config['cancellation_policy']['status']) && $web_config['cancellation_policy']['status'] == 1): ?>
                                        <li>
                                            <a class="text-capitalize"
                                               href="<?php echo e(route('cancellation-policy')); ?>"><?php echo e(translate('cancellation_policy')); ?></a>
                                        </li>
                                    <?php endif; ?>

                                    <li>
                                        <?php if(auth('customer')->check()): ?>
                                            <a class="text-capitalize"
                                               href="<?php echo e(route('account-tickets')); ?>"><?php echo e(translate('support_ticket')); ?></a>
                                        <?php else: ?>
                                            <button class="bg-transparent border-0 p-0 text-capitalize"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#loginModal"><?php echo e(translate('support_ticket')); ?></button>
                                        <?php endif; ?>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom absolute-white">
        <div class="container">
            <div class="text-center copyright-text">
                <?php echo e($web_config['copyright_text']->value); ?>

            </div>
        </div>
    </div>
</footer>
<?php /**PATH /home/youngerlifestyle/public_html/resources/themes/theme_aster/theme-views/layouts/partials/_footer.blade.php ENDPATH**/ ?>