<?php $__env->startSection('title', translate('add_address').' | '.$web_config['name']->value.' '.translate('ecommerce')); ?>

<?php $__env->startSection('content'); ?>
    <section class="user-profile-section section-gap pt-0">
        <div class="container">
            <?php echo $__env->make('theme-views.partials._profile-aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card border-0 __shadow">
                <div class="card-body p-3 p-sm-4 text-capitalize">
                    <div class="text-end">
                        <a href="<?php echo e(route('user-profile')); ?>" class="cmn-btn __btn-outline" >
                            <i class="bi bi-chevron-left "></i><?php echo e(translate('go_back')); ?>

                        </a>
                    </div>
                    <form  action="<?php echo e(route('address-store')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row g-4">
                            <div class="col-md-6 ">
                                <h6 class="form--label mb-3"><?php echo e(translate('choose_label')); ?></h6>
                                <ul class="d-flex flex-wrap gap-4 address-label-area">
                                    <li>
                                        <div class="d-flex align-items-center gap-2 item">
                                            <label class="form-check-size">
                                                <input type="radio"  name="addressAs" value="home" checked>
                                                <span class="form-check-label">
                                                    <i class="bi bi-house"></i>
                                                    <span><?php echo e(translate('home')); ?></span>
                                                </span>
                                            </label>
                                        </div>

                                    </li>
                                    <li>
                                        <div class="d-flex align-items-center gap-2 item">
                                            <label class="form-check-size">
                                                <input type="radio"  name="addressAs" value="permanent" >
                                                <span class="form-check-label">
                                                    <i class="bi bi-paperclip"></i>
                                                    <span><?php echo e(translate('permanent')); ?></span>
                                                </span>
                                            </label>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="d-flex align-items-center gap-2 item">
                                            <label class="form-check-size">
                                                <input type="radio" name="addressAs" value="office" >
                                                <span class="form-check-label">
                                                    <i class="bi bi-briefcase"></i>
                                                    <span><?php echo e(translate('office')); ?></span>
                                                </span>
                                            </label>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-6 ">
                                <h6 class="form--label mb-3"><?php echo e(translate('choose_address_type')); ?></h6>
                                <ul class="d-flex flex-wrap gap-4 gap-xl-5">
                                    <li class="d-flex flex-wrap gap-2">
                                        <label class="d-flex align-items-center gap-10 text-nowrap form-check">
                                            <input type="radio" name="is_billing" value="1" checked class="form-check-input">
                                            <span class="form-check-label"><?php echo e(translate('billing_address')); ?></span>
                                        </label>
                                    </li>
                                    <li>
                                        <label class="d-flex align-items-center gap-10 text-nowrap form-check">
                                            <input type="radio" name="is_billing" value="0" class="form-check-input">
                                            <span class="form-check-label"><?php echo e(translate('shipping_address')); ?></span>
                                        </label>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-sm-6">
                                <label class="form--label mb-2" for="f-name"><?php echo e(translate('contact_person')); ?></label>
                                <input type="text" id="f-name" name="name" class="form-control" placeholder="<?php echo e(translate('ex')); ?> : <?php echo e(translate('Jhone')); ?> <?php echo e(translate('Doe')); ?>" required>
                            </div>
                            <div class="col-sm-6">
                                <label class="form--label mb-2" for="phone"><?php echo e(translate('phone')); ?></label>
                                <input type="tel" id="phone" name="phone" class="form-control"  placeholder="<?php echo e(translate('ex')); ?> : <?php echo e(translate('01XXXXXX')); ?>" required>
                            </div>
                            <div class="col-sm-6">
                                <label class="form--label mb-2" for="country"><?php echo e(translate('country')); ?></label>
                                <select name="country" id="country" class="form-control select_picker" required>
                                    <option value="" disabled selected><?php echo e(translate('select_country')); ?></option>
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($d['name']); ?>"><?php echo e($d['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-sm-6">
                                <label class="form--label mb-2" for="city"><?php echo e(translate('city')); ?></label>
                                <input type="text" class="form-control" id="city" name="city" placeholder="<?php echo e(translate('enter_your_city')); ?>" required>
                            </div>
                            <div class="col-sm-6">
                                <label class="form--label mb-2" for="zip_code"><?php echo e(translate('Zip_Code')); ?></label>
                                <?php if($zip_restrict_status): ?>
                                    <select name="zip" id="zip_code" class="form-control select2 select_picker" data-live-search="true"  required>
                                        <?php $__currentLoopData = $zip_codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($zip->zipcode); ?>" ><?php echo e($zip->zipcode); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                <?php else: ?>
                                    <input class="form-control" type="text" id="zip_code" name="zip" placeholder="<?php echo e(translate('enter_your_zip_code')); ?>" required>
                                <?php endif; ?>
                            </div>
                            <div class="col-sm-6">
                                <label class="form--label mb-2" for="address"><?php echo e(translate('address')); ?></label>
                                <textarea name="address" id="address" class="form-control" placeholder="<?php echo e(translate('ex_:_1216_Dhaka')); ?>" required></textarea>
                            </div>
                            <div class="col-sm-12">
                                <input id="pac-input" class="controls rounded __map-input mt-1" title="<?php echo e(translate('search_your_location_here')); ?>" type="text" placeholder="<?php echo e(translate('search_here')); ?>"/>
                                <div class="dark-support rounded w-100 __h-14rem mb-4" id="location_map_canvas"></div>
                            </div>
                            <input type="hidden" id="latitude"
                                    name="latitude" class="form-control d-inline"
                                     value="<?php echo e($default_location?$default_location['lat']:0); ?>" required readonly>
                            <input type="hidden"
                                    name="longitude" class="form-control"
                                     id="longitude" value="<?php echo e($default_location?$default_location['lng']:0); ?>" required >
                        </div>
                        <div class="col-sm-12">
                            <div class="d-flex flex-wrap justify-content-end gap-3 ">
                                <button type="submit" class="btn btn-base w-auto form-control min-w-180 flex-grow-0"><?php echo e(translate('add_address')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <span id="shippingaddress-storage"
        data-latitude="<?php echo e($default_location ? $default_location['lat'] : '-33.8688'); ?>"
        data-longitude="<?php echo e($default_location ? $default_location['lng'] : '151.2195'); ?>">
    </span>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('public/assets/select2/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('assets/js/account-address-add.js')); ?>"></script>

    <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(getWebConfig(name: 'map_api_key')); ?>&callback=initAutocomplete&libraries=places&v=3.49" defer></script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('theme-views.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitede1/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/users-profile/account-address-add.blade.php ENDPATH**/ ?>