<?php if(isset($web_config['announcement']) && $web_config['announcement']['status']==1): ?>
    <div class="offer-bar" data-bg-img="<?php echo e(theme_asset('assets/img/media/top-offer-bg.png')); ?>">
        <div class="d-flex py-2 gap-2 align-items-center">
            <div class="offer-bar-close px-2">
                <i class="bi bi-x-lg"></i>
            </div>
            <div class="top-offer-text flex-grow-1 d-flex justify-content-center fw-semibold text-center">
                <?php echo e($web_config['announcement']['announcement']); ?>

            </div>
        </div>
    </div>
<?php endif; ?>
<header class="bg--dark header-middle">
    <div class="container">
        <div class="text-capitalize">
            <ul class="header-right-icons d-flex justiy-content-between">
                <li class="me-auto">
                    <a href="tel:<?php echo e($web_config['phone']->value); ?>" class="text-dark d-flex align-items-center gap-1">
                        <img class="invert" loading="lazy" width="14" src="<?php echo e(theme_asset('assets/img/footer/address/phone.png')); ?>" alt="<?php echo e(translate('address')); ?>">
                        <span><?php echo e($web_config['phone']->value); ?></span>
                    </a>
                </li>
                <li class="dropdown">
                    <a href="javascript:" data-bs-toggle="dropdown">
                        <i class=""><?php echo e(session('currency_symbol')); ?></i>
                        <i class="ms-1 text-small bi bi-chevron-down"></i>
                    </a>
                    <div class="dropdown-menu __dropdown-menu">
                        <ul class="currencies">
                            <?php $__currentLoopData = $web_config['currencies']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="<?php echo e(($currency['code'] == session('currency_code')?'active':'')); ?> currency_change_function"
                                    data-currencycode="<?php echo e($currency['code']); ?>"><?php echo e($currency->name); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <span id="currency-route" data-currency-route="<?php echo e(route('currency.change')); ?>"></span>
                        </ul>
                    </div>
                </li>
                <li class="dropdown">
                    <a href="javascript:" data-bs-toggle="dropdown">
                        <i class="bi bi-translate"></i>
                        <i class="ms-1 text-small bi bi-chevron-down"></i>
                    </a>
                    <div class="dropdown-menu __dropdown-menu">
                        <ul class="language">
                            <?php ( $local = \App\Utils\Helpers::default_lang()); ?>
                            <?php $__currentLoopData = json_decode($language['value'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($data['status']==1): ?>
                                    <li class="change-language" data-action="<?php echo e(route('change-language')); ?>" data-language-code="<?php echo e($data['code']); ?>">
                                        <img loading="lazy" src="<?php echo e(theme_asset('assets/img/flags/'.$data['code'].'.png')); ?>"
                                             alt="<?php echo e($data['name']); ?>">
                                        <span><?php echo e(ucwords($data['name'])); ?></span>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </li>
                <li>
                    <div class="darkLight-switcher d-none d-xl-block">
                        <button type="button" title="<?php echo e(translate('Dark_Mode')); ?>" class="dark_button">
                            <img loading="lazy" class="svg" src="<?php echo e(theme_asset('assets/img/icons/dark.svg')); ?>"
                                    alt="<?php echo e(translate('dark_Mode')); ?>">
                        </button>
                        <button type="button" title="<?php echo e(translate('Light_Mode')); ?>" class="light_button">
                            <img loading="lazy" class="svg" src="<?php echo e(theme_asset('assets/img/icons/light.svg')); ?>"
                                    alt="<?php echo e(translate('light_Mode')); ?>">
                        </button>
                    </div>
                </li>
                <?php if($web_config['business_mode'] == 'multi' && $web_config['seller_registration']): ?>
                    <li class="d-none d-sm-block">
                        <div class="d-flex">
                            <a href="<?php echo e(route('shop.apply')); ?>" class="btn __btn-outline bg-transparent text-white"><?php echo e(translate('become_a_vendor').'.'); ?></a>
                        </div>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</header>
<header class="header-section bg-base">
    <div class="container">
        <div class="header-wrapper">
            <a href="<?php echo e(route('home')); ?>" class="logo me-xl-5">
                <img loading="lazy" class="d-sm-none mobile-logo-cs"
                     src="<?php echo e(getValidImage(path: "storage/app/public/company/".$web_config['mob_logo']->value, type: 'logo')); ?>" alt="<?php echo e(translate('logo')); ?>">
                <img loading="lazy" class="d-none d-sm-block"
                     src="<?php echo e(getValidImage(path: "storage/app/public/company/".$web_config['web_logo']->value, type: 'logo')); ?>" alt="<?php echo e(translate('logo')); ?>">
            </a>
            <div class="menu-area text-capitalize flex-grow-1 ps-xl-4">
                <ul class="menu me-xl-4">
                    <li>
                        <a href="<?php echo e(route('home')); ?>"
                           class="<?php echo e(Request::is('/')?'active':''); ?>"><?php echo e(translate('home')); ?></a>
                    </li>
                    <?php ($categories = \App\Utils\CategoryManager::get_categories_with_counting()); ?>
                    <li>
                        <a href="javascript:"><?php echo e(translate('all_categories')); ?></a>
                        <ul class="submenu">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($key <= 10): ?>
                                    <li>
                                        <a class="py-2"
                                           href="<?php echo e(route('products',['id'=> $category['id'],'data_from'=>'category','page'=>1])); ?>"><?php echo e($category['name']); ?></a>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php if($categories->count() > 10): ?>
                                <li>
                                    <a href="<?php echo e(route('products')); ?>" class="btn-text"><?php echo e(translate('view_all')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <?php if($web_config['brand_setting']): ?>
                        <li>
                            <a href="<?php echo e(route('brands')); ?>"
                               class="<?php echo e(Request::is('brands')?'active':''); ?>"><?php echo e(translate('all_brand')); ?></a>
                        </li>
                    <?php endif; ?>
                    <li>
                        <a href="<?php echo e(route('products',['data_from'=>'discounted','page'=>1])); ?>"
                           class="<?php echo e(request('data_from')=='discounted'?'active':''); ?>">
                            <?php echo e(translate('offers')); ?>

                            <div class="offer-count flower-bg d-flex justify-content-center align-items-center offer-count-custom ">
                                <?php echo e(($web_config['total_discount_products'] < 100 ? $web_config['total_discount_products']:'99+')); ?>

                            </div>
                        </a>
                    </li>

                    <?php if($web_config['business_mode'] == 'multi'): ?>
                        <li>
                            <a href="<?php echo e(route('vendors')); ?>"
                               class="<?php echo e(Request::is('vendors')?'active':''); ?>"><?php echo e(translate('vendors')); ?></a>
                        </li>

                        <?php if($web_config['seller_registration']): ?>
                            <li class="d-sm-none">
                                <a href="<?php echo e(route('shop.apply')); ?>"
                                   class="<?php echo e(Request::is('shop.apply')?'active':''); ?>"><?php echo e(translate('vendor_reg').'.'); ?></a>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>

                </ul>

                <ul class="header-right-icons ms-auto">
                    <li class="d-none d-xl-block">
                        <?php if(auth('customer')->check()): ?>
                            <a href="<?php echo e(route('wishlists')); ?>">
                                <div class="position-relative mt-1 px-8px">
                                    <i class="bi bi-heart"></i>
                                    <span class="btn-status wishlist_count_status"><?php echo e(session()->has('wish_list')?count(session('wish_list')):0); ?></span>
                                </div>
                            </a>
                        <?php else: ?>
                            <a href="javascript:" class="customer_login_register_modal">
                                <div class="position-relative mt-1 px-8px">
                                    <i class="bi bi-heart"></i>
                                    <span class="btn-status"><?php echo e(translate('0')); ?></span>
                                </div>
                            </a>
                        <?php endif; ?>
                    </li>
                    <li id="cart_items" class="d-none d-xl-block">
                        <?php echo $__env->make('theme-views.layouts.partials._cart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </li>
                    <li class="d-xl-none">
                        <a href="javascript:" class="search-toggle">
                            <i class="bi bi-search"></i>
                        </a>
                    </li>
                    <?php if(auth('customer')->check()): ?>
                        <li class="me-2 me-sm-0 dropdown">
                            <a href="javascript:" data-bs-toggle="dropdown">
                                <i class="bi bi-person d-none d-xl-inline-block"></i>
                                <i class="bi bi-person-circle d-xl-none"></i>
                                <span class="mx-1 d-none d-md-block"><?php echo e(auth('customer')->user()->f_name); ?></span>
                                <i class="ms-1 text-small bi bi-chevron-down d-none d-md-block"></i>
                            </a>
                            <div class="dropdown-menu __dropdown-menu">
                                <ul class="language">
                                    <li class="thisIsALinkElement" data-linkpath="<?php echo e(route('account-oder')); ?>">
                                        <img loading="lazy" src="<?php echo e(theme_asset('assets/img/user/shopping-bag.svg')); ?>"
                                             alt="<?php echo e(translate('user')); ?>">
                                        <span><?php echo e(translate('my_order')); ?></span>
                                    </li>
                                    <li class="thisIsALinkElement" data-linkpath="<?php echo e(route('user-profile')); ?>">
                                        <img loading="lazy" src="<?php echo e(theme_asset('assets/img/user/profile.svg')); ?>"
                                             alt="<?php echo e(translate('user')); ?>">
                                        <span><?php echo e(translate('my_profile')); ?></span>
                                    </li>
                                    <li class="thisIsALinkElement" data-linkpath="<?php echo e(route('customer.auth.logout')); ?>">
                                        <img loading="lazy" src="<?php echo e(theme_asset('assets/img/user/logout.svg')); ?>"
                                             alt="<?php echo e(translate('user')); ?>">
                                        <span><?php echo e(translate('sign_Out')); ?></span>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    <?php else: ?>
                        <li class="me-2 me-sm-0">
                            <a href="javascript:" class="customer_login_register_modal">
                                <i class="bi bi-person d-none d-xl-inline-block"></i>
                                <i class="bi bi-person-circle d-xl-none"></i>
                                <span class="mx-1 d-none d-md-block"><?php echo e(translate('login')); ?> / <?php echo e(translate('register')); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <li class="nav-toggle d-xl-none" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
                        aria-controls="offcanvasRight">
                        <span></span>
                        <span></span>
                        <span></span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <div class="mobile-search-form-wrapper">
        <div class="search-form-header d-xl-none">
            <div class="d-flex w-100 align-items-center">
                <form class="search-form m-0 p-0 sidebar-search-form" action="<?php echo e(route('products')); ?>" type="submit">
                    <div class="input-group search_input_group">
                        <svg width="12" class="category-icon" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.5 5.00001C0.367392 5.00001 0.240215 4.94733 0.146447 4.85356C0.0526785 4.75979 0 4.63262 0 4.50001V0.501007C0 0.368399 0.0526785 0.241222 0.146447 0.147454C0.240215 0.0536856 0.367392 0.00100708 0.5 0.00100708H4.5C4.63261 0.00100708 4.75979 0.0536856 4.85355 0.147454C4.94732 0.241222 5 0.368399 5 0.501007V4.50001C5 4.63262 4.94732 4.75979 4.85355 4.85356C4.75979 4.94733 4.63261 5.00001 4.5 5.00001H0.5ZM7.5 5.00001C7.36739 5.00001 7.24021 4.94733 7.14645 4.85356C7.05268 4.75979 7 4.63262 7 4.50001V0.501007C7 0.368399 7.05268 0.241222 7.14645 0.147454C7.24021 0.0536856 7.36739 0.00100708 7.5 0.00100708H11.499C11.6316 0.00100708 11.7588 0.0536856 11.8526 0.147454C11.9463 0.241222 11.999 0.368399 11.999 0.501007V4.50001C11.999 4.63262 11.9463 4.75979 11.8526 4.85356C11.7588 4.94733 11.6316 5.00001 11.499 5.00001H7.5ZM0.5 12C0.367392 12 0.240215 11.9473 0.146447 11.8536C0.0526785 11.7598 0 11.6326 0 11.5V7.50001C0 7.3674 0.0526785 7.24022 0.146447 7.14645C0.240215 7.05269 0.367392 7.00001 0.5 7.00001H4.5C4.63261 7.00001 4.75979 7.05269 4.85355 7.14645C4.94732 7.24022 5 7.3674 5 7.50001V11.5C5 11.6326 4.94732 11.7598 4.85355 11.8536C4.75979 11.9473 4.63261 12 4.5 12H0.5ZM7.5 12C7.36739 12 7.24021 11.9473 7.14645 11.8536C7.05268 11.7598 7 11.6326 7 11.5V7.50001C7 7.3674 7.05268 7.24022 7.14645 7.14645C7.24021 7.05269 7.36739 7.00001 7.5 7.00001H11.499C11.6316 7.00001 11.7588 7.05269 11.8526 7.14645C11.9463 7.24022 11.999 7.3674 11.999 7.50001V11.5C11.999 11.6326 11.9463 11.7598 11.8526 11.8536C11.7588 11.9473 11.6316 12 11.499 12H7.5Z" fill="currentColor"/>
                        </svg>
                        <select class="select2-init header-select2 text-capitalize mobile-search-select-2" id="search_category_value_mobile"
                                name="search_category_value">
                            <option value="all"><?php echo e(translate('all_categories')); ?></option>
                            <?php $__currentLoopData = $web_config['main_categories']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>"><?php echo e($category['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <input type="search" class="form-control action-global-search-mobile" id="input-value-mobile"
                            placeholder="<?php echo e(translate('search_for_items_or_store')); ?>..." name="name" autocomplete="off">

                        <button class="btn btn-base" type="submit"><i class="bi bi-search"></i></button>
                        <div class="card search-card position-absolute z-99 w-100 bg-white d-none top-100 start-0 search-result-box-mobile"></div>
                    </div>
                    <input name="data_from" value="search" hidden>
                    <input name="page" value="1" hidden>
                </form>
            </div>
        </div>
    </div>
</header>

<div class="search-toggle search-togle-overlay"></div>

<div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
    <div class="offcanvas-header justify-content-end">
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body text-capitalize d-flex flex-column">
        <div>
            <ul class="menu scrollY-60 ">
                <li>
                    <a href="<?php echo e(route('home')); ?>"><?php echo e(translate('home')); ?></a>
                </li>
                <li>
                    <a href="javascript:"><?php echo e(translate('all_categories')); ?></a>
                    <ul class="submenu">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($key <= 10): ?>
                                <li>
                                    <a class="py-2"
                                       href="<?php echo e(route('products',['id'=> $category['id'],'data_from'=>'category','page'=>1])); ?>"><?php echo e($category['name']); ?></a>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php if($categories->count() > 10): ?>
                            <li>
                                <a href="<?php echo e(route('products')); ?>" class="btn-text"><?php echo e(translate('view_all')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php if($web_config['brand_setting']): ?>
                    <li>
                        <a href="<?php echo e(route('brands')); ?>"><?php echo e(translate('all_brand')); ?></a>
                    </li>
                <?php endif; ?>
                <li>
                    <a class="d-flex align-items-center gap-2"
                       href="<?php echo e(route('products',['data_from'=>'discounted','page'=>1])); ?>">
                        <?php echo e(translate('offers')); ?>

                        <div class="offer-count flower-bg d-flex justify-content-center align-items-center offer-count-custom">
                            <?php echo e(($web_config['total_discount_products'] < 100 ? $web_config['total_discount_products']:'99+')); ?>

                        </div>
                    </a>
                </li>

                <?php if($web_config['business_mode'] == 'multi'): ?>
                    <li>
                        <a href="<?php echo e(route('vendors')); ?>"><?php echo e(translate('vendors')); ?></a>
                    </li>

                    <?php if($web_config['seller_registration']): ?>
                        <li class="d-sm-none">
                            <a href="<?php echo e(route('shop.apply')); ?>"><?php echo e(translate('vendor_reg').'.'); ?></a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>

            </ul>
        </div>

        <div class="d-flex align-items-center gap-2 justify-content-between py-4 mt-3">
            <span class="text-dark"><?php echo e(translate('theme_mode')); ?></span>
            <div class="theme-bar">
                <button class="light_button active">
                    <img loading="lazy" class="svg" src="<?php echo e(theme_asset('assets/img/icons/light.svg')); ?>"
                         alt="<?php echo e(translate('light_Mode')); ?>">
                </button>
                <button class="dark_button">
                    <img loading="lazy" class="svg" src="<?php echo e(theme_asset('assets/img/icons/dark.svg')); ?>" alt="<?php echo e(translate('dark_Mode')); ?>">
                </button>
            </div>
        </div>

        <?php if(auth('customer')->check()): ?>
            <div class="d-flex justify-content-center mb-2 pb-3 mt-auto px-4">
                <a href="<?php echo e(route('customer.auth.logout')); ?>" class="btn btn-base w-100"><?php echo e(translate('logout')); ?></a>
            </div>
        <?php else: ?>
            <div class="d-flex justify-content-center mb-2 pb-3 mt-auto px-4">
                <a href="javascript:" class="btn btn-base w-100 customer_login_register_modal">
                    <?php echo e(translate('login')); ?> / <?php echo e(translate('register')); ?>

                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/elitedesignbd/ecommerce10.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/layouts/partials/_header.blade.php ENDPATH**/ ?>