<div class="product-card">
    <div class="product-card-inner">
        <div class="img">
            <a href="<?php echo e(route('product',$product->slug)); ?>" class="d-block h-100">
                <img loading="lazy" class="w-100" alt="<?php echo e(translate('product')); ?>"
                     src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.$product['thumbnail'], type: 'product')); ?>">
            </a>
            <?php if(isset($product->created_at) && $product->created_at->diffInMonths(\Carbon\Carbon::now()) < 1): ?>
                <span class="badge badge-title z-2"><?php echo e(translate('new')); ?></span>
            <?php endif; ?>
            <div class="hover-content d-flex justify-content-between">
                <a href="javascript:"><?php echo e(\Illuminate\Support\Str::limit(isset($product->category) ? $product->category->name:'', 7)); ?></a>
                <div class="d-flex flex-wrap justify-content-between align-items-center column-gap-3">
                    <a href="javascript:" data-id="<?php echo e($product->id); ?>" class="d-inline-flex quickView_action">
                        <i class="bi bi-eye"></i>
                    </a>
                    <?php ($wishlist = count($product->wishList)>0 ? 1 : 0); ?>
                    <a href="javascript:" class="d-inline-flex wish-icon addWishlist_function_view_page"
                       data-id="<?php echo e($product->id); ?>">
                        <i class="wishlist_<?php echo e($product->id); ?> bi <?php echo e(($wishlist == 1?'bi-heart-fill text-danger':'bi-heart')); ?>"></i>
                    </a>
                    <div class="rating">
                        <i class="bi bi-star-fill text-star"></i>
                        <span><?php echo e(round($product->reviews->avg('rating') ?? 0,1)); ?></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="cont">
            <h6 class="title">
                <a href="<?php echo e(route('product',$product->slug)); ?>"
                   title="<?php echo e($product['name']); ?>"><?php echo e(Str::limit($product['name'], 18)); ?></a>
            </h6>
            <div class="d-flex align-items-center justify-content-between column-gap-2">
                <h4 class="price flex-wrap">
                    <span><?php echo e(\App\Utils\Helpers::currency_converter($product->unit_price-\App\Utils\Helpers::get_product_discount($product,$product->unit_price))); ?></span>
                    <?php if($product->discount > 0): ?>
                        <del><?php echo e(\App\Utils\Helpers::currency_converter($product->unit_price)); ?></del>
                    <?php endif; ?>
                </h4>
                <?php if(json_decode($product->variation) != null): ?>
                    <span class="btn add-to-cart-btn">
                        <a href="javascript:" data-id="<?php echo e($product['id']); ?>" class="quickView_action">
                            <i class="bi bi-plus"></i>
                        </a>
                    </span>
                <?php else: ?>
                        <?php $product_card_gen_id = rand(11111, 99999); ?>

                    <form class="cart add-to-cart-form-<?php echo e($product['id']); ?>" action="<?php echo e(route('cart.add')); ?>"
                          id="add-to-cart-form-<?php echo e($product_card_gen_id); ?>"
                          data-errormessage="<?php echo e(translate('please_choose_all_the_options')); ?>"
                          data-outofstock="<?php echo e(translate('sorry').', '.translate('out_of_stock')); ?>.">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($product->id); ?>">
                        <input type="number" name="quantity" value="<?php echo e($product->minimum_order_qty ?? 1); ?>"
                               class="form-control product_quantity__qty" hidden>
                    </form>

                    <span class="btn add-to-cart-btn">
                        <a href="javascript:" class="store_vacation_check_function"
                           data-id="<?php echo e($product['id']); ?>"
                           data-added_by="<?php echo e($product['added_by']); ?>"
                           data-user_id="<?php echo e($product['user_id']); ?>"
                           data-action_url="<?php echo e(route('ajax-shop-vacation-check')); ?>"
                           data-product_cart_id="<?php echo e($product_card_gen_id); ?>"
                        >
                            <i class="bi bi-plus"></i>
                        </a>
                    </span>
                <?php endif; ?>
            </div>
            <?php if($product['product_type'] == 'physical'): ?>
                <div class="sold-info d-flex">
                    <span><?php echo e($product->order_details_sum_qty > 0 ? $product->order_details_sum_qty.' '.translate('sold').' /' : ''); ?></span>
                    <span><?php echo e($product->order_details_sum_qty + $product->current_stock); ?> <?php echo e(translate('item')); ?></span>
                </div>
            <?php else: ?>
                <div class="sold-info d-flex">
                    <?php echo e($product->order_details_sum_qty > 0 ? $product->order_details_sum_qty.' '.translate('sold') : ''); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH /home/elitede1/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/partials/_products-list-single-card.blade.php ENDPATH**/ ?>