<?php $__env->startSection('title', translate('all_brands_page').' | '.$web_config['name']->value.' '.translate('ecommerce')); ?>

<?php $__env->startSection('content'); ?>

    <section class="breadcrumb-section pt-20px">
        <div class="container">
            <div class="section-title mb-4">
                <div
                    class="d-flex flex-wrap justify-content-between row-gap-3 column-gap-2 align-items-center search-page-title">
                    <ul class="breadcrumb">
                        <li>
                            <a href="<?php echo e(route('home')); ?>"><?php echo e(translate('home')); ?></a>
                        </li>
                        <li>
                            <a href="javascript:" class="text-base"><?php echo e(translate('brand_List')); ?></a>
                        </li>
                    </ul>
                    <div class="ms-auto ms-md-0">
                        <div class="position-relative select2-prev-icon filter_select_input_div select2-max-width-100">
                            <i class="bi bi-sort-up"></i>
                            <select class="select2-init form-control size-40px text-capitalize goToPageBasedSelectValue"
                                    name="order_by" id="filter_select_input">
                                <option
                                    value="<?php echo e(route('brands',['order_by'=>'asc','search'=>request('search')])); ?>" <?php echo e(request('order_by')=='asc'?'selected':''); ?>>
                                    <?php echo e(translate('sort_by')); ?> : <?php echo e(translate('a_to_z_order')); ?>

                                </option>
                                <option
                                    value="<?php echo e(route('brands',['order_by'=>'desc','search'=>request('search')])); ?>" <?php echo e(request('order_by')=='desc'?'selected':''); ?>>
                                    <?php echo e(translate('sort_by')); ?> : <?php echo e(translate('z_to_a_order')); ?>

                                </option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="search-form-section py-24px">
        <div class="container">
            <form action="<?php echo e(route('brands')); ?>" method="GET">
                <div class="search-form-2 search-form-mobile">
                <span class="icon d-flex">
                    <i class="bi bi-search"></i>
                </span>
                    <input type="text" name="search" value="<?php echo e(request('search')); ?>" class="form-control text-title"
                           placeholder="<?php echo e(translate('search_brand')); ?>" autocomplete="off" required>
                    <button type="submit" class="clear border-0 text-title">
                        <?php if(request('search') != null): ?>
                            <a href="<?php echo e(route('brands')); ?>" class="text-danger"><?php echo e(translate('clear')); ?></a>
                        <?php else: ?>
                            <span><?php echo e(translate('search')); ?></span>
                        <?php endif; ?>
                    </button>
                </div>
            </form>
        </div>
    </section>


    <section class="others-section section-gap py-5">
        <div class="container">
            <div class="row g-4">

                <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-6 col-sm-4 col-md-3 col-xl-brands">
                        <a href="<?php echo e(route('products',['id'=> $brand['id'],'data_from'=>'brand','brand_name'=>str_replace(' ', '_', $brand->name),'page'=>1])); ?>"
                           class="brands-item"  title="<?php echo e($brand->name); ?>">
                            <img loading="lazy" src="<?php echo e(getValidImage(path: 'storage/app/public/brand/'.$brand->image, type:'brand')); ?>"
                                class="img-fluid badge-soft-base" alt="<?php echo e($brand->name); ?>">
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php if($brands->count()==0): ?>
                    <div class="col-12 py-5">
                        <div class="text-center w-100">
                            <div class="text-center mb-5">
                                <img loading="lazy" src="<?php echo e(theme_asset('assets/img/icons/brand.svg')); ?>" alt="<?php echo e(translate('brand')); ?>">
                                <h5 class="my-3 pt-2 text-muted"><?php echo e(translate('brand_Not_Found')); ?>!</h5>
                                <p class="text-center text-muted"><?php echo e(translate('sorry_no_data_found_related_to_your_search')); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="d-flex justify-content-end w-100 overflow-auto mt-3" id="paginator-ajax">
                <?php echo e($brands->links()); ?>

            </div>
        </div>
    </section>

    <?php echo $__env->make('theme-views.partials._how-to-section', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme-views.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitede1/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/product/brands.blade.php ENDPATH**/ ?>