<footer class="footer">
    <div class="container">
        <div class="newsletter-wrapper">
            <div class="newsletter-wrapper-inner">
                <div class="cont">
                    <h5 class="title"><?php echo e(translate('newsletter')); ?></h5>
                    <p><?php echo e(translate('be_the_first_one_to_know_about_discounts_offers_and_events')); ?></p>
                </div>
                <form class="newsletter-form" action="<?php echo e(route('subscription')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="position-relative">
                        <label class="position-relative m-0 d-block">
                            <i class="bi bi-envelope-at envelop-icon"></i>
                            <input type="text" placeholder="<?php echo e(translate('enter_your_email')); ?>" class="form-control" name="subscription_email" required>
                        </label>
                        <button type="submit" class="btn btn-base"><?php echo e(translate('submit')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="footer-top">
        <div class="container"></div>
    </div>

    <div class="footer-bottom">
        <div class="container">
            <div class="pb-3">
                <div class="row">
                    <div class="col-lg-6 border-right-lg">
                        <div class="footer-top-wrapper flex-column">
                            <a href="<?php echo e(route('home')); ?>" class="logo">
                                <img loading="lazy" alt="<?php echo e(translate('logo')); ?>"
                                     src="<?php echo e(getValidImage(path: 'storage/app/public/company/'.$web_config['footer_logo']->value, type:'logo')); ?>">
                            </a>
                            <div class="content line-limit w-100">
                                <p class="txt"></p>
                                <?php echo e(Str::limit((strip_tags(str_replace('&nbsp;', ' ', json_decode($web_config['about'])->value))), 180)); ?>

                                <a href="<?php echo e(route('about-us')); ?>"><?php echo e(translate('read_more')); ?></a>
                            </div>
                        </div>
                        <div class="footer-address">
                            <div class="footer-address-card d-flex gap-3">
                                <img loading="lazy" src="<?php echo e(theme_asset('assets/img/footer/address/pin.png')); ?>" alt="<?php echo e(translate('address')); ?>">
                                <div>
                                    <h6 class="name"><?php echo e(translate('address')); ?></h6>
                                    <a href="https://www.google.com/maps/place/<?php echo e(getWebConfig(name: 'shop_address')); ?>" target="_blank"
                                        class="text-dark"><?php echo e(getWebConfig(name: 'shop_address')); ?>

                                    </a>
                                </div>
                            </div>
                            <div class="footer-address-card d-flex gap-3">
                                <img loading="lazy" src="<?php echo e(theme_asset('assets/img/footer/address/envelop.png')); ?>" alt="<?php echo e(translate('address')); ?>">
                                <div>
                                    <h6 class="name"><?php echo e(translate('email')); ?></h6>
                                    <a class="text-dark" href="mailto:<?php echo e($web_config['email']->value); ?>"><?php echo e($web_config['email']->value); ?></a>
                                </div>
                            </div>
                            <div class="footer-address-card d-flex gap-3">
                                <img loading="lazy" src="<?php echo e(theme_asset('assets/img/footer/address/phone.png')); ?>" alt="<?php echo e(translate('address')); ?>">
                                <div>
                                    <h6 class="name"><?php echo e(translate('hotline')); ?></h6>
                                    <div><a href="tel:<?php echo e($web_config['phone']->value); ?>" class="text-dark"><?php echo e($web_config['phone']->value); ?></a></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="ps-xl-5">
                            <div class="footer-bottom-wrapper text-capitalize">
                                <div class="footer-widget">
                                    <h5 class="title"><?php echo e(translate('accounts')); ?></h5>
                                    <ul class="links">
                                        <li>
                                            <?php if(auth('customer')->check()): ?>
                                                <a href="<?php echo e(route('user-profile')); ?>"><?php echo e(translate('profile_info')); ?></a>
                                            <?php else: ?>
                                                <a href="javascript:" class="customer_login_register_modal"><?php echo e(translate('profile_info')); ?></a>
                                            <?php endif; ?>
                                        </li>
                                        <li>
                                            <?php if(auth('customer')->check()): ?>
                                                <a href="<?php echo e(route('account-oder')); ?>"><?php echo e(translate('orders')); ?></a>
                                            <?php else: ?>
                                                <a href="javascript:" class="customer_login_register_modal"><?php echo e(translate('orders')); ?></a>
                                            <?php endif; ?>
                                        </li>

                                        <?php if($web_config['ref_earning_status']): ?>
                                        <li>
                                            <?php if(auth('customer')->check()): ?>
                                                <a href="<?php echo e(route('refer-earn')); ?>"><?php echo e(translate('refer_&_earn')); ?></a>
                                            <?php else: ?>
                                                <a href="javascript:" class="customer_login_register_modal"><?php echo e(translate('refer_&_earn')); ?></a>
                                            <?php endif; ?>
                                        </li>
                                        <?php endif; ?>

                                        <li>
                                            <a href="<?php echo e(route('helpTopic')); ?>"><?php echo e(translate('FAQs')); ?></a>
                                        </li>

                                    </ul>
                                </div>
                                <div class="footer-widget ">
                                    <h5 class="title"><?php echo e(translate('quick_links')); ?></h5>
                                    <ul class="links">
                                        <li>
                                            <a href="<?php echo e(route('about-us')); ?>"><?php echo e(translate('about_us')); ?></a>
                                        </li>
                                        <?php if($web_config['business_mode'] == 'multi'): ?>
                                        <li>
                                            <a href="<?php echo e(route('shop.apply')); ?>"><?php echo e(translate('sell_on')); ?> <?php echo e($web_config['name']->value); ?></a>
                                        </li>
                                        <?php endif; ?>
                                        <?php if(isset($web_config['refund_policy']['status']) && $web_config['refund_policy']['status'] == 1): ?>
                                            <li>
                                                <a href="<?php echo e(route('refund-policy')); ?>"><?php echo e(translate('refund_policy')); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(isset($web_config['cancellation_policy']['status']) && $web_config['cancellation_policy']['status'] == 1): ?>
                                            <li>
                                                <a href="<?php echo e(route('cancellation-policy')); ?>"><?php echo e(translate('cancellation_policy')); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(isset($web_config['return_policy']['status']) && $web_config['return_policy']['status'] == 1): ?>
                                            <li>
                                                <a href="<?php echo e(route('return-policy')); ?>"><?php echo e(translate('return_policy')); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                                <div class="footer-widget">
                                    <h5 class="title"><?php echo e(translate('support')); ?></h5>
                                    <ul class="links">
                                        <li>
                                            <?php if(auth('customer')->check()): ?>
                                                <a href="<?php echo e(route('chat', ['type' => 'seller'])); ?>"><?php echo e(translate('live_chat')); ?></a>
                                            <?php else: ?>
                                                <a href="javascript:" class="customer_login_register_modal"><?php echo e(translate('live_chat')); ?></a>
                                            <?php endif; ?>
                                        </li>
                                        <li>
                                            <?php if(auth('customer')->check()): ?>
                                                <a href="<?php echo e(route('account-tickets')); ?>"><?php echo e(translate('support_ticket')); ?></a>
                                            <?php else: ?>
                                                <a href="javascript:" class="customer_login_register_modal"><?php echo e(translate('support_ticket')); ?></a>
                                            <?php endif; ?>
                                        </li>
                                        <li>
                                            <a href="<?php echo e(route('track-order.index')); ?>"><?php echo e(translate('track_order')); ?></a>
                                        </li>
                                        <li>
                                            <a href="<?php echo e(route('contacts')); ?>"><?php echo e(translate('contact_us')); ?></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="border-top py-20px">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-6">
                        <h5 class="footer-tags-title text-capitalize"><?php echo e(translate('popular_tags')); ?></h5>
                        <ul class="tags">

                            <?php $__currentLoopData = $web_config['tags']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(route('products')); ?>?search_category_value=all&name=<?php echo e(str_replace(' ','+', trim($item->tag))); ?>&data_from=search&page=1"><?php echo e($item->tag); ?></a>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php if($web_config['tags']->count() == 0): ?>
                            <li>
                                <a href="javascript:"><?php echo e(translate('no_Data_Found')); ?></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="col-lg-6">
                        <div class="ps-xl-5">
                            <?php if($web_config['android']['status'] || $web_config['ios']['status']): ?>
                            <h5 class="footer-tags-title text-capitalize"><?php echo e(translate('download_our_app')); ?></h5>
                            <div class="app-btns">
                                <?php if($web_config['android']['status']): ?>
                                    <a href="<?php echo e($web_config['android']['link']); ?>">
                                        <img loading="lazy" src="<?php echo e(theme_asset('assets/img/app-btn/google.png')); ?>"
                                             alt="<?php echo e(translate('google')); ?>">
                                    </a>
                                <?php endif; ?>

                                <?php if($web_config['ios']['status']): ?>
                                    <a href="<?php echo e($web_config['ios']['link']); ?>">
                                        <img loading="lazy" src="<?php echo e(theme_asset('assets/img/app-btn/apple.png')); ?>"
                                             alt="<?php echo e(translate('apple')); ?>">
                                    </a>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="bg-base py-4">
            <div class="container">
                <div class="d-flex justify-content-evenly gap-4 justify-content-md-between flex-wrap">
                    <div class="text-center text-white">
                        <?php echo e($web_config['copyright_text']->value); ?>

                    </div>
                    <ul class="links d-flex flex-wrap justify-content-center me-md-auto column-gap-4 row-gap-1">
                        <li>
                            <a href="<?php echo e(route('terms')); ?>" class="text-white"><?php echo e(translate('terms_&_conditions')); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('privacy-policy')); ?>" class="text-white"><?php echo e(translate('privacy_policy')); ?></a>
                        </li>
                    </ul>
                    <?php if($web_config['social_media']): ?>
                    <ul class="social-icons">
                        <?php $__currentLoopData = $web_config['social_media']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <?php if($item->name == "twitter"): ?>
                                    <a href="<?php echo e($item->link); ?>" target="_blank" class="font-bold">
                                        <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="18" height="18" viewBox="0 0 24 24">
                                        <g opacity=".3"><polygon fill="#fff" fill-rule="evenodd" points="16.002,19 6.208,5 8.255,5 18.035,19" clip-rule="evenodd"></polygon><polygon points="8.776,4 4.288,4 15.481,20 19.953,20 8.776,4"></polygon></g><polygon fill-rule="evenodd" points="10.13,12.36 11.32,14.04 5.38,21 2.74,21" clip-rule="evenodd"></polygon><polygon fill-rule="evenodd" points="20.74,3 13.78,11.16 12.6,9.47 18.14,3" clip-rule="evenodd"></polygon><path d="M8.255,5l9.779,14h-2.032L6.208,5H8.255 M9.298,3h-6.93l12.593,18h6.91L9.298,3L9.298,3z"  fill="currentColor"></path>
                                        </svg>
                                    </a>
                                <?php else: ?>
                                    <a href="<?php echo e($item->link); ?>" target="_blank">
                                        <i class="<?php echo e($item->icon); ?>"></i>
                                    </a>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH /home/elitede1/ecom11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/layouts/partials/_footer.blade.php ENDPATH**/ ?>