<?php use App\Utils\Helpers; ?>


<?php $__env->startSection('title', translate('payment').' | '.$web_config['name']->value.' '.translate('ecommerce')); ?>

<?php $__env->startSection('content'); ?>

    <section class="breadcrumb-section pt-20px">
        <div class="container">
            <div class="section-title mb-4">
                <div
                    class="d-flex flex-wrap justify-content-between row-gap-3 column-gap-2 align-items-center search-page-title">
                    <ul class="breadcrumb">
                        <li>
                            <a href="<?php echo e(route('home')); ?>"><?php echo e(translate('home')); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('shop-cart')); ?>"><?php echo e(translate('cart')); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('checkout-details')); ?>"><?php echo e(translate('checkout')); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(url()->current()); ?>"><?php echo e(translate('payment')); ?></a>
                        </li>
                    </ul>
                    <div class="ms-auto ms-md-0">
                        <?php if(auth('customer')->check()): ?>
                            <a href="<?php echo e(route('shop-cart')); ?>" class="text-base custom-text-link">
                                <?php echo e(translate('check_All_CartList')); ?>

                            </a>
                        <?php else: ?>
                            <a href="javascript:" class="text-base custom-text-link customer_login_register_modal">
                                <?php echo e(translate('check_All_CartList')); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="payment-section section-gap pt-4">
        <div class="container">
            <h3 class="d-flex justify-content-center justify-content-sm-start mb-3 mb-lg-4"><?php echo e(translate('payment')); ?></h3>
            <div class="row g-4">
                <div class="col-lg-7">
                    <ul class="checkout-flow">
                        <li class="checkout-flow-item active">
                            <a href="<?php echo e(route('shop-cart')); ?>">
                                <span class="serial"><?php echo e(translate('1')); ?></span>
                                <span class="icon">
                                    <i class="bi bi-check"></i>
                                </span>
                                <span class="text"><?php echo e(translate('cart')); ?></span>
                            </a>
                        </li>
                        <li class="line"></li>
                        <li class="checkout-flow-item active">
                            <a href="<?php echo e(route('checkout-details')); ?>">
                                <span class="serial"><?php echo e(translate('2')); ?></span>
                                <span class="icon">
                                    <i class="bi bi-check"></i>
                                </span>
                                <span class="text text-capitalize"><?php echo e(translate('shipping_details')); ?></span>
                            </a>
                        </li>
                        <li class="line"></li>
                        <li class="checkout-flow-item current">
                            <a href="javascript:">
                                <span class="serial"><?php echo e(translate('3')); ?></span>
                                <span class="icon">
                                    <i class="bi bi-check"></i>
                                </span>
                                <span class="text"><?php echo e(translate('payment')); ?></span>
                            </a>
                        </li>
                    </ul>
                    <div class="delivery-information">
                        <h6 class="font-bold letter-spacing-0 title mb-20px text-capitalize"><?php echo e(translate('select_payment_method')); ?></h6>
                        <div class="payment-area">
                            <?php if(!$cod_not_show && $cash_on_delivery['status']): ?>
                                <label class="payment-item">
                                    <form action="<?php echo e(route('checkout-complete')); ?>" method="get">
                                        <input type="hidden" name="payment_method" value="cash_on_delivery">
                                        <div class="payment-item-card">
                                            <img loading="lazy" src="<?php echo e(theme_asset('assets/img/checkout/cash-on.png')); ?>" class="icon"
                                                 alt="<?php echo e(translate('checkout')); ?>">
                                            <button class="content bg-white border-0">
                                                <h6 class="subtitle text-start"><?php echo e(translate('cash_on_delivery')); ?></h6>
                                                <p class="text-start">
                                                    <?php echo e(translate('please_contact_with_deliveryman_to_confirm_your_pay_and_receive_your_order.')); ?>

                                                </p>
                                            </button>

                                        </div>
                                    </form>
                                </label>
                            <?php endif; ?>

                            <?php if($digital_payment['status']==1): ?>
                                <label class="payment-item">
                                    <input type="radio" name="payment-method">
                                    <div class="payment-item-card">
                                        <div class="digital_payment_btn">
                                            <img loading="lazy" src="<?php echo e(theme_asset('assets/img/checkout/card-pos.png')); ?>" class="icon"
                                                 alt="<?php echo e(translate('checkout')); ?>">
                                        </div>
                                        <div class="content">
                                            <div class="digital_payment_btn">
                                                <h6 class="subtitle"><?php echo e(translate('digital_payment')); ?></h6>
                                                <p>
                                                    <?php echo e(translate('please_confirm_your_verified_account_to_pay_through_your_bank_account')); ?>

                                                </p>
                                            </div>
                                            <div class="d--none" id="digital_payment">
                                                <div class="mt-3 row d-flex gap-2">
                                                    <?php if(auth('customer')->check() && $wallet_status==1): ?>
                                                        <div class="col-xl-3 col-md-4 col-sm-6">
                                                            <label class="digital-payment-card card">
                                                                <button
                                                                    class="bg-transparent border-0 h-100 w-100 d-flex justify-content-center"
                                                                    type="submit" data-bs-toggle="modal"
                                                                    data-bs-target="#wallet_submit_button">
                                                                    <img loading="lazy" width="25"
                                                                         src="<?php echo e(theme_asset('assets/img/icons/wallet-img.png')); ?>"
                                                                         class="dark-support" alt="<?php echo e(translate('wallet')); ?>">
                                                                    <span
                                                                        class="info text-title"><?php echo e(translate('wallet')); ?></span>
                                                                </button>
                                                            </label>
                                                        </div>
                                                    <?php endif; ?>

                                                    <?php $__currentLoopData = $payment_gateways_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-xl-3 col-md-4 col-sm-6">
                                                            <div
                                                                class="digital-payment-card card d-flex align-items-center justify-content-center overflow-hidden">
                                                                <form method="post"
                                                                      action="<?php echo e(route('customer.web-payment-request')); ?>">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="user_id"
                                                                           value="<?php echo e(auth('customer')->check() ? auth('customer')->user()->id : session('guest_id')); ?>">
                                                                    <input type="hidden" name="customer_id"
                                                                           value="<?php echo e(auth('customer')->check() ? auth('customer')->user()->id : session('guest_id')); ?>">
                                                                    <input type="hidden" name="payment_method"
                                                                           value="<?php echo e($payment_gateway->key_name); ?>">
                                                                    <input type="hidden" name="payment_platform"
                                                                           value="web">

                                                                    <?php if($payment_gateway->mode == 'live' && isset($payment_gateway->live_values['callback_url'])): ?>
                                                                        <input type="hidden" name="callback"
                                                                               value="<?php echo e($payment_gateway->live_values['callback_url']); ?>">
                                                                    <?php elseif($payment_gateway->mode == 'test' && isset($payment_gateway->test_values['callback_url'])): ?>
                                                                        <input type="hidden" name="callback"
                                                                               value="<?php echo e($payment_gateway->test_values['callback_url']); ?>">
                                                                    <?php else: ?>
                                                                        <input type="hidden" name="callback" value="">
                                                                    <?php endif; ?>

                                                                    <input type="hidden" name="external_redirect_link"
                                                                           value="<?php echo e(url('/').'/web-payment'); ?>">
                                                                    <?php ($additional_data = $payment_gateway['additional_data'] != null ? json_decode($payment_gateway['additional_data']) : []); ?>
                                                                    <button class="bg-transparent border-0 h-100 w-100"
                                                                            type="submit">
                                                                        <img loading="lazy" width="100" class="dark-support" alt="<?php echo e(translate('gateway')); ?>"
                                                                             src="<?php echo e(getValidImage(path: 'storage/app/public/payment_modules/gateway_image/'.($additional_data != null ? ($additional_data->gateway_image ?? '') : ''), type:'banner')); ?>">
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    <?php if(isset($offline_payment) && $offline_payment['status']): ?>
                                                        <div class="col-xl-3 col-md-4 col-sm-6">
                                                            <form
                                                                action="<?php echo e(route('offline-payment-checkout-complete')); ?>"
                                                                method="get">
                                                                <div class="digital-payment-card card">
                                                                    <input type="hidden" name="weight">
                                                                    <span class="bg-transparent border-0 h-100 w-100"
                                                                          data-bs-toggle="modal"
                                                                          data-bs-target="#offline_payment_submit_button">
                                                                    <img loading="lazy" width="100"
                                                                         src="<?php echo e(theme_asset('assets/img/payment/pay-offline.png')); ?>"
                                                                         class="dark-support" alt="<?php echo e(translate('offline_payments')); ?>">
                                                                </span>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div
                                                class="d-flex digital_payment_btn flex-wrap flex-md-nowrap justify-content-between align-items-center mt-3 row-gap-3 column-gap-3">
                                                <span><?php echo e(translate('pay_with_secure_Digital_payment_gateways')); ?></span>
                                                <img loading="lazy" src="<?php echo e(theme_asset('assets/img/checkout/payment-methods.png')); ?>"
                                                     class="mw-100" alt="<?php echo e(translate('checkout')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </label>
                            <?php endif; ?>

                            <?php if($digital_payment['status']==1): ?>
                                <?php if(auth('customer')->check() && $wallet_status==1): ?>
                                    <div class="modal fade" id="wallet_submit_button">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header px-sm-5">
                                                    <h5 class="modal-title"
                                                        id="exampleModalLongTitle"><?php echo e(translate('wallet_payment')); ?></h5>
                                                    <button type="button" class="btn-close outside"
                                                            data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <?php ($customer_balance = auth('customer')->user()->wallet_balance); ?>
                                                <?php ($remain_balance = $customer_balance - $amount); ?>
                                                <form action="<?php echo e(route('checkout-complete-wallet')); ?>" method="get"
                                                      class="needs-validation">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="modal-body px-sm-5">
                                                        <div class="form-group mb-2">
                                                            <label
                                                                class="form-label mb-2"><?php echo e(translate('your_current_balance')); ?></label>
                                                            <input class="form-control" type="text"
                                                                   value="<?php echo e(Helpers::currency_converter($customer_balance)); ?>"
                                                                   readonly>
                                                        </div>

                                                        <div class="form-group mb-2">
                                                            <label
                                                                class="form-label mb-2"><?php echo e(translate('order_amount')); ?></label>
                                                            <input class="form-control" type="text"
                                                                   value="<?php echo e(Helpers::currency_converter($amount)); ?>"
                                                                   readonly>
                                                        </div>
                                                        <div class="form-group mb-2">
                                                            <label
                                                                class="form-label mb-2"><?php echo e(translate('remaining_balance')); ?></label>
                                                            <input class="form-control" type="text"
                                                                   value="<?php echo e(Helpers::currency_converter($remain_balance)); ?>"
                                                                   readonly>
                                                            <?php if($remain_balance<0): ?>
                                                                <label
                                                                    class="__color-crimson"><?php echo e(translate('you_do_not_have_sufficient_balance_for_pay_this_order!!')); ?></label>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer py-2 gap-1 px-sm-5">
                                                        <button type="button"
                                                                class="update_cart_button fs-16 btn btn-base secondary-color"
                                                                data-bs-dismiss="modal">
                                                            <?php echo e(translate('close')); ?>

                                                        </button>
                                                        <button type="submit"
                                                                class="update_cart_button fs-16 btn btn-base" <?php echo e($remain_balance>0? '':'disabled'); ?>>
                                                            <?php echo e(translate('submit')); ?>

                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="modal fade offline-payment-modal" id="offline_payment_submit_button">
                                    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header px-sm-5">
                                                <h5 class="modal-title"
                                                    id="exampleModalLongTitle"><?php echo e(translate('offline_payment')); ?></h5>
                                                <button type="button" class="btn-close outside" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                            </div>
                                            <form action="<?php echo e(route('offline-payment-checkout-complete')); ?>" method="post"
                                                  class="needs-validation">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-body p-3 p-md-5">

                                                    <div class="text-center px-5">
                                                        <img loading="lazy" src="<?php echo e(theme_asset('assets/img/offline-payments.png')); ?>"
                                                             alt="<?php echo e(translate('offline_payments')); ?>">
                                                        <p class="py-2">
                                                            <?php echo e(translate('pay_your_bill_using_any_of_the_payment_method_below_and_input_the_required_information_in_the_form')); ?>

                                                        </p>
                                                    </div>

                                                    <div class="">
                                                        <select class="form-select" id="pay_offline_method"
                                                                name="payment_by" required>
                                                            <option
                                                                value=""><?php echo e(translate('select_Payment_Method')); ?></option>
                                                            <?php $__currentLoopData = $offline_payment_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option
                                                                    value="<?php echo e($method->id); ?>"><?php echo e(translate('payment_Method')); ?>

                                                                    :
                                                                    <?php echo e($method->method_name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>

                                                    <div class="" id="method-filed__div">
                                                        <div class="text-center py-5">
                                                            <img loading="lazy" class="pt-5"
                                                                 src="<?php echo e(theme_asset('assets/img/offline-payments-vectors.png')); ?>"
                                                                 alt="<?php echo e(translate('offline_payments')); ?>">
                                                            <p class="py-2 pb-5 text-muted"><?php echo e(translate('select_a_payment_method_first')); ?></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>

                <div class="col-lg-5">
                    <?php echo $__env->make('theme-views.partials._order-summery', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </section>

    <span id="route-pay-offline-method-list" data-route="<?php echo e(route('pay-offline-method-list')); ?>"></span>
    <span id="text-redirecting-to-the-payment" data-text="<?php echo e(translate('Redirecting_to_the_payment')); ?>"></span>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(theme_asset('assets/js/payment-page.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('theme-views.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitede1/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/checkout/payment.blade.php ENDPATH**/ ?>