<div class="close-sidebar d-lg-none">
    <i class="bi bi-x-lg"></i>
</div>

<div class="filter-header d-none d-lg-flex justify-content-between align-items-center">
    <h5 class="subtitle text-base"><i class="bi bi-funnel"></i><span><?php echo e(translate('filter')); ?></span></h5>
    <button type="button" class="btn btn-soft-base fashion_products_list_form_reset">
        <i class="bi bi-arrow-repeat"></i> <?php echo e(translate('reset')); ?>

    </button>
</div>

<?php if(!Request::is('/')): ?>
    <div class="d-lg-none mb-4 text-capitalize">
        <h5 class="mb-2"><?php echo e(translate('filter_by')); ?></h5>
        <div class="position-relative select2-prev-icon d-lg-none">
            <i class="bi bi-sort-up"></i>
            <select class="select2-init-js form-control size-40px filter_select_input filter_by_product_list_mobile"
                    name="sort_by" data-primary_select="<?php echo e(translate('sort_by')); ?> : <?php echo e(translate('default')); ?>">
                <option value="default"><?php echo e(translate('sort_by')); ?> : <?php echo e(translate('default')); ?></option>
                <option value="latest" <?php echo e(request('data_from') == 'latest' ? 'selected':''); ?>><?php echo e(translate('sort_by')); ?>

                    : <?php echo e(translate('latest')); ?></option>
                <option value="a-z"><?php echo e(translate('sort_by')); ?> : <?php echo e(translate('a_to_z_order')); ?></option>
                <option value="z-a"><?php echo e(translate('sort_by')); ?> : <?php echo e(translate('z_to_a_Order')); ?></option>
                <option value="low-high"><?php echo e(translate('sort_by')); ?> : <?php echo e(translate('low_to_high_price')); ?>

                </option>
                <option value="high-low"><?php echo e(translate('sort_by')); ?> : <?php echo e(translate('high_to_low_price')); ?>

                </option>
            </select>
        </div>
    </div>
<?php endif; ?>

<?php if(isset($categories)): ?>
    <div class="widget">
        <div class="widget-header open">
            <h5 class="title text-capitalize"><?php echo e(translate('all_categories')); ?></h5>
            <div class="chevron-icon">
                <i class="bi bi-chevron-down"></i>
            </div>
        </div>
        <div class="widget-body">
            <div class="widget-body-inner">
                <div class="all-categories">

                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form--check">
                            <label class="form--check-inner category_class_for_tag_<?php echo e($category['id']); ?>">
                                <input type="checkbox" name="category[]"
                                       value="<?php echo e($category['id']); ?>" <?php echo e(request('data_from')=='category' && $category['id']==request('id')?'checked' :''); ?>>
                                <span class="check-icon"><i class="bi bi-check"></i></span>
                                <span class="form-check-label"><?php echo e($category['name']); ?></span>
                                <span class="badge badge-soft-base ms-auto"><?php echo e(isset($category->product_count)?$category->product_count:'0'); ?></span>
                            </label>
                            <?php if($category->childes->count() > 0): ?>
                                <div class="form-check-subgroup">
                                    <?php $__currentLoopData = $category->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form--check">
                                            <label class="form--check-inner category_class_for_tag_<?php echo e($child['id']); ?>">
                                                <input type="checkbox" name="category[]" value="<?php echo e($child['id']); ?>">
                                                <span class="check-icon"><i class="bi bi-check"></i></span>
                                                <span class="form-check-label"><?php echo e($child['name']); ?></span>
                                                <span class="badge badge-soft-base ms-auto"><?php echo e(isset($child->sub_category_product_count)?$child->sub_category_product_count:'0'); ?></span>
                                            </label>
                                            <?php if($child->childes->count() > 0): ?>
                                                <div class="form-check-subgroup">
                                                    <?php $__currentLoopData = $child->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="form--check">
                                                            <label class="form--check-inner category_class_for_tag_<?php echo e($ch['id']); ?>">
                                                                <input type="checkbox" name="category[]"
                                                                       value="<?php echo e($ch['id']); ?>">
                                                                <span class="check-icon"><i
                                                                            class="bi bi-check"></i></span>
                                                                <span class="form-check-label"><?php echo e($ch['name']); ?></span>
                                                                <span class="badge badge-soft-base ms-auto"><?php echo e(isset($ch->sub_sub_category_product_count)?$ch->sub_sub_category_product_count:'0'); ?></span>
                                                            </label>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if($web_config['brand_setting']): ?>
    <?php ($brands = isset($brands) ? $brands : \App\Utils\BrandManager::get_active_brands()); ?>
    <?php if(isset($brands)): ?>
        <div class="widget">
            <div class="widget-header open">
                <h5 class="title"><?php echo e(translate('brands')); ?></h5>
                <div class="chevron-icon">
                    <i class="bi bi-chevron-down"></i>
                </div>
            </div>
            <div class="widget-body">
                <div class="widget-body-inner">
                    <div class="all-brands">
                        <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form--check">
                                <label class="form--check-inner brand_class_for_tag_<?php echo e($brand['id']); ?>">
                                    <input type="checkbox" name="brand[]"
                                           value="<?php echo e($brand['id']); ?>" <?php echo e(request('data_from')=='brand' && $brand['id']==request('id')?'checked' :''); ?>>
                                    <span class="check-icon"><i class="bi bi-check"></i></span>
                                    <span class="form-check-label"><?php echo e($brand['name']); ?></span>
                                    <span class="badge badge-soft-base ms-auto"><?php echo e((isset($brand->count)?$brand->count:$brand->brand_products_count) ?? 0); ?></span>
                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>


<div class="widget">
    <div class="widget-header open">
        <h5 class="title text-capitalize"><?php echo e(translate('price_range')); ?></h5>
        <div class="chevron-icon">
            <i class="bi bi-chevron-down"></i>
        </div>
    </div>
    <div class="widget-body">
        <div class="widget-body-inner">
            <div class="price-range-slider px-3">
                <div id="input-slider"></div>
                <div class="d-flex justify-content-between mt-3">
                    <div><?php echo e(session('currency_symbol')); ?><?php echo e(translate('0.00')); ?></div>
                    <div><?php echo e(session('currency_symbol')); ?><?php echo e(translate('10,00000')); ?></div>
                </div>
            </div>
        </div>
    </div>
    <input type="number" class="form-control" name="price_min" id="price-range-start" hidden>
    <input type="number" class="form-control" name="price_max" id="price-range-end" hidden>
</div>

<div class="widget">
    <div class="widget-header open">
        <h5 class="title text-capitalize"><?php echo e(translate('by_review_rating')); ?></h5>
        <div class="chevron-icon">
            <i class="bi bi-chevron-down"></i>
        </div>
    </div>
    <div class="widget-body">
        <div class="widget-body-inner">
            <div class="review-rating-group">
                <label>
                    <input type="checkbox" name="rating[]" value="1">
                    <span class="review_class_for_tag_1">
                        <i class="bi bi-star-fill text-star"></i>
                        <span><?php echo e('1'); ?></span>
                    </span>
                </label>
                <label>
                    <input type="checkbox" name="rating[]" value="2">
                    <span class="review_class_for_tag_2">
                        <i class="bi bi-star-fill text-star"></i>
                        <span><?php echo e('2'); ?></span>
                    </span>
                </label>
                <label>
                    <input type="checkbox" name="rating[]" value="3">
                    <span class="review_class_for_tag_3">
                        <i class="bi bi-star-fill text-star"></i>
                        <span><?php echo e('3'); ?></span>
                    </span>
                </label>
                <label>
                    <input type="checkbox" name="rating[]" value="4">
                    <span class="review_class_for_tag_4">
                        <i class="bi bi-star-fill text-star"></i>
                        <span><?php echo e('4'); ?></span>
                    </span>
                </label>
                <label>
                    <input type="checkbox" name="rating[]" value="5">
                    <span class="review_class_for_tag_5">
                        <i class="bi bi-star-fill text-star"></i>
                        <span><?php echo e('5'); ?></span>
                    </span>
                </label>
            </div>
        </div>
    </div>
</div>

<?php if(isset($colors)): ?>
    <div class="widget">
        <div class="widget-header open">
            <h5 class="title"><?php echo e(translate('color')); ?></h5>
            <div class="chevron-icon">
                <i class="bi bi-chevron-down"></i>
            </div>
        </div>
        <div class="widget-body">
            <div class="widget-body-inner">
                <div class="check-color-group">
                    <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <label>
                            <input type="checkbox" name="colors[]" value="<?php echo e($color); ?>">
                            <span style="--base:<?php echo e($color); ?>">
                        <i class="bi bi-check"></i>
                    </span>
                        </label>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/elitede1/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/partials/products/_products-list-aside.blade.php ENDPATH**/ ?>