<div class="modal fade __sign-in-modal" id="SignInModal" tabindex="-1" aria-labelledby="SignInModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="logo">
                    <a href="javascript:">
                        <img loading="lazy" alt="<?php echo e(translate('logo')); ?>"
                             src="<?php echo e(getValidImage(path: 'storage/app/public/company/'.$web_config['web_logo']->value, type:'logo')); ?>">
                    </a>
                </div>
                <h3 class="title text-capitalize"><?php echo e(translate('sign_in')); ?></h3>
                <form action="<?php echo e(route('customer.auth.login')); ?>" method="post" id="customer_login_modal" autocomplete="off">
                    <?php echo csrf_field(); ?>
                <div class="row g-3">
                    <div class="col-sm-12">
                        <label class="form-label form--label" for="login_email">
                            <?php echo e(translate('email')); ?> / <?php echo e(translate('phone')); ?>

                        </label>
                        <input type="text" class="form-control"
                        name="user_id" id="login_email" value="<?php echo e(old('user_id')); ?>"
                        placeholder="<?php echo e(translate('enter_email_or_phone_number')); ?>" required>
                    </div>
                    <div class="col-sm-12">
                        <label class="form-label form--label" for="login_password"><?php echo e(translate('password')); ?></label>
                        <div class="position-relative">
                            <input type="password" class="form-control" name="password" id="login_password"
                                   placeholder="<?php echo e(translate('ex_:_7+_character')); ?>" required>
                            <div class="js-password-toggle"><i class="bi bi-eye-fill"></i></div>
                        </div>
                    </div>
                    <div class="col-sm-12 text-small">
                        <div class="d-flex justify-content-between gap-1">
                            <label class="form-check m-0">
                                <input type="checkbox" class="form-check-input" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                <span class="form-check-label"><?php echo e(translate('remember_me')); ?></span>
                            </label>
                            <a href="<?php echo e(route('customer.auth.recover-password')); ?>" class="text-base text-capitalize"><?php echo e(translate('forgot_password')); ?> ?</a>
                        </div>
                    </div>

                    <?php if($web_config['recaptcha']['status'] == 1): ?>
                        <div id="recaptcha_element_customer_login" class="w-100 mt-4" data-type="image"></div>
                        <br/>
                    <?php else: ?>
                        <div class="row py-2 mt-4">
                            <div class="col-6 pr-2">
                                <input type="text" class="form-control border __h-40" name="default_recaptcha_id_customer_login" value=""
                                       placeholder="<?php echo e(translate('enter_captcha_value')); ?>" autocomplete="off">
                            </div>
                            <div class="col-6 input-icons mb-2 rounded">
                                <span id="re_captcha_customer_login" class="d-flex align-items-center align-items-center">
                                    <img loading="lazy" src="<?php echo e(URL('/customer/auth/code/captcha/1?captcha_session_id=default_recaptcha_id_customer_login')); ?>" class="input-field rounded __h-40" id="customer_login_recaptcha_id" alt="<?php echo e(translate('captcha')); ?>">
                                    <i class="bi bi-arrow-repeat icon cursor-pointer p-2"></i>
                                </span>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="col-sm-12 text-small">
                        <button type="submit" class="btn btn-block btn-base text-capitalize"><?php echo e(translate('sign_in')); ?></button>
                        <div class="text-center">
                            <?php if($web_config['social_login_text']): ?>
                            <div class="mt-32px mb-3">
                                <?php echo e(translate('or_continue_with')); ?>

                            </div>
                            <?php endif; ?>
                            <div class="d-flex mb-32px justify-content-center gap-4">
                                <?php $__currentLoopData = $web_config['socials_login']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socialLoginService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(isset($socialLoginService) && $socialLoginService['status']==true): ?>
                                        <a href="<?php echo e(route('customer.auth.service-login', $socialLoginService['login_medium'])); ?>">
                                            <img loading="lazy" src="<?php echo e(theme_asset('assets/img/social/'.$socialLoginService['login_medium'].'.svg')); ?>" alt="<?php echo e(translate('social')); ?>">
                                        </a>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="text-capitalize">
                                <?php echo e(translate('enjoy_new_experience')); ?> <a href="javascript:" class="text-base" data-bs-dismiss="modal"
                                                        data-bs-target="#SignUpModal" data-bs-toggle="modal"><?php echo e(translate('sign_up')); ?></a>
                            </div>
                        </div>

                    </div>
                </div>
                </form>
            </div>
        </div>
    </div>
</div>


<?php if($web_config['recaptcha']['status'] == 1): ?>
    <script type="text/javascript">
        "use strict";
        var onloadCallbackCustomerLogin = function () {
            var login_id = grecaptcha.render('recaptcha_element_customer_login', {
                'sitekey': '<?php echo e(getWebConfig(name: 'recaptcha')['site_key']); ?>'
            });
            $('#recaptcha_element_customer_login').attr('data-login-id', login_id);
        };
    </script>
    <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallbackCustomerLogin&render=explicit" async
            defer></script>

<?php else: ?>
    <script type="text/javascript">
        "use strict";
        $('#re_captcha_customer_login').on('click', function(){
            var re_captcha = "<?php echo e(URL('/customer/auth/code/captcha')); ?>";
            re_captcha = re_captcha + "/" + Math.random()+'?captcha_session_id=default_recaptcha_id_customer_login';
            document.getElementById('customer_login_recaptcha_id').src = re_captcha;
        })
    </script>
<?php endif; ?>

<script>
    "use strict";
    $("#customer_login_modal").submit(function (e) {
        e.preventDefault();
        var customer_recaptcha = true;

        <?php if($web_config['recaptcha']['status'] == 1): ?>
        var response_customer_login = grecaptcha.getResponse($('#recaptcha_element_customer_login').attr('data-login-id'));

        if (response_customer_login.length === 0) {
            e.preventDefault();
            toastr.error("<?php echo e(translate('please_check_the_recaptcha')); ?>");
            customer_recaptcha = false;
        }
        <?php endif; ?>

        if(customer_recaptcha === true) {
            let form = $(this);
            $.ajax({
                type: 'POST',
                url:`<?php echo e(route('customer.auth.login')); ?>`,
                data: form.serialize(),
                success: function (data) {
                    if (data.status === 'success') {
                        toastr.success(`<?php echo e(translate('login_successful')); ?>`);
                        data.redirect_url !== '' ? window.location.href = data.redirect_url : location.reload();
                    } else if (data.status === 'error') {
                        data.redirect_url !== '' ? window.location.href = data.redirect_url : toastr.error(data.message);
                    }
                }
            });
        }
    });
</script>
<?php /**PATH /home/elitedesign/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/layouts/partials/modal/_login.blade.php ENDPATH**/ ?>